#!/bin/sh

echo "Performing simple regression tests"
OS=`uname`
RES=0

for POL in *.policy.$OS; do
	PROG=`echo $POL | cut -f1 -d.`
	ARGS=""
	if [ -f $PROG.args ]; then
		ARGS=`cat $PROG.args`
	fi

	echo -n "$PROG:"
	SYSTR_RES=`eval ../systrace -f $POL -a $PROG $ARGS 2>/dev/null`
	#echo "\t(../systrace -f $POL -a $PROG $ARGS)"
	NORM_RES=`$PROG $ARGS`

	if [ -z "$SYSTR_RES" ] ; then
		rm -f id.core
		echo "\tFAILED"
		RES=1
	elif [ "$NORM_RES" != "$SYSTR_RES" ] ; then
		echo "\tExpected \"$NORM_RES\", got \"$SYSTR_RES\""
		RES=1
	else 
		echo "\tOKAY"
	fi

done

exit $RES
