#ifndef CLASSES_H_
#define CLASSES_H_

#include <string.h>
#include <stdio.h>

// #include "km_util.h"

// Single Seq
typedef struct
{
	char *name;
	char *seq;
	size_t size;
	size_t reserved;
}Seq;

Seq*
init_Seq(char *name, int reserve);

void
append(Seq *seq, char *sequence);


// Set of sequences
typedef struct
{
	Seq **seqs;
	size_t  n_seqs;
	size_t reserved;
} SeqSet;


SeqSet*
read_fasta(char *seq_f);

void
delSeqSet(SeqSet *set);

#endif
#ifndef VECTOR_H_
#define VECTOR_H_

#include <stdlib.h>
#include <math.h>
// #include "classes.h"
// #include "km_util.h"

typedef struct
{
	double *data;
	size_t seq_len;
	size_t id;
	size_t assignment;
} Vector;


typedef struct
{
	Vector **vecs;
	size_t n_vecs;
	size_t used;
	size_t dim;
} VectorSet;

Vector *
seq2vec_kmer(const Seq *seq, short k, unsigned int *factor, size_t vec_len, size_t vec_num, short *alphabet, int *used);

VectorSet*
seqset2vecs_kmer(SeqSet *seq_set, short k, short alphabet_size, short *alphabet);

void
delVecSet(VectorSet *set);

#endif
#ifndef STACK_H_
#define STACK_H_

// #include "km_util.h"

typedef struct
{
	size_t size;
	size_t reserved;
	void **data;
	void *last;
} Stack;


Stack*
Stack_init();

void
push(Stack *stack, void *data);

void*
top(Stack *stack);

void *
pop(Stack *stack);

void
delStack(Stack *stack);
#endif
#ifndef KM_UTIL_H_
#define KM_UTIL_H_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <signal.h>

FILE *
my_fopen(char *name_f, char *mode);

void *
my_malloc(size_t size);

void *
my_realloc(void *p, size_t size);

void *
my_calloc ( size_t num, size_t size );


char *
my_make_temp_dir(char *template, char *function, char *file);





#endif

#ifndef KMEANS_H_
#define KMEANS_H_


#include "stdio.h"
#include "float.h"
#include "math.h"

// #include "Vector.h"
// #include "Stack.h"



typedef struct KM_node{
	size_t start;
	size_t end;
	struct KM_node **children;
	size_t id;
	size_t n_children;
} KM_node;


void
delKM_node(KM_node *node);


double
km_sq_dist(const double *vec1, const double *vec2, size_t dim);

/**
 * \brief Initializes the centers by using the kmeans++ initialization.
 * \tparam double The type of data stored in the Vector.
 * \param vecs The set of vectors.
 * \param k The number of centers.
 * \param centers The vector where the centers will be saved in.
 * \param start The start of the position to consider.
 * \param end The end position to consider.
 *
 */
// void
// plusplus_init(const vector<boost::shared_ptr<Vector<double> > > &vecs, unsigned int k, vector<boost::shared_ptr<Vector<double> > > &centers, size_t start, size_t end);


/**
 * \brief Initializes the centers by randomly taking k vectors.
 * \param vecs The set of vectors.
 * \param k The number of centers.
 * \param centers The vector where the centers will be saved in.
 * \param start The start of the position to consider.
 * \param end The end position to consider.
 *
 */
// void
// random_init(const vector<boost::shared_ptr<Vector<double> > > &vecs, unsigned int k, vector<boost::shared_ptr<Vector<double> > > &centers, size_t start, size_t end);


/**
* \brief Initializes the centers using the KKZ method.
* Initialization as proposed in: I. Katsavounidis, C.-C. J. Kuo, and Z. Zhang. A new initialization tech-nique for generalized Lloyd iteration. IEEE Signal Processing Letters, 1(10):144?146, 1994
* Basic idea: It tries to find the most distant points in the dataset from each other using a greedy approach.
* \param vecs The set of vectors.
* \param k The number of centers.
* \param centers The vector where the centers will be saved in.
* \param start The start of the position to consider.
*
*/
VectorSet *
kkz_init(const VectorSet *vec_set, unsigned int k, size_t start, size_t end);



/**
 * \brief Initializes the centers by taking the first k vectors.
 * \param vecs The set of vectors.
 * \param k The number of centers.
 * \param centers The vector where the centers will be saved in.
 * \param start The start of the position to consider.
 *
 */
VectorSet *
first_init(const VectorSet *vec_set, unsigned int k,  size_t start);

int
my_assignment_sort (const void *i, const void *j);

//bool my_assignment_sort (boost::shared_ptr<Vector<unsigned int> > i, boost::shared_ptr<Vector<unsigned int> > j);

/**
 * \brief Repeated clustering until size threshold is met.
 *
 * \param vecs The vectors to cluster.
 * \param k the number of clusters to use.
 * \param init The methods to use for initializing the first centers: "random", "++" or "first"
 * \param error_threshold The change of error to stop kmeans
 */
KM_node*
hierarchical_kmeans(VectorSet *vec_set, unsigned int k, const char *init, double error_threshold);


/**
 * \brief The kmeans clustering algorithm.
 *
 * \param vecs The vectors to cluster.
 * \param k the number of clusters to use.
 * \param init The methods to use for initializing the first centers: "random", "++" or "first"
 * \param error_threshold The change of error to stop kmeans
 */
void
kmeans(VectorSet *vecs, unsigned int k, const char *init, double error_threshold);

/**
 * \brief The kmeans clustering algorithm.
 *
 * \param vecs The vectors to cluster.
 * \param k the number of clusters to use.
 * \param init The methods to use for initializing the first centers: "random", "++" or "first".
 * \param error_threshold The change of error to stop kmeans.
 * \param start The startint point for the clustering.
 * \param end The end point for the clustering.
 */
void
kmeans_sub(const VectorSet *vecs, unsigned int k, const char *init, double error_threshold, size_t start, size_t end);


double
km_common(const double *vec1, const double *vec2, size_t dim);

double
km_angle_dist(const double *vec1, const double *vec2, size_t dim);
#endif


//#include <stdlib.h>
//#include <time.h>

// #include "classes.h"
// #include "kmeans.h"
// #include "Vector.h"

// #include "Stack.h"

#ifdef _OPENMP
	#include<omp.h>
#endif


static char *km_tmp_dir = NULL;
static char *km_cwd =NULL;

typedef struct
{
	KM_node *node;
	size_t id;
}Node_pair;


int
km_coffee_align3(char *seq_f, int k, char *method, char *aln_f, int n_cores, char *init);
/******************************COPYRIGHT NOTICE*******************************/
/* Centro de Regulacio Genomica */
/*and */
/*Cedric Notredame */
/*2012-07-12 19:05:45. */
/*All rights reserved.*/
/*This file is part of T-COFFEE.*/
/**/
/*    T-COFFEE is free software; you can redistribute it and/or modify*/
/*    it under the terms of the GNU General Public License as published by*/
/*    the Free Software Foundation; either version 2 of the License, or*/
/*    (at your option) any later version.*/
/**/
/*    T-COFFEE is distributed in the hope that it will be useful,*/
/*    but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*    GNU General Public License for more details.*/
/**/
/*    You should have received a copy of the GNU General Public License*/
/*    along with Foobar; if not, write to the Free Software*/
/*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA*/
/*...............................................                                                                                      |*/
/*  If you need some more information*/
/*  cedric.notredame@europe.com*/
/*...............................................                                                                                                                                     |*/
/**/
/**/
/*	*/
/******************************COPYRIGHT NOTICE*******************************/
