/* TABLIX, PGA highschool timetable generator                              */
/* Copyright (C) 2002 Tomaz Solc                                           */

/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; either version 2 of the License, or       */
/* (at your option) any later version.                                     */

/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */

/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software             */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/* 
 * AUTHOR:
 *  
 *  Jaume Obrador <obrador@espaiweb.net>
 *
 * DESCRIPTION:
 *
 *  Adds a weight whenever a class doesn't have a free period
 *  when required with property "free-period".
 *
 * DEFINED CLASS RESTRICTIONS:
 *
 *  <restriction type="free-period">day period</restriction>
 *
 *  This restriction specifies that current class should have a free slot 
 *  at day "day" and period "period"
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "modsup.h"
#include "data.h"
#include "gettext.h"

int **freeperiod;

int getfreeperiod(char *type, char *cont, int cid)
{
	int period, day, c;

	c=sscanf(cont, "%d %d", &day, &period);

	if(c<2) {
		strcpy(moderror, _("invalid format of free-period restriction"));
		return(1);
	}

	freeperiod[cid][day*PERIODS+period]=-1;

	return 0;
}

parop class_restrictions[] = { 
	{ type : "free-period", parfunc: getfreeperiod },
	{ type : 0, parfunc: 0 }
};

int init_mod()
{
	int c,b;

	freeperiod=malloc(sizeof(*freeperiod)*cmapnum);

	for(c=0;c<cmapnum;c++) {
		freeperiod[c]=malloc(sizeof(*freeperiod[c])*TIMES);
		for(b=0;b<TIMES;b++) {
			freeperiod[c][b]=0;
		}
	}
	
	return 0;
}

int grade_function(chromo *t, int *cpnt, int *tpnt, int **start, int **lead)
{
	int a,c;
	int sum;

	sum=0;

        for(c=0;c<cmapnum;c++) {
	  for(a=0;a<TIMES;a++) {
	    if (*cpnt!=-1 && freeperiod[c][a]==-1) {
	      sum++;
	    }
	    cpnt++;     
	  }
        }
	return(sum);
};

