/* TABLIX, PGA highschool timetable generator                              */
/* Copyright (C) 2002 Tomaz Solc                                           */

/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; either version 2 of the License, or       */
/* (at your option) any later version.                                     */

/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */

/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software             */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/* $Id: data.h,v 1.21 2004/10/17 16:52:32 avian Exp $ */

#include "config.h"

#ifndef _DATA_H
#define _DATA_H

/* Maximum number of classes/teachers & other stuff. Not so important. */
/* Currently just sizes of arrays. Should not be used for anything else */
/* cmapnum, tmapnum, smapnum & rmapnum should now be used */

#define CIDS            100
#define TIDS            100
#define MAXSUBJECTS     100
#define MAXCAP          100
#define ROOMS           100

/* This isn't a hard limit anymore. More memory gets allocated if needed. */
#define TUPLEMAX        1000

/* How much time/space can we use? */

#define PERIODS         periods
#define DAYS            days

/* DAYS*PERIODS */
#define TIMES           times		

struct _teacher {
        char *name;
};

typedef struct _teacher teacher;

struct _subject {
        char *title;
        int tid;
};

typedef struct _subject subject;

struct _group {
        char *name;
        int year;
};

typedef struct _group group;

struct _classroom {
        char *id;
};

typedef struct _classroom classroom;

struct _tuple {
        int tid;
        int cid;
        int sid;
        int imut_time;
        int imut_room;
};

typedef struct _tuple tuple;

/* *** WARNING *** Any change to this struct will break the migration code */

struct _gen {
        int time;
        int room;
};

typedef struct _gen gen;

struct _chromo {
        gen *inf;
        int grade;
        int *subtotals;
        int possible;
};

typedef struct _chromo chromo;

/* status: 0 - free period
 * 	   1 - conflicting period
 * 	   2 - non-free period 		*/
struct _outputext {
	int status;
	int *tuples;
	int num;
};

typedef struct _outputext outputext;

extern int *cextbuff;
extern int *textbuff;

extern teacher *tmap;
extern int tmapnum;

extern subject *smap;
extern int smapnum;

extern int cmapnum;
extern group *cmap;

extern classroom *rmap;
extern int rmapnum;

extern tuple *tuplemap;
extern int tuplenum;
extern int tuplemut;

extern int days;
extern int periods;
extern int times;

extern int posweight;

extern char *school_name;
extern char *school_address;
extern char *author;

void extend_chromo(chromo *t);
void textend_chromo(chromo *t);
outputext *oextend_chromo(chromo *t);

int add_tuple(int tid, int cid, int sid, int uid);
int add_tuple_imut(int tid, int cid, int sid, int time, int room);
void free_tuple();
int find_tuple(int uid);

int add_room(char *id);
int find_room(char *id);
void free_building();

int add_teacher(char *name);
int find_teacher(char *name);
void free_teachers();

int add_subject(char *title, int tid);
int find_subject(char *title, char *teacher);
void free_subjects();

int add_class(char *name, int year);
int find_class(char *name, int year);

void data_init();
void data_exit();

#endif
