/* TABLIX, PGA highschool timetable generator                              */
/* Copyright (C) 2002 Tomaz Solc                                           */

/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; either version 2 of the License, or       */
/* (at your option) any later version.                                     */

/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */

/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software             */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/* $Id: output.c,v 1.21 2004/08/10 13:50:53 avian Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <dlfcn.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#undef HAVE_LIBPVM3

#include "data.h"
#include "error.h"
#include "xmlsup.h"

#include "gettext.h"

char *cmd;
chromo *parentpop;

char moderror[256];

void (*output_func)(chromo *t, int *cpnt, int *tpnt, char *options, FILE* out, outputext *opnt);

void print_copyright()
{
        printf("\n");
        printf(_("\
This program is free software; you can redistribute it and/or modify\n\
it under the terms of the GNU General Public License as published by\n\
the Free Software Foundation; either version 2 of the License, or\n\
(at your option) any later version.\n"));
        printf("\n");
        printf(_("\
This program is distributed in the hope that it will be useful,\n\
but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n\
GNU General Public License for more details.\n"));
        printf("\n");
        printf(_("\
You should have received a copy of the GNU General Public License\n\
along with this program; if not, write to the Free Software\n\
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA\n"));
        printf("\n");

        printf("$Id: output.c,v 1.21 2004/08/10 13:50:53 avian Exp $\n");
        exit(0);
}

void print_syntax()
{
        printf(_("Usage: %s [OPTION]... [FORMAT] [FILE]\n"), cmd);
        printf("\n");
        printf(_("\
  -o FILE               write output to file FILE instead of stdout\n\
  -h                    display this help\n\
  -v                    display version and copyright information\n\
  -s OPTIONS            pass OPTIONS to the export module\n\
  -d LEVEL              verbosity level (default 2)\n"));

        printf("\n");
	/*
        printf(_("\
Known output formats:\n\
  html                  default HTML\n\
  htmlcss               XHTML 1.1 using CSS and UTF-8 encoding (use this if\n\
                        some characters do not display correctly in browser)\n"));
        printf("\n"); */
        printf(_("Please report bugs to <tomaz.solc@siol.net>.\n"));
        exit(0);
}

void load_output_module(char *name)
{
	void *handle;
	char pathname[1024];

	snprintf(pathname, 1024, "%s/export_%s.so", HAVE_MODULE_PATH, name);
	handle=dlopen(pathname, RTLD_NOW);

	if(!handle) fatal(dlerror());

	output_func=dlsym(handle, "output_function");

	if(output_func==NULL) fatal(dlerror());
}

int main(int argc, char *argv[])
{
        int c;

        char xmlsrc[256];
        char *output;
	char *options;

        FILE *out;

	outputext *opnt;

	#if ENABLE_NLS
	setlocale (LC_ALL, "");
	bindtextdomain (PACKAGE, LOCALEDIR);
	textdomain (PACKAGE);
	#endif

	output=NULL;
	options=NULL;

        cmd=argv[0];
	curmodule="tablix_output";
	verbosity=102;
	
        fprintf(stderr, _("TABLIX version %s, PGA highschool timetable generator\n"), VERSION);
        fprintf(stderr, "Copyright (C) 2002-2004 Tomaz Solc\n");

        /* *** Parse command line options               *** */

        while ((c=getopt(argc, argv, "ho:vs:d:"))!=-1) {
                switch (c) {
                        case 'v': print_copyright();
                        case 'h':
                        case '?': print_syntax();
                                  exit(0);
                        case 'o': output=strdup(optarg);
                                  break;
			case 's': options=strdup(optarg);
				  break;
			case 'd': sscanf(optarg, "%d", &verbosity);
				  verbosity+=100;
				  break;
                }
        }

	if(options==NULL) options="";

        if (!(optind<argc)) {
                fatal(_("Missing output format. Try '%s -h' for more information."), cmd);
        }
        if (!(optind<argc-1)) {
                fatal(_("Missing file name. Try '%s -h' for more information."), cmd);
        }

        /* *** Get XML input                            *** */
        strncpy(xmlsrc, argv[optind+1], 256);

        xmlsup_main(xmlsrc);

        /* *** Population                               *** */
        parentpop=malloc(sizeof(*parentpop));
        parentpop->inf=malloc(sizeof(*(parentpop->inf))*tuplenum);

	data_init();

        xmlsup_getchromo(parentpop);

	if(output==NULL) {
		out=stdout;
	} else {
	        if (strcmp("-", output)) {
			out=fopen(output, "w"); 
		} else { 
			out=stdout;
		}
	}

        if (out==NULL) {
                fatal(_("Can't open output file."), cmd);
        }

	load_output_module(argv[optind]);

        opnt=oextend_chromo(parentpop);
        textend_chromo(parentpop);

	output_func(parentpop, cextbuff, textbuff, options, out, opnt);

        if (out!=stdout) fclose(out);

	free(opnt);

        xmlsup_exit();
        data_exit();

        free(parentpop->inf);
        free(parentpop);

        return(0);
}
