#ifndef TAG_SELECTOR_H
#define TAG_SELECTOR_H

/*
 * Tag list and selector widget
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#pragma interface

#include <gtkmm/scrolledwindow.h>
#include <gtkmm/box.h>
#include <gtkmm/table.h>
#include "TagcollDocument.h"

class TagSelector : public Gtk::VBox
{
public:
	typedef SigC::Signal0<void> type_signal_changed;
	typedef SigC::Signal1<void, std::string> type_signal_add_tag;
	typedef SigC::Signal1<void, std::string> type_signal_remove_tag;

protected:
	TagcollDocument<std::string>& doc;

	OpSet<std::string> _selected;
	
	Gtk::Table* table;
	Gtk::VBox tableBox;
	Gtk::VBox tagVBox;

	type_signal_changed _signal_changed;
	type_signal_add_tag _signal_add_tag;
	type_signal_remove_tag _signal_remove_tag;

	void updateView();

	bool on_titleAdd_event(GdkEvent* e);
	bool on_facetAdd_event(GdkEvent* e, std::string facet);
	bool on_tag_popup_event(GdkEvent* e, std::string tag);
	void on_add_to_selection(std::string tag);
	void on_del_from_selection(std::string tag);

	void on_document_changed();

	void on_selectedTagList_drag_data_get(
		        const Glib::RefPtr<Gdk::DragContext>&, GtkSelectionData* selection_data, guint, guint, std::string tag);

public:
	TagSelector(TagcollDocument<std::string>& doc);
	virtual ~TagSelector() {}

	type_signal_changed signal_changed() throw () { return _signal_changed; }
	type_signal_add_tag signal_add_tag() throw () { return _signal_add_tag; }
	type_signal_remove_tag signal_remove_tag() throw () { return _signal_remove_tag; }

	virtual void do_changed();
	virtual void do_add_tag(std::string tag);
	virtual void do_remove_tag(std::string tag);

	const OpSet<std::string>& selected() const throw () { return _selected; }
	const OpSet<std::string>& selected(const OpSet<std::string>& tagset) throw ()
	{
		_selected = tagset;
		updateView();
		do_changed();
		return _selected;
	}
};

// vim:set ts=4 sw=4:
#endif
