#!/usr/bin/env python

# setuptools plugin for darcs
# Author: Zooko O'Whielacronx

# Permission is hereby granted to any person obtaining a copy of this work to
# deal in this work without restriction (including the rights to use, modify,
# distribute, sublicense, and/or sell copies).

# See README.txt for instructions.

# Thanks to the authors of setuptools, setuptools_bzr, setuptools_git, and
# setuptools_mtn for documentation and examples.

import os, re, sys

from setuptools import setup, find_packages

trove_classifiers=[
    "Framework :: Setuptools Plugin",
    "Development Status :: 5 - Production/Stable",
    "License :: OSI Approved :: BSD License",
    "License :: DFSG approved",
    "Intended Audience :: Developers", 
    "Operating System :: Microsoft",
    "Operating System :: Microsoft :: Windows",
    "Operating System :: Unix",
    "Operating System :: POSIX :: Linux",
    "Operating System :: POSIX",
    "Operating System :: MacOS :: MacOS X",
    "Operating System :: Microsoft :: Windows :: Windows NT/2000",
    "Operating System :: OS Independent", 
    "Natural Language :: English", 
    "Programming Language :: Python", 
    "Programming Language :: Python :: 2",
    "Programming Language :: Python :: 2.4",
    "Programming Language :: Python :: 2.5",
    "Programming Language :: Python :: 2.6",
    "Topic :: Utilities",
    "Topic :: Software Development :: Libraries",
    ]

PKG='setuptools_darcs'
VERSIONFILE = os.path.join(PKG, "_version.py")
verstr = "unknown"
try:
    verstrline = open(VERSIONFILE, "rt").read()
except EnvironmentError:
    pass # Okay, there is no version file.
else:
    VSRE = r"^verstr = ['\"]([^'\"]*)['\"]"
    mo = re.search(VSRE, verstrline, re.M)
    if mo:
        verstr = mo.group(1)
    else:
        print "unable to find version in %s" % (VERSIONFILE,)
        raise RuntimeError("If %s.py exists, it is required to be well-formed." % (VERSIONFILE,))

# If you want to create a new _version.py file from darcs revision control history, install the
# darcsver package and run "python ./setup.py darcsver".
# http://pypi.python.org/pypi/darcsver

data_fnames=[ 'README.txt' ]

# In case we are building for a .deb with stdeb's sdist_dsc command, we put the
# docs in "share/doc/python-$PKG".
doc_loc = "share/doc/python-" + PKG
data_files = [(doc_loc, data_fnames)]

setup(
    name=PKG,
    version=verstr,
    description='setuptools plugin for darcs',
    author="Zooko O'Whielacronx",
    author_email='zooko@zooko.com',
    url='http://allmydata.org/trac/' + PKG,
    license='BSD',
    packages=find_packages(),
    include_package_data=True,
    data_files=data_files,
    classifiers=trove_classifiers,
    keywords='distutils setuptools setup darcs',
    entry_points={
        'setuptools.file_finders': [
            'darcs = setuptools_darcs.setuptools_darcs:find_files_for_darcs',
            ],
        },
    zip_safe=False, # I prefer unzipped for easier access.
    )
