#!/usr/bin/perl -w
###############################################################################
#                                                                             #
#  TakTuk, a middleware for adaptive large scale parallel remote executions   #
#  deployment. Perl implementation, copyright(C) 2006 Guillaume Huard.        #
#                                                                             #
#  This program is free software; you can redistribute it and/or modify       #
#  it under the terms of the GNU General Public License as published by       #
#  the Free Software Foundation; either version 2 of the License, or          #
#  (at your option) any later version.                                        #
#                                                                             #
#  This program is distributed in the hope that it will be useful,            #
#  but WITHOUT ANY WARRANTY; without even the implied warranty of             #
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              #
#  GNU General Public License for more details.                               #
#                                                                             #
#  You should have received a copy of the GNU General Public License          #
#  along with this program; if not, write to the Free Software                #
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA #
#                                                                             #
#  Contact: Guillaume.Huard@imag.fr                                           #
#           ENSIMAG - Laboratoire ID                                          #
#           51 avenue Jean Kuntzmann                                          #
#           38330 Montbonnot Saint Martin                                     #
#                                                                             #
###############################################################################

use strict;

if (scalar (@ARGV))
  {
    print "Arguments : @ARGV\n";
  }

if ($ENV{'TAKTUK_RANK'} == 1)
  {
    print "I'm process 1\n";
    if ($ENV{'TAKTUK_COUNT'} > 1)
      {
        if (not taktuk::send(to=>2, body=>"Salut  toi"))
          {
            print taktuk::error_msg($taktuk::error), "\n";
          }
      }
  }
elsif ($ENV{'TAKTUK_RANK'} == 2)
  {
    print "I'm process 2\n";
    my ($to, $from, $message) = taktuk::recv();
    if (not defined($message))
      {
        print taktuk::error_msg($taktuk::error), "\n";
      }
    else
      {
        print "Process $to received $message from $from\n";
      }
  }
