/*----- PROTECTED REGION ID(TestCppTango1022Class.h) ENABLED START -----*/
/* clang-format on */
//=============================================================================
//
// file :        TestCppTango1022Class.h
//
// description : Include for the TestCppTango1022 root class.
//               This class is the singleton class for
//                the TestCppTango1022 device class.
//               It contains all properties and methods which the
//               TestCppTango1022 requires only once e.g. the commands.
//
//
//
// This file is part of Tango device class.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
//
// Copyright (C): 2022
//                European Synchrotron Radiation Facility
//                BP 220, Grenoble 38043
//                France
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================


#ifndef TestCppTango1022Class_H
#define TestCppTango1022Class_H

#include <tango/tango.h>
#include "TestCppTango1022.h"

/* clang-format off */
/*----- PROTECTED REGION END -----*/	//	TestCppTango1022Class.h


namespace TestCppTango1022_ns
{
/*----- PROTECTED REGION ID(TestCppTango1022Class::classes for dynamic creation) ENABLED START -----*/
/* clang-format on */

/* clang-format off */
/*----- PROTECTED REGION END -----*/	//	TestCppTango1022Class::classes for dynamic creation

//=========================================
//	Define classes for dynamic attributes
//=========================================
//	Attribute DoubleAttr class definition
class DoubleAttrAttrib: public Tango::Attr
{
public:
	DoubleAttrAttrib(const std::string &att_name):Attr(att_name.c_str(),
			Tango::DEV_DOUBLE, Tango::READ_WRITE) {}
	~DoubleAttrAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TestCppTango1022 *>(dev))->read_DoubleAttr(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TestCppTango1022 *>(dev))->write_DoubleAttr(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TestCppTango1022 *>(dev))->is_DoubleAttr_allowed(ty);}
};


/**
 *	The TestCppTango1022Class singleton definition
 */

#ifdef _TG_WINDOWS_
class __declspec(dllexport)  TestCppTango1022Class : public Tango::DeviceClass
#else
class TestCppTango1022Class : public Tango::DeviceClass
#endif
{
	/*----- PROTECTED REGION ID(TestCppTango1022Class::Additional DServer data members) ENABLED START -----*/
	/* clang-format on */
	//	Add your own code
	/* clang-format off */
	/*----- PROTECTED REGION END -----*/	//	TestCppTango1022Class::Additional DServer data members

	public:
		//	write class properties data members
		Tango::DbData	cl_prop;
		Tango::DbData	cl_def_prop;
		Tango::DbData	dev_def_prop;
		//	Method prototypes
		static TestCppTango1022Class *init(const char *);
		static TestCppTango1022Class *instance();
		~TestCppTango1022Class();
		Tango::DbDatum	get_class_property(std::string &);
		Tango::DbDatum	get_default_device_property(std::string &);
		Tango::DbDatum	get_default_class_property(std::string &);

	protected:
		TestCppTango1022Class(std::string &);
		static TestCppTango1022Class *_instance;
		void command_factory();
		void attribute_factory(std::vector<Tango::Attr *> &);
		void pipe_factory();
		void write_class_property();
		void set_default_property();
		void get_class_property();
		std::string get_cvstag();
		std::string get_cvsroot();

	private:
		void device_factory(TANGO_UNUSED(const Tango::DevVarStringArray *));
		void create_static_attribute_list(std::vector<Tango::Attr *> &);
		void erase_dynamic_attributes(const Tango::DevVarStringArray *,std::vector<Tango::Attr *> &);
		std::vector<std::string>	defaultAttList;
		Tango::Attr *get_attr_object_by_name(std::vector<Tango::Attr *> &att_list, std::string attname);
};

}	//	End of namespace

#endif   //	TestCppTango1022_H
