/*
 *	tardy - a tar post-processor
 *	Copyright (C) 1998, 1999, 2002 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to manipulate file input normals
 */

#include <ac/unistd.h>
#include <ac/fcntl.h>
#include <file/input/normal.h>


file_input_normal::~file_input_normal()
{
	if (fd >= 0 && ::close(fd))
		nfatal("close");
}


file_input_normal::file_input_normal()
	: fn(), fd(-1)
{
	fatal("default constructor is private (bug)");
}


file_input_normal::file_input_normal(const char *arg)
	: fn(arg), fd(-1)
{
	fd = ::open(arg, O_RDONLY);
	if (fd < 0)
		nfatal("cannot open");
}


file_input_normal::file_input_normal(const file_input_normal &arg)
	: fn(arg.fn), fd(-1)
{
	fd = dup(arg.fd);
	if (fd < 0)
		arg.nfatal("dup");
}


file_input_normal &
file_input_normal::operator = (const file_input_normal &arg)
{
	if (fd >= 0 && close(fd))
		nfatal("close");
	fn = arg.fn;
	fd = dup(arg.fd);
	if (fd < 0)
		arg.nfatal("dup");
	return *this;
}


int
file_input_normal::read(void *buffer, int maximum_length)
	const
{
	int nbytes = ::read(fd, buffer, maximum_length);
	if (nbytes < 0)
		nfatal("read");
	return nbytes;
}


const char *
file_input_normal::filename()
	const
{
	return fn;
}
