//
//	srecord - manipulate eprom load files
//	Copyright (C) 2002 Peter Miller;
//	All rights reserved.
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
//
// MANIFEST: interface definition for common/tar/input/filenamelist.cc
//

#ifndef COMMON_TAR_INPUT_FILENAMELIST_H
#define COMMON_TAR_INPUT_FILENAMELIST_H

#pragma interface "tar_input_filenamelist"

#include <filenamelist.h>
#include <tar/input.h>

/**
  * The tar_input_filenamelist class is used to represent a file name
  * list as a source of tar input.
  */
class tar_input_filenamelist:
	public tar_input
{
public:
	/**
	  * The destructor.
	  */
	virtual ~tar_input_filenamelist();

	/**
	  * The constructor.
	  */
	tar_input_filenamelist(filenamelist *);

	// see base class for documentation
	int read_data(void *, int);

	// see base class for documentation
	int read_header(tar_header &);

	// see base class for documentation
	const char *filename () const;

private:
	/**
	  * The default constructor.  Do not use.
	  */
	tar_input_filenamelist();

	/**
	  * The copy constructor.  Do not use.
	  */
	tar_input_filenamelist(const tar_input_filenamelist &);

	/**
	  * The assignment operator.  Do not use.
	  */
	tar_input_filenamelist &operator=(const tar_input_filenamelist &);

	/**
	  * The source instance variable is used to remember where we
	  * are getting out file names from.
	  */
	filenamelist *source;

	/**
	  * The `singleton' instance variable is used to remember the
	  * deeper input source.
	  */
	mutable tar_input *singleton;

	/**
	  * The `get_singleton' method is used to instantiate the
	  * singleton it it is null, by reading the next file name from
	  * the file name list and opening it.
	  */
	tar_input *get_singleton(void) const;
};

#endif // COMMON_TAR_INPUT_FILENAMELIST_H
