/*
 *	tardy - a tar post-processor
 *	Copyright (C) 1998, 1999, 2002 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to manipulate tar input filename cleaning
 */

#include <ac/ctype.h>
#include <ac/string.h>

#include <mem.h>
#include <tar/input/filter/clean.h>


tar_input_filter_clean::~tar_input_filter_clean()
{
}


tar_input_filter_clean::tar_input_filter_clean(tar_input *arg1, int arg2) :
    tar_input_filter(arg1),
    flag(arg2)
{
}


static rcstring
launder(const rcstring &s, int flag)
{
    /*
     * temporary buffer to hold string while being constructed
     */
    static char *buffer;
    static size_t buffer_max;
    if (buffer_max < s.length())
    {
	buffer_max = s.length();
	buffer = (char *)mem_change_size(buffer, buffer_max);
    }

    char *bp = buffer;
    for (const char *sp = s.to_c_string(); *sp; ++sp)
    {
	int c = (unsigned char)*sp;
	if ((flag & tar_input_filter_clean::flag_space) && isspace(c))
	    c = '-';
	if ((flag & tar_input_filter_clean::flag_print) && !isprint(c))
	    c = '-';
	if
	(
	    (flag & tar_input_filter_clean::flag_shell)
	&&
	    strchr("\"#$&'()*:;<=>?[\\]^`{|}", c)
	)
	    c = '-';
	if ((flag & tar_input_filter_clean::flag_down) && isupper(c))
	    c = tolower(c);
	if ((flag & tar_input_filter_clean::flag_up) && islower(c))
	    c = toupper(c);
	*bp++ = c;
    }
    return rcstring(buffer, bp - buffer);
}


int
tar_input_filter_clean::read_header(tar_header &h)
{
    int ok = tar_input_filter::read_header(h);
    if (ok)
	h.name = launder(h.name, flag);
    return ok;
}
