//
//      tardy - a tar post-processor
//      Copyright (C) 2003, 2008, 2009 Peter Miller
//
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 3 of the License, or
//      (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program. If not, see
//      <http://www.gnu.org/licenses/>.
//

#include <libtardy/ac/string.h>
#include <libtardy/file/output/buffer.h>


file_output_buffer::~file_output_buffer()
{
    if (pos > 0)
    {
        deeper->write(buffer, pos);
        pos = 0;
    }
    delete buffer;
    buffer = 0;
    delete deeper;
    deeper = 0;
}


file_output_buffer::file_output_buffer(file_output *arg1, int arg2) :
    deeper(arg1),
    blocksize(arg2 > 0 ? arg2 : 512),
    buffer(0),
    pos(0)
{
}


const char *
file_output_buffer::filename()
    const
{
    return deeper->filename();
}


void
file_output_buffer::write(const void *data, int nbytes)
{
    while (nbytes > 0)
    {
        //
        // Don't double handle the data if we can avoid it.
        // (But only write `blocksize' bytes at a time.)
        //
        if (pos == 0 && nbytes >= blocksize)
        {
            deeper->write(data, blocksize);
            data = (char *)data + blocksize;
            nbytes -= blocksize;
            continue;
        }

        //
        // Add the data to the end of the buffer.
        //
        int len = blocksize - pos;
        if (len > nbytes)
            len = nbytes;
        if (!buffer)
            buffer = new char[blocksize];
        memcpy(buffer + pos, data, len);
        pos += len;
        if (pos >= blocksize)
        {
            //
            // If the buffer is full,
            // write it out and start again.
            //
            deeper->write(buffer, pos);
            pos = 0;
        }
        data = (char *)data + len;
        nbytes -= len;
    }
}
