//
//      tardy - a tar post-processor
//      Copyright (C) 1998, 1999, 2002, 2008, 2009 Peter Miller
//
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 3 of the License, or
//      (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program. If not, see
//      <http://www.gnu.org/licenses/>.
//

#ifndef COMMON_TAR_INPUT_GROUP_NAME_H
#define COMMON_TAR_INPUT_GROUP_NAME_H

#include <libtardy/rcstring.h>
#include <libtardy/tar/input/filter.h>

/**
  * The tar_input_filter_group_name class is used to represent a filter
  * which replaces the group name in tar archive file headers.
  */
class tar_input_filter_group_name:
    public tar_input_filter
{
public:
    /**
      * The destructor.
      */
    virtual ~tar_input_filter_group_name();

    /**
      * The constructor.
      *
      * \param deeper
      *     The file input stream top apply the filter to.
      * \param grnam
      *     The group name to be inserted.
      */
    tar_input_filter_group_name(tar_input *deeper, const rcstring &grnam);

    // See base class for documentation.
    virtual int read_header(tar_header &);

private:
    /**
      * The name instance variable is used to remember the name of the
      * group to be inserted into the file headers.
      */
    rcstring name;

    /**
      * The default constructor.  Do not use.
      */
    tar_input_filter_group_name();

    /**
      * The copy constructor.  Do not use.
      */
    tar_input_filter_group_name(const tar_input_filter_group_name &);

    /**
      * The assignment operator.  Do not use.
      */
    tar_input_filter_group_name &operator = (
        const tar_input_filter_group_name &);
};

#endif // COMMON_TAR_INPUT_GROUP_NAME_H
