/*
 * Decompiled with CFR 0.152.
 */
package org.jatha.read;

import java.io.EOFException;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import org.jatha.Jatha;
import org.jatha.compile.CompilerException;
import org.jatha.dynatype.LispConsOrNil;
import org.jatha.dynatype.LispPackage;
import org.jatha.dynatype.LispValue;
import org.jatha.dynatype.StandardLispCharacter;

public class LispParser {
    public static final int UPCASE = 1;
    public static final int DOWNCASE = 2;
    public static final int PRESERVE = 3;
    static final char AT_SIGN = '@';
    static final char BACK_QUOTE = '`';
    static final char BACKSLASH = '\\';
    static final char COLON = ':';
    static final char COMMA = ',';
    static final char DECIMAL = '.';
    static final char DOUBLE_QUOTE = '\"';
    static final char EQUAL_SIGN = '=';
    static final char LEFT_ANGLE_BRACKET = '<';
    static final char LEFT_PAREN = '(';
    static final char HYPHEN = '-';
    static final char OR_BAR = '|';
    static final char POUND = '#';
    static final char PERIOD = '.';
    static final char RIGHT_PAREN = ')';
    static final char SEMICOLON = ';';
    static final char RIGHT_ANGLE_BRACKET = '>';
    static final char SINGLE_QUOTE = '\'';
    static final char UNDERSCORE = '_';
    static LispValue COMMA_FN = null;
    static LispValue COMMA_ATSIGN_FN = null;
    static LispValue COMMA_DOT_FN = null;
    static final int READING_NOTHING = 0;
    static final int READING_SYMBOL = 1;
    static final int READING_MIXED_CASE_SYMBOL = 2;
    static final int READING_CHARACTER = 3;
    static final int READING_STRING = 4;
    static final int READING_BACKQUOTED_LIST = 5;
    private int BackQuoteLevel = 0;
    private PushbackReader inputReader;
    private int f_caseSensitivity = 1;
    private Jatha f_lisp = null;

    public LispParser(Jatha lisp, Reader inStream) {
        this(lisp, inStream, 1);
    }

    public LispParser(Jatha lisp, String inString) {
        this(lisp, new StringReader(inString), 1);
    }

    public LispParser(Jatha lisp, Reader inStream, int caseSensitivity) {
        this.f_lisp = lisp;
        this.inputReader = inStream instanceof PushbackReader ? (PushbackReader)inStream : new PushbackReader(inStream);
        this.setCaseSensitivity(caseSensitivity);
    }

    public LispParser(Jatha lisp, String inString, int caseSensitivity) {
        this(lisp, new StringReader(inString));
        this.setCaseSensitivity(caseSensitivity);
    }

    public int getCaseSensitivity() {
        return this.f_caseSensitivity;
    }

    public void setCaseSensitivity(int caseSensitivity) {
        this.f_caseSensitivity = caseSensitivity;
    }

    public PushbackReader getInputReader() {
        return this.inputReader;
    }

    public void setInputReader(PushbackReader inputReader) {
        this.inputReader = inputReader;
    }

    public void setInputString(String s) {
        this.inputReader = new PushbackReader(new StringReader(s));
    }

    public LispValue parse() throws EOFException {
        return this.read();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LispValue read() throws EOFException {
        StringBuffer token = new StringBuffer(80);
        int intCh = 0;
        int parseState = 0;
        block15: while (true) {
            char ch;
            try {
                intCh = this.inputReader.read();
            }
            catch (IOException ioe) {
                break;
            }
            if (intCh < 0) {
                if (parseState != true) throw new EOFException("Premature end of LISP input at: " + token.toString());
                ch = ' ';
            } else {
                ch = (char)intCh;
            }
            if (this.isSemi(ch) && parseState != 4 && parseState != 3) {
                do {
                    try {
                        intCh = this.inputReader.read();
                    }
                    catch (IOException e) {
                        continue block15;
                    }
                    if (intCh < 0) {
                        throw new EOFException("Premature end of LISP input at: " + token.toString());
                    }
                    ch = (char)intCh;
                    if (ch != 13) continue;
                    ch = '\n';
                } while (ch != 10);
                continue;
            }
            if (parseState != 0) {
                switch (parseState) {
                    case 1: {
                        if (this.isTerminator(ch)) {
                            try {
                                this.inputReader.unread(ch);
                            }
                            catch (IOException e) {
                                System.err.println("\n *** I/O error while unreading character '" + ch + "'.");
                            }
                            parseState = 0;
                            if (this.f_caseSensitivity == 1) {
                                return this.tokenToLispValue(token.toString().toUpperCase());
                            }
                            if (this.f_caseSensitivity != 2) return this.tokenToLispValue(token.toString());
                            return this.tokenToLispValue(token.toString().toLowerCase());
                        }
                        token.append(ch);
                        break;
                    }
                    case 2: {
                        if (this.isOrBar(ch)) {
                            String s = token.toString();
                            token.append(ch);
                            return this.tokenToLispValue(s.substring(1, s.length()));
                        }
                        token.append(ch);
                        break;
                    }
                    case 4: {
                        if (ch == '\\') {
                            try {
                                intCh = this.inputReader.read();
                            }
                            catch (IOException e) {
                                break;
                            }
                            if (intCh < 0) {
                                throw new EOFException("Premature end of LISP input at: " + token.toString());
                            }
                            ch = (char)intCh;
                            token.append(ch);
                            break;
                        }
                        if (ch == '\"') {
                            token.append(ch);
                            return this.tokenToLispValue(token.toString());
                        }
                        token.append(ch);
                    }
                }
                continue;
            }
            if (this.isSpace(ch)) continue;
            if (this.isLparen(ch)) {
                return this.read_list_token(this.inputReader);
            }
            if (this.isRparen(ch)) {
                System.err.println("WARNING: Too many right parentheses.  NIL assumed.");
                return this.f_lisp.NIL;
            }
            if (this.isQuote(ch)) {
                return this.read_quoted_token(this.inputReader);
            }
            if (this.isDoubleQuote(ch)) {
                token.append(ch);
                parseState = 4;
                continue;
            }
            if (this.isPound(ch)) {
                return this.read_structure_token(this.inputReader);
            }
            if (this.isBackQuote(ch)) {
                return this.read_backquoted_token(this.inputReader);
            }
            if (this.isComma(ch)) {
                return this.read_comma_token(this.inputReader);
            }
            if (this.isOrBar(ch)) {
                token.append(ch);
                parseState = 2;
                continue;
            }
            parseState = 1;
            try {
                this.inputReader.unread(ch);
            }
            catch (IOException e) {
                System.err.println("\n *** I/O error while unreading character '" + ch + "'.");
            }
        }
        if (token.length() <= 0) return this.f_lisp.NIL;
        return this.tokenToLispValue(token.toString());
    }

    public LispValue read_list_token(PushbackReader stream) throws EOFException {
        boolean firstTime = true;
        boolean haveDot = false;
        int intCh = 0;
        LispConsOrNil newList = this.f_lisp.NIL;
        LispConsOrNil newCell = this.f_lisp.NIL;
        block6: while (true) {
            try {
                intCh = this.inputReader.read();
            }
            catch (IOException e) {
                break;
            }
            if (intCh < 0) {
                throw new EOFException("Premature end of LISP input.");
            }
            int ch = intCh;
            if (this.isSpace((char)ch)) continue;
            if (this.isRparen((char)ch)) {
                return newList;
            }
            if (this.isPeriod((char)ch)) {
                if (haveDot) {
                    System.err.println("WARNING: Illegal dotted syntax.  NIL assumed.");
                    return this.f_lisp.NIL;
                }
                haveDot = true;
                continue;
            }
            if (this.isSemi((char)ch)) {
                do {
                    try {
                        intCh = this.inputReader.read();
                    }
                    catch (IOException e) {
                        continue block6;
                    }
                    if (intCh < 0) {
                        throw new EOFException("Premature end of LISP input.");
                    }
                    ch = (char)intCh;
                    if (ch != 13) continue;
                    ch = 10;
                } while (ch != 10);
                continue;
            }
            try {
                this.inputReader.unread(ch);
            }
            catch (IOException e) {
                System.err.println("\n *** I/O error while unreading character '" + (char)ch + "'.");
            }
            LispValue newToken = this.read();
            if (firstTime) {
                newList = this.f_lisp.makeCons(this.f_lisp.NIL, this.f_lisp.NIL);
                newList.rplaca(newToken);
                firstTime = false;
                continue;
            }
            if (haveDot) {
                newList.last().rplacd(newToken);
                continue;
            }
            newCell = this.f_lisp.makeCons(this.f_lisp.NIL, this.f_lisp.NIL);
            newCell.rplaca(newToken);
            newList.last().rplacd(newCell);
        }
        return this.f_lisp.NIL;
    }

    LispValue read_quoted_token(PushbackReader stream) throws EOFException {
        LispValue newCell = this.f_lisp.NIL;
        LispConsOrNil newQuotedList = this.f_lisp.NIL;
        newQuotedList = this.f_lisp.makeCons(this.f_lisp.QUOTE, this.f_lisp.makeCons(this.f_lisp.NIL, this.f_lisp.NIL));
        newCell = this.read();
        newQuotedList.cdr().rplaca(newCell);
        return newQuotedList;
    }

    public LispValue read_backquoted_token(PushbackReader stream) throws EOFException {
        LispValue newCell = this.f_lisp.NIL;
        LispConsOrNil newQuotedList = this.f_lisp.NIL;
        newQuotedList = this.f_lisp.makeCons(this.f_lisp.BACKQUOTE, this.f_lisp.makeCons(this.f_lisp.NIL, this.f_lisp.NIL));
        ++this.BackQuoteLevel;
        newCell = this.read();
        --this.BackQuoteLevel;
        newQuotedList.cdr().rplaca(newCell);
        return newQuotedList;
    }

    LispValue read_comma_token(PushbackReader stream) throws EOFException {
        int intCh;
        LispValue newCell = this.f_lisp.NIL;
        LispConsOrNil newQuotedList = this.f_lisp.NIL;
        LispValue identifier = this.f_lisp.NIL;
        if (COMMA_FN == null) {
            LispPackage pkg = (LispPackage)this.f_lisp.findPackage(this.f_lisp.makeString("KEYWORD"));
            COMMA_FN = this.f_lisp.EVAL.intern(this.f_lisp.makeString("COMMA"), pkg);
            COMMA_ATSIGN_FN = this.f_lisp.EVAL.intern(this.f_lisp.makeString("COMMA-ATSIGN"), pkg);
            COMMA_DOT_FN = this.f_lisp.EVAL.intern(this.f_lisp.makeString("COMMA-DOT"), pkg);
        }
        if (this.BackQuoteLevel <= 0) {
            System.err.println(";; *** ERROR: Comma not inside backquote.");
            return this.f_lisp.NIL;
        }
        try {
            intCh = this.inputReader.read();
        }
        catch (IOException e) {
            return this.f_lisp.NIL;
        }
        if (intCh < 0) {
            throw new EOFException("Premature end of LISP input.");
        }
        char ch = (char)intCh;
        if (ch == '\r') {
            ch = '\n';
        }
        if (this.isAtSign(ch)) {
            identifier = COMMA_ATSIGN_FN;
        } else if (this.isPeriod(ch)) {
            identifier = COMMA_DOT_FN;
        } else {
            identifier = COMMA_FN;
            try {
                this.inputReader.unread(ch);
            }
            catch (IOException e) {
                System.err.println("\n *** I/O error while unreading character '" + ch + "'.");
            }
        }
        newQuotedList = this.f_lisp.makeCons(identifier, this.f_lisp.makeCons(this.f_lisp.NIL, this.f_lisp.NIL));
        newCell = this.read();
        newQuotedList.cdr().rplaca(newCell);
        return newQuotedList;
    }

    public LispValue read_structure_token(PushbackReader stream) throws EOFException {
        char ch = '0';
        int intCh = 0;
        try {
            intCh = this.inputReader.read();
        }
        catch (IOException e) {
            System.err.println("\n *** I/O error while reading '#' token.");
        }
        if (intCh < 0) {
            throw new EOFException("Premature end of LISP input.");
        }
        ch = (char)intCh;
        if (this.isColon(ch)) {
            StringBuffer token = new StringBuffer(80);
            token.append('#');
            while (!this.isTerminator(ch)) {
                token.append(ch);
                try {
                    intCh = this.inputReader.read();
                }
                catch (IOException e) {
                    System.err.println("\n *** I/O error while reading '#:' token.");
                }
                if (intCh < 0) {
                    throw new EOFException("Premature end of LISP input.");
                }
                ch = (char)intCh;
            }
            try {
                this.inputReader.unread(ch);
            }
            catch (IOException e) {
                System.err.println("\n *** I/O error while unreading character '" + ch + "'.");
            }
            if (this.f_caseSensitivity == 1) {
                return this.tokenToLispValue(token.toString().toUpperCase());
            }
            if (this.f_caseSensitivity == 2) {
                return this.tokenToLispValue(token.toString().toLowerCase());
            }
            return this.tokenToLispValue(token.toString());
        }
        if (this.isBackSlash(ch)) {
            try {
                intCh = this.inputReader.read();
            }
            catch (IOException e) {
                System.err.println("\n *** I/O error while reading character token.");
            }
            if (intCh < 0) {
                throw new EOFException("Premature end of LISP input.");
            }
            ch = (char)intCh;
            return new StandardLispCharacter(this.f_lisp, ch);
        }
        if (this.isLeftAngleBracket(ch)) {
            System.err.println("\n *** parser can't read structures yet.");
            while (!this.isRightAngleBracket(ch)) {
                try {
                    intCh = this.inputReader.read();
                }
                catch (IOException e) {
                    System.err.println("\n *** I/O error while reading a structure.");
                }
            }
            if (intCh < 0) {
                throw new EOFException("Premature end of LISP input.");
            }
            ch = (char)intCh;
            return this.f_lisp.NIL;
        }
        System.err.println("\n *** unknown '#' construct.");
        return this.f_lisp.NIL;
    }

    public LispValue read_backquoted_list_token(PushbackReader stream) {
        System.err.println("\n *** Parser can't read backquoted lists yet.");
        return this.f_lisp.NIL;
    }

    public LispValue tokenToLispValue(String token) {
        LispValue newCell = null;
        LispValue keywordPackage = this.f_lisp.findPackage("KEYWORD");
        if (this.T_token_p(token)) {
            newCell = this.f_lisp.T;
        } else if (this.NIL_token_p(token)) {
            newCell = this.f_lisp.NIL;
        } else if (this.INTEGER_token_p(token)) {
            try {
                newCell = this.f_lisp.makeInteger(new Long(token));
            }
            catch (NumberFormatException e) {
                newCell = this.f_lisp.makeBignum(new BigInteger(token));
            }
        } else if (this.REAL_token_p(token)) {
            newCell = this.f_lisp.makeReal(new Double(token));
        } else if (this.STRING_token_p(token)) {
            try {
                newCell = this.f_lisp.makeString(token.substring(1, token.length() - 1));
            }
            catch (StringIndexOutOfBoundsException e) {
                System.err.println("Hey, got a bad string index in 'tokenToLispValue'!");
            }
        } else if (this.SYMBOL_token_p(token)) {
            LispValue pkg = this.f_lisp.PACKAGE_SYMBOL.symbol_value();
            String packageStr = "";
            boolean external = false;
            if (token.indexOf(58) >= 0) {
                packageStr = token.substring(0, token.indexOf(58));
                if (packageStr.equals("#")) {
                    pkg = null;
                } else {
                    pkg = this.f_lisp.findPackage(packageStr);
                    if (pkg == this.f_lisp.NIL) {
                        System.err.println("Warning: package '" + packageStr + "' undefined.  Using current package.");
                        pkg = this.f_lisp.PACKAGE_SYMBOL.symbol_value();
                    }
                }
                token = token.substring(packageStr.length(), token.length());
                if (token.startsWith(":::")) {
                    System.err.println("Warning: ignored extra ':' in '" + packageStr + token + "'.");
                    token = token.substring(token.lastIndexOf(58) + 1, token.length());
                } else if (token.startsWith("::")) {
                    token = token.substring(2, token.length());
                } else if (token.startsWith(":")) {
                    external = true;
                    token = token.substring(1, token.length());
                }
            }
            if (external && !packageStr.equals("")) {
                newCell = ((LispPackage)pkg).getExternalSymbol(this.f_lisp.makeString(token));
                if (newCell == this.f_lisp.NIL) {
                    System.err.println(";; *** ERROR: " + packageStr + ":" + token + " is not an external symbol in " + packageStr + ".\n;; *** Creating new symbol in current package.");
                }
                newCell = this.f_lisp.EVAL.intern(token, (LispPackage)this.f_lisp.PACKAGE_SYMBOL.symbol_value());
            } else {
                newCell = pkg == keywordPackage ? this.f_lisp.EVAL.intern(token.toUpperCase(), (LispPackage)pkg) : this.f_lisp.EVAL.intern(token, (LispPackage)pkg);
            }
        } else {
            System.err.println("ERROR: Unrecognized input: \"" + token + "\"");
            newCell = this.f_lisp.NIL;
        }
        if (newCell == null) {
            System.err.println("MEMORY_ERROR in  \"tokenToLispValue\" for token \"" + token + "\", returning NIL.");
            newCell = this.f_lisp.NIL;
        }
        return newCell;
    }

    boolean isLparen(char x) {
        return x == '(';
    }

    boolean isRparen(char x) {
        return x == ')';
    }

    boolean isAtSign(char x) {
        return x == '@';
    }

    boolean isBackQuote(char x) {
        return x == '`';
    }

    boolean isBackSlash(char x) {
        return x == '\\';
    }

    boolean isColon(char x) {
        return x == ':';
    }

    boolean isComma(char x) {
        return x == ',';
    }

    boolean isDoubleQuote(char x) {
        return x == '\"';
    }

    boolean isOrBar(char x) {
        return x == '|';
    }

    boolean isPound(char x) {
        return x == '#';
    }

    boolean isPeriod(char x) {
        return x == '.';
    }

    boolean isQuote(char x) {
        return x == '\'';
    }

    boolean isSemi(char x) {
        return x == ';';
    }

    boolean isLeftAngleBracket(char x) {
        return x == '<';
    }

    boolean isRightAngleBracket(char x) {
        return x == '>';
    }

    boolean isSpace(char x) {
        return x == ' ' || x == '\n' || x == '\r' || x == '\t' || x == '\f' || x == '\b';
    }

    boolean isTerminator(char x) {
        return this.isSpace(x) || this.isLparen(x) || this.isRparen(x) || this.isQuote(x) || this.isSemi(x) || this.isDoubleQuote(x) || this.isComma(x);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int firstCharNotInSet(int startIndex, String str, String charSet) {
        int searchIndex = startIndex - 1;
        int length = str.length();
        try {
            int i = startIndex;
            while (i < length) {
                if (charSet.indexOf(str.charAt(i)) < 0) {
                    return searchIndex + 1;
                }
                searchIndex = i++;
            }
            return searchIndex + 1;
        }
        catch (StringIndexOutOfBoundsException e) {
            System.err.println("Hey, got a bad string index in 'firstCharNotInSet'!");
            return searchIndex + 1;
        }
    }

    boolean REAL_token_p(String str) {
        String DECIMALchars = ".";
        String INTchars = "0123456789";
        int length = str.length();
        int index = 0;
        if (str.charAt(index) == '-' || str.charAt(index) == '+') {
            ++index;
        }
        if (index == length) {
            return false;
        }
        int decimalPos = str.indexOf(DECIMALchars);
        if (decimalPos < 0) {
            return false;
        }
        if (LispParser.firstCharNotInSet(index, str, INTchars) != decimalPos) {
            return false;
        }
        if (decimalPos == str.length() - 1) {
            return true;
        }
        index = decimalPos + 1;
        return LispParser.firstCharNotInSet(index, str, INTchars) == length;
    }

    boolean INTEGER_token_p(String str) {
        String INTchars = "0123456789";
        int length = str.length();
        int index = 0;
        try {
            if (str.charAt(index) == '-' || str.charAt(index) == '+') {
                ++index;
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            System.err.println("Hey, got a bad string index in 'INTEGER_token_p'!");
        }
        if (index == length) {
            return false;
        }
        return LispParser.firstCharNotInSet(index, str, INTchars) == length;
    }

    boolean NIL_token_p(String str) {
        return str.equalsIgnoreCase("NIL");
    }

    boolean STRING_token_p(String str) {
        int length = str.length();
        boolean value = false;
        try {
            value = length >= 2 && str.charAt(0) == '\"' && str.charAt(length - 1) == '\"';
        }
        catch (StringIndexOutOfBoundsException e) {
            System.err.println("Hey, got a bad string index in 'NIL_token_p'!");
        }
        return value;
    }

    boolean SYMBOL_token_p(String str) {
        return str.length() >= 1;
    }

    boolean T_token_p(String str) {
        return str.equalsIgnoreCase("T");
    }

    public void test_parser(String s) {
        System.out.print("The string \"" + s + "\" ");
        if (this.T_token_p(s)) {
            System.out.println("is T.");
        } else if (this.NIL_token_p(s)) {
            System.out.println("is NIL.");
        } else if (this.INTEGER_token_p(s)) {
            System.out.println("is an integer.");
        } else if (this.REAL_token_p(s)) {
            System.out.println("is a double.");
        } else if (this.STRING_token_p(s)) {
            System.out.println("is a string.");
        } else if (this.SYMBOL_token_p(s)) {
            System.out.println("is a symbol.");
        } else {
            System.out.println("is not recognized.");
        }
    }

    public void test_parser_loop() throws EOFException {
        LispValue exit = this.f_lisp.EVAL.intern("EXIT");
        LispValue temp = this.f_lisp.EVAL.intern("*TEMP*");
        System.out.println("Run (EXIT) to stop.");
        try {
            do {
                System.out.print("\nJATHA>");
                System.out.flush();
                temp = this.read();
                temp = this.f_lisp.COMPILER.compile(this.f_lisp.MACHINE, temp, (LispValue)this.f_lisp.NIL);
                temp = this.f_lisp.MACHINE.Execute(temp, this.f_lisp.NIL);
                System.out.println();
                temp.prin1();
            } while (temp != exit);
        }
        catch (CompilerException ce) {
            System.err.println("Compiler error: " + ce.toString());
        }
        System.out.println();
        System.out.flush();
    }

    public void simple_parser_test() {
        this.test_parser("1234.56789");
        this.test_parser("1234.");
        this.test_parser(".56789");
        this.test_parser("-1234.56789");
        this.test_parser("+1234.56789");
        this.test_parser("-.56789");
        this.test_parser("1234");
        this.test_parser("-1234");
        this.test_parser("+1234");
        this.test_parser("T");
        this.test_parser("NIL");
        this.test_parser("\"This is a string\"");
        this.test_parser("\"astring\"");
        this.test_parser("\"\"");
        this.test_parser("ABCD");
        this.test_parser("def1234");
        this.test_parser("123def");
        this.test_parser("abc_def_ghi");
    }
}

