/*
 * Decompiled with CFR 0.152.
 */
package jRacy;

import jRacy.GlobalMappingElement;
import jRacy.MappingLedgerWindow;
import jRacy.Trial;
import jRacy.jRacy;
import java.awt.Component;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class GlobalMapping
implements WindowListener,
Serializable {
    private Trial trial = null;
    Vector[] mappings;
    int[] numberOfMappings;
    MappingLedgerWindow[] mappingLedgerWindows;
    int sizeOfArray = 2;
    boolean isSelectedGroupOn = false;
    boolean isAllExceptGroupOn = false;
    int selectedGroupID = -1;
    private MappingLedgerWindow mappingLedgerWindow;

    public GlobalMapping(Trial trial) {
        this.trial = trial;
        this.mappings = new Vector[3];
        this.numberOfMappings = new int[3];
        this.mappingLedgerWindows = new MappingLedgerWindow[3];
        this.mappings[0] = new Vector();
        this.mappings[1] = new Vector();
        this.mappings[2] = new Vector();
        this.numberOfMappings[0] = 0;
        this.numberOfMappings[1] = 0;
        this.numberOfMappings[2] = 0;
    }

    public int addGlobalMapping(String string, int n) {
        int n2 = this.getMappingId(string, n);
        if (n2 == -1) {
            GlobalMappingElement globalMappingElement = new GlobalMappingElement(this.trial);
            globalMappingElement.setMappingName(string);
            globalMappingElement.setGlobalID(this.numberOfMappings[n]);
            if (n == 0 || n == 2) {
                globalMappingElement.setGenericColor(this.trial.getColorChooser().getColorInLocation(this.numberOfMappings[n] % this.trial.getColorChooser().getNumberOfColors()));
            } else {
                globalMappingElement.setGenericColor(this.trial.getColorChooser().getMappingGroupColorInLocation(this.numberOfMappings[n] % this.trial.getColorChooser().getNumberOfMappingGroupColors()));
            }
            this.mappings[n].addElement(globalMappingElement);
            int n3 = n;
            this.numberOfMappings[n3] = this.numberOfMappings[n3] + 1;
            return this.numberOfMappings[n] - 1;
        }
        return n2;
    }

    public boolean setMappingNameAt(String string, int n, int n2) {
        if (n > this.getNumberOfMappings(n2) - 1) {
            return false;
        }
        GlobalMappingElement globalMappingElement = (GlobalMappingElement)this.mappings[n2].elementAt(n);
        globalMappingElement.setMappingName(string);
        return true;
    }

    public boolean addGroup(int n, int n2, int n3) {
        if (n > this.getNumberOfMappings(n3) - 1) {
            return false;
        }
        GlobalMappingElement globalMappingElement = (GlobalMappingElement)this.mappings[n3].elementAt(n);
        return globalMappingElement.addGroup(n2);
    }

    public boolean isGroupMember(int n, int n2, int n3) {
        if (n > this.getNumberOfMappings(n3) - 1) {
            return false;
        }
        GlobalMappingElement globalMappingElement = (GlobalMappingElement)this.mappings[n3].elementAt(n);
        return globalMappingElement.isGroupMember(n2);
    }

    public boolean setMeanExclusiveValueAt(int n, double d, int n2, int n3) {
        if (n2 > this.getNumberOfMappings(n3) - 1) {
            return false;
        }
        GlobalMappingElement globalMappingElement = (GlobalMappingElement)this.mappings[n3].elementAt(n2);
        globalMappingElement.setMeanExclusiveValue(n, d);
        return true;
    }

    public boolean setMeanInclusiveValueAt(int n, double d, int n2, int n3) {
        if (n2 > this.getNumberOfMappings(n3) - 1) {
            return false;
        }
        GlobalMappingElement globalMappingElement = (GlobalMappingElement)this.mappings[n3].elementAt(n2);
        globalMappingElement.setMeanInclusiveValue(n, d);
        return true;
    }

    public boolean setTotalExclusiveValueAt(int n, double d, int n2, int n3) {
        if (n2 > this.getNumberOfMappings(n3) - 1) {
            return false;
        }
        GlobalMappingElement globalMappingElement = (GlobalMappingElement)this.mappings[n3].elementAt(n2);
        globalMappingElement.setTotalExclusiveValue(n, d);
        return true;
    }

    public boolean setTotalInclusiveValueAt(int n, double d, int n2, int n3) {
        if (n2 > this.getNumberOfMappings(n3) - 1) {
            return false;
        }
        GlobalMappingElement globalMappingElement = (GlobalMappingElement)this.mappings[n3].elementAt(n2);
        globalMappingElement.setTotalInclusiveValue(n, d);
        return true;
    }

    public boolean isMappingPresent(String string, int n) {
        if (string == null) {
            return false;
        }
        Enumeration enumeration = this.mappings[n].elements();
        while (enumeration.hasMoreElements()) {
            GlobalMappingElement globalMappingElement = (GlobalMappingElement)enumeration.nextElement();
            String string2 = globalMappingElement.getMappingName();
            if (string2 == null || !string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public int getNumberOfMappings(int n) {
        return this.numberOfMappings[n];
    }

    public GlobalMappingElement getGlobalMappingElement(int n, int n2) {
        if (n > this.getNumberOfMappings(n2) - 1) {
            return null;
        }
        return (GlobalMappingElement)this.mappings[n2].elementAt(n);
    }

    public int getMappingId(String string, int n) {
        int n2 = 0;
        GlobalMappingElement globalMappingElement = null;
        Enumeration enumeration = this.mappings[n].elements();
        while (enumeration.hasMoreElements()) {
            globalMappingElement = (GlobalMappingElement)enumeration.nextElement();
            String string2 = globalMappingElement.getMappingName();
            if (string2 != null && string2.equals(string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public GlobalMappingElement getGlobalMappingElement(String string, int n) {
        GlobalMappingElement globalMappingElement = null;
        Enumeration enumeration = this.mappings[n].elements();
        while (enumeration.hasMoreElements()) {
            globalMappingElement = (GlobalMappingElement)enumeration.nextElement();
            String string2 = globalMappingElement.getMappingName();
            if (string2 == null || !string2.equals(string)) continue;
            return globalMappingElement;
        }
        return null;
    }

    public Vector getMapping(int n) {
        return this.mappings[n];
    }

    public void updateGenericColors(int n) {
        if (n == 0) {
            int n2 = this.trial.getColorChooser().getNumberOfColors();
            Enumeration enumeration = this.mappings[n].elements();
            while (enumeration.hasMoreElements()) {
                GlobalMappingElement globalMappingElement = (GlobalMappingElement)enumeration.nextElement();
                int n3 = globalMappingElement.getGlobalID();
                globalMappingElement.setGenericColor(this.trial.getColorChooser().getColorInLocation(n3 % n2));
            }
        } else {
            int n4 = this.trial.getColorChooser().getNumberOfMappingGroupColors();
            Enumeration enumeration = this.mappings[n].elements();
            while (enumeration.hasMoreElements()) {
                GlobalMappingElement globalMappingElement = (GlobalMappingElement)enumeration.nextElement();
                int n5 = globalMappingElement.getGlobalID();
                globalMappingElement.setGenericColor(this.trial.getColorChooser().getMappingGroupColorInLocation(n5 % n4));
            }
        }
    }

    public void setIsSelectedGroupOn(boolean bl) {
        this.isSelectedGroupOn = bl;
    }

    public boolean getIsSelectedGroupOn() {
        return this.isSelectedGroupOn;
    }

    public void setIsAllExceptGroupOn(boolean bl) {
        this.isAllExceptGroupOn = bl;
    }

    public boolean getIsAllExceptGroupOn() {
        return this.isAllExceptGroupOn;
    }

    public void setSelectedGroupID(int n) {
        this.selectedGroupID = n;
    }

    public int getSelectedGroupID() {
        return this.selectedGroupID;
    }

    public void displayMappingLedger(int n) {
        if (this.mappingLedgerWindows[n] == null) {
            this.mappingLedgerWindows[n] = new MappingLedgerWindow(this.trial, this.mappings[n], n);
            this.mappingLedgerWindows[n].addWindowListener(this);
            this.trial.getSystemEvents().addObserver(this.mappingLedgerWindows[n]);
            this.mappingLedgerWindows[n].show();
        } else {
            this.mappingLedgerWindows[n].show();
        }
    }

    public void closeMappingLedger(int n) {
        if (jRacy.debugIsOn) {
            System.out.println("Inside closeMappingLedger - mapping selection is: " + n);
        }
        if (this.mappingLedgerWindows[n] != null) {
            this.trial.getSystemEvents().deleteObserver(this.mappingLedgerWindows[n]);
            ((Component)this.mappingLedgerWindows[n]).setVisible(false);
            this.mappingLedgerWindows[n].dispose();
            this.mappingLedgerWindows[n] = null;
        } else if (jRacy.debugIsOn) {
            System.out.println("Inside closeMappingLedger - mapping selection " + n + " is null.  Not attemptinga close.");
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this.mappingLedgerWindows[0]) {
            this.mappingLedgerWindows[0] = null;
        }
        if (windowEvent.getSource() == this.mappingLedgerWindows[1]) {
            this.mappingLedgerWindows[1] = null;
        }
        if (windowEvent.getSource() == this.mappingLedgerWindows[2]) {
            this.mappingLedgerWindows[2] = null;
        }
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

