/* The following code was generated by JFlex 1.3.5 on 12/19/03 12:52 PM */


/************************************************************
 *
 *           File : Lexer.flex
 *         Author : Tyrel Datwyler
 *
 *    Description : The TauIL lexical analyzer.
 *
 ************************************************************/

package TauIL.lexer;

import TauIL.error.*;
import TauIL.parser.sym;
import java_cup.runtime.Symbol;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.3.5
 * on 12/19/03 12:52 PM from the specification file
 * <tt>file:/export/disk1/userSpace/tyreld/cvs/tau2/tools/src/TauIL/src/TauIL/lexer/Lexer.flex</tt>
 */
public class Lexer implements java_cup.runtime.Scanner {

  /** This character denotes the end of file */
  final public static int YYEOF = -1;

  /** initial size of the lookahead buffer */
  final private static int YY_BUFFERSIZE = 16384;

  /** lexical states */
  final public static int EXPAND = 6;
  final public static int STRING = 1;
  final public static int YYINITIAL = 0;
  final public static int COMMENT = 2;
  final public static int ENVIRONMENT = 4;
  final public static int MACROVAL = 7;
  final public static int IGNORE = 5;
  final public static int PREPROCESS = 3;

  /** 
   * Translates characters to character classes
   */
  final private static String yycmap_packed = 
    "\11\0\1\5\1\2\1\3\1\4\1\1\22\0\1\35\1\55\1\57"+
    "\1\62\1\14\1\0\1\51\3\0\1\60\1\13\1\0\1\33\1\11"+
    "\1\56\12\7\1\47\1\0\1\52\1\53\1\54\2\0\4\6\1\12"+
    "\10\6\1\63\7\6\1\64\4\6\1\65\1\10\1\66\1\0\1\45"+
    "\1\0\1\25\1\44\1\17\1\22\1\23\1\41\1\42\1\37\1\15"+
    "\2\6\1\20\1\34\1\16\1\30\1\40\1\6\1\26\1\31\1\27"+
    "\1\21\1\32\1\36\1\24\1\43\1\6\1\46\1\61\1\50\7\0"+
    "\1\3\u1fa2\0\1\3\1\3\udfd6\0";

  /** 
   * Translates characters to character classes
   */
  final private static char [] yycmap = yy_unpack_cmap(yycmap_packed);

  /** 
   * Translates a state to a row index in the transition table
   */
  final private static int yy_rowMap [] = { 
        0,    55,   110,   165,   220,   275,   330,   385,   440,   495, 
      550,   605,   660,   495,   495,   715,   770,   825,   880,   935, 
      990,  1045,  1100,  1155,  1210,  1265,  1320,  1375,  1430,  1485, 
      495,   495,  1540,   495,  1595,  1650,  1705,   495,   495,   495, 
      495,  1760,  1815,  1760,   495,   495,  1870,   495,   495,   495, 
     1925,  1980,  2035,  2090,   495,  2145,   495,  2200,  2255,   495, 
     1650,  2310,  2365,  2420,  2475,  2530,  2585,  2640,  2695,  2750, 
     2805,   550,  2860,  2915,  2970,  3025,   550,  3080,  3135,  3190, 
     3245,  3300,  3355,  3410,  3465,  3520,  3575,   495,   495,   495, 
      495,   495,   495,   495,  3630,  3685,  3740,  3795,  3850,  3905, 
     3905,  3960,  4015,  4070,  4125,  4180,  4235,  4290,  4345,  4400, 
     4455,   550,  4510,  4565,  4620,  4675,  4730,  4785,  4840,  4895, 
     4950,  5005,   550,  5060,  5115,  5170,  5225,  5280,  5335,  5390, 
     5445,  5500,  5555,  5610,  5665,  5720,  5775,  5830,  5885,  5940, 
     5995,  6050,  6105,  6160,  6215,  6270,  6325,  6380,  6435,  6490, 
      550,  6545,  6600,  6655,  6710,   550,  6765,   495,  6820,  6875, 
     6930,  6985,  7040,  7095,  7150,  7205,  7260,  7315,  7370,  7425, 
     7480,  7535,  7590,  7645,   550,  7700,  7755,  7810,  7865,  7920, 
     7975,  8030,  8085,  8140,   550,  8195,  8250,  8305,  8360,  8415, 
     8470,  8525,  8580,  8635,  8690,  8745,  8800,  8855,  8910,  8965, 
     9020,  9075,  9130,  9185,   550,  9240,   550,   550,  9295,  9350, 
     9405,  9460,  9515,  9570,   495,   550,  9625,  9680,  9735,   550, 
     9790,  9845,  9900,  9955, 10010,   550, 10065,   550, 10120, 10175, 
      550,   550, 10230, 10285, 10340, 10395, 10450,   550,   550, 10505, 
    10560, 10615, 10670, 10725, 10780, 10835, 10890, 10945, 11000, 11055, 
    11110, 11165, 11220, 11275, 11330, 11385, 11440, 11495, 11550, 11605, 
    11660,   495, 11715,   550, 11770,   495,   550, 11825, 11880, 11935, 
      550, 11990,   495, 12045, 12100,   550, 12155,   550, 12210, 12265, 
    12320, 12375, 12430,   495,   495
  };

  /** 
   * The packed transition table of the DFA (part 0)
   */
  final private static String yy_packed0 = 
    "\1\0\1\11\4\12\1\13\1\14\1\0\1\15\1\13"+
    "\1\16\1\17\1\20\1\21\1\22\1\13\1\23\1\24"+
    "\1\25\1\13\1\26\1\27\1\30\1\13\1\31\1\13"+
    "\1\0\1\13\1\12\2\13\1\32\1\33\1\34\3\13"+
    "\1\35\1\36\1\37\1\40\1\41\1\42\1\43\1\44"+
    "\1\45\1\46\1\47\1\50\1\51\2\13\2\0\1\52"+
    "\2\0\5\52\1\53\3\52\1\54\42\52\1\55\7\52"+
    "\1\56\1\57\3\60\3\56\1\61\56\56\2\62\1\0"+
    "\7\62\1\63\2\62\1\64\4\62\1\65\44\62\14\0"+
    "\1\17\15\0\1\66\34\0\1\67\1\70\4\71\27\67"+
    "\1\71\24\67\1\72\4\67\6\0\1\73\2\0\2\73"+
    "\1\0\1\17\16\73\1\0\1\73\1\0\10\73\15\0"+
    "\2\73\2\0\2\74\1\0\1\74\2\71\1\13\1\14"+
    "\1\74\1\15\1\13\1\16\1\17\1\20\1\21\1\22"+
    "\1\13\1\23\1\24\1\25\1\13\1\26\1\27\1\30"+
    "\1\13\1\31\1\13\1\74\1\13\1\71\2\13\1\32"+
    "\1\33\1\34\3\13\1\35\1\36\1\37\1\40\1\41"+
    "\1\42\1\43\1\75\1\74\1\46\1\47\1\50\1\74"+
    "\2\13\2\74\2\0\1\12\161\0\2\13\1\0\2\13"+
    "\2\0\16\13\1\0\1\13\1\0\10\13\15\0\2\13"+
    "\11\0\1\14\1\0\1\76\1\77\10\0\1\77\51\0"+
    "\1\13\1\100\1\0\2\13\2\0\16\13\1\0\1\13"+
    "\1\0\10\13\15\0\2\13\10\0\2\13\1\0\2\13"+
    "\2\0\1\13\1\101\14\13\1\0\1\13\1\0\10\13"+
    "\15\0\2\13\10\0\2\13\1\0\2\13\2\0\4\13"+
    "\1\102\11\13\1\0\1\13\1\0\10\13\15\0\2\13"+
    "\10\0\2\13\1\0\2\13\2\0\4\13\1\103\6\13"+
    "\1\104\2\13\1\0\1\13\1\0\10\13\15\0\2\13"+
    "\10\0\2\13\1\0\2\13\2\0\14\13\1\105\1\13"+
    "\1\0\1\13\1\0\10\13\15\0\2\13\10\0\2\13"+
    "\1\0\2\13\2\0\1\106\5\13\1\107\7\13\1\0"+
    "\1\13\1\0\6\13\1\110\1\13\15\0\2\13\10\0"+
    "\2\13\1\0\2\13\2\0\1\13\1\111\5\13\1\112"+
    "\5\13\1\113\1\0\1\13\1\0\10\13\15\0\2\13"+
    "\10\0\2\13\1\0\2\13\2\0\1\13\1\114\12\13"+
    "\1\115\1\13\1\0\1\13\1\0\10\13\15\0\2\13"+
    "\10\0\2\13\1\0\2\13\2\0\4\13\1\116\11\13"+
    "\1\0\1\13\1\0\10\13\15\0\2\13\10\0\2\13"+
    "\1\0\2\13\2\0\10\13\1\117\2\13\1\120\2\13"+
    "\1\0\1\13\1\0\5\13\1\121\2\13\15\0\2\13"+
    "\10\0\2\13\1\0\2\13\2\0\12\13\1\122\3\13"+
    "\1\0\1\13\1\0\10\13\15\0\2\13\10\0\2\13"+
    "\1\0\2\13\2\0\5\13\1\123\1\124\2\13\1\125"+
    "\4\13\1\0\1\13\1\0\10\13\15\0\2\13\10\0"+
    "\2\13\1\0\2\13\2\0\1\126\15\13\1\0\1\13"+
    "\1\0\10\13\15\0\2\13\10\0\2\13\1\0\2\13"+
    "\2\0\11\13\1\127\4\13\1\0\1\13\1\0\10\13"+
    "\15\0\2\13\51\0\1\130\67\0\1\131\71\0\1\132"+
    "\66\0\1\133\66\0\1\134\71\0\1\135\10\0\1\52"+
    "\2\0\5\52\1\0\46\52\1\0\7\52\2\136\1\0"+
    "\64\136\2\0\1\60\147\0\1\137\44\0\1\140\50\0"+
    "\1\141\66\0\1\142\45\0\1\71\107\0\1\143\51\0"+
    "\2\73\1\0\2\73\2\0\16\73\1\0\1\73\1\0"+
    "\10\73\15\0\2\73\11\0\1\76\2\0\1\77\10\0"+
    "\1\77\52\0\1\144\3\0\1\145\17\0\1\145\41\0"+
    "\1\13\1\100\1\0\1\13\1\146\2\0\6\13\1\146"+
    "\7\13\1\0\1\13\1\0\10\13\15\0\2\13\10\0"+
    "\2\13\1\0\2\13\2\0\2\13\1\147\11\13\1\150"+
    "\1\13\1\0\1\13\1\0\10\13\15\0\2\13\10\0"+
    "\2\13\1\0\2\13\2\0\16\13\1\0\1\151\1\0"+
    "\10\13\15\0\2\13\10\0\2\13\1\0\2\13\2\0"+
    "\16\13\1\0\1\152\1\0\10\13\15\0\2\13\10\0"+
    "\2\13\1\0\2\13\2\0\1\13\1\153\2\13\1\154"+
    "\11\13\1\0\1\13\1\0\10\13\15\0\2\13\10\0"+
    "\2\13\1\0\2\13\2\0\6\13\1\155\7\13\1\0"+
    "\1\13\1\0\10\13\15\0\2\13\10\0\2\13\1\0"+
    "\2\13\2\0\11\13\1\156\4\13\1\0\1\13\1\0"+
    "\10\13\15\0\2\13\10\0\2\13\1\0\2\13\2\0"+
    "\2\13\1\157\13\13\1\0\1\13\1\0\10\13\15\0"+
    "\2\13\10\0\2\13\1\0\2\13\2\0\5\13\1\160"+
    "\10\13\1\0\1\13\1\0\10\13\15\0\2\13\10\0"+
    "\2\13\1\0\2\13\2\0\2\13\1\161\13\13\1\0"+
    "\1\13\1\0\10\13\15\0\2\13\10\0\2\13\1\0"+
    "\2\13\2\0\6\13\1\162\7\13\1\0\1\13\1\0"+
    "\10\13\15\0\2\13\10\0\2\13\1\0\2\13\2\0"+
    "\12\13\1\163\3\13\1\0\1\13\1\0\10\13\15\0"+
    "\2\13\10\0\2\13\1\0\2\13\2\0\1\13\1\164"+
    "\14\13\1\0\1\13\1\0\10\13\15\0\2\13\10\0"+
    "\2\13\1\0\2\13\2\0\4\13\1\165\4\13\1\166"+
    "\4\13\1\0\1\13\1\0\10\13\15\0\2\13\10\0"+
    "\2\13\1\0\2\13\2\0\12\13\1\167\3\13\1\0"+
    "\1\13\1\0\10\13\15\0\2\13\10\0\2\13\1\0"+
    "\2\13\2\0\16\13\1\0\1\13\1\0\2\13\1\170"+
    "\5\13\15\0\2\13\10\0\2\13\1\0\2\13\2\0"+
    "\5\13\1\171\2\13\1\172\5\13\1\0\1\13\1\0"+
    "\10\13\15\0\2\13\10\0\2\13\1\0\2\13\2\0"+
    "\12\13\1\173\3\13\1\0\1\13\1\0\10\13\15\0"+
    "\2\13\10\0\2\13\1\0\2\13\2\0\11\13\1\174"+
    "\4\13\1\0\1\13\1\0\10\13\15\0\2\13\10\0"+
    "\2\13\1\0\2\13\2\0\13\13\1\175\2\13\1\0"+
    "\1\13\1\0\10\13\15\0\2\13\10\0\2\13\1\0"+
    "\2\13\2\0\3\13\1\176\12\13\1\0\1\13\1\0"+
    "\10\13\15\0\2\13\10\0\2\13\1\0\2\13\2\0"+
    "\13\13\1\177\2\13\1\0\1\13\1\0\10\13\15\0"+
    "\2\13\66\0\1\200\20\0\1\201\3\0\1\202\105\0"+
    "\1\203\53\0\1\204\56\0\1\205\57\0\1\144\65\0"+
    "\2\13\1\0\2\13\1\145\1\0\16\13\1\145\1\13"+
    "\1\0\10\13\15\0\2\13\10\0\2\13\1\0\2\13"+
    "\2\0\3\13\1\206\12\13\1\0\1\13\1\0\10\13"+
    "\15\0\2\13\10\0\2\13\1\0\2\13\2\0\12\13"+
    "\1\207\3\13\1\0\1\13\1\0\10\13\15\0\2\13"+
    "\10\0\2\13\1\0\2\13\2\0\2\13\1\210\11\13"+
    "\1\211\1\13\1\0\1\13\1\0\10\13\15\0\2\13"+
    "\10\0\2\13\1\0\2\13\2\0\4\13\1\212\11\13"+
    "\1\0\1\13\1\0\10\13\15\0\2\13\10\0\2\13"+
    "\1\0\2\13\2\0\5\13\1\213\10\13\1\0\1\13"+
    "\1\0\10\13\15\0\2\13\10\0\2\13\1\0\2\13"+
    "\2\0\1\13\1\214\14\13\1\0\1\13\1\0\10\13"+
    "\15\0\2\13\10\0\2\13\1\0\2\13\2\0\2\13"+
    "\1\215\13\13\1\0\1\13\1\0\10\13\15\0\2\13"+
    "\10\0\2\13\1\0\2\13\2\0\6\13\1\216\7\13"+
    "\1\0\1\13\1\0\10\13\15\0\2\13\10\0\2\13"+
    "\1\0\2\13\2\0\3\13\1\217\12\13\1\0\1\13"+
    "\1\0\10\13\15\0\2\13\10\0\2\13\1\0\2\13"+
    "\2\0\3\13\1\220\12\13\1\0\1\13\1\0\10\13"+
    "\15\0\2\13\10\0\2\13\1\0\2\13\2\0\1\13"+
    "\1\221\14\13\1\0\1\13\1\0\10\13\15\0\2\13"+
    "\10\0\2\13\1\0\2\13\2\0\1\222\15\13\1\0"+
    "\1\13\1\0\10\13\15\0\2\13\10\0\2\13\1\0"+
    "\2\13\2\0\12\13\1\223\3\13\1\0\1\13\1\0"+
    "\10\13\15\0\2\13\10\0\2\13\1\0\2\13\2\0"+
    "\16\13\1\0\1\13\1\0\7\13\1\224\15\0\2\13"+
    "\10\0\2\13\1\0\2\13\2\0\16\13\1\0\1\13"+
    "\1\0\4\13\1\225\3\13\15\0\2\13\10\0\2\13"+
    "\1\0\2\13\2\0\10\13\1\226\5\13\1\0\1\13"+
    "\1\0\10\13\15\0\2\13\10\0\2\13\1\0\2\13"+
    "\2\0\6\13\1\227\7\13\1\0\1\13\1\0\10\13"+
    "\15\0\2\13\10\0\2\13\1\0\2\13\2\0\5\13"+
    "\1\230\10\13\1\0\1\13\1\0\10\13\15\0\2\13"+
    "\10\0\2\13\1\0\2\13\2\0\12\13\1\231\3\13"+
    "\1\0\1\13\1\0\10\13\15\0\2\13\10\0\2\13"+
    "\1\0\2\13\2\0\2\13\1\232\13\13\1\0\1\13"+
    "\1\0\10\13\15\0\2\13\10\0\2\13\1\0\2\13"+
    "\2\0\16\13\1\0\1\13\1\0\3\13\1\233\4\13"+
    "\15\0\2\13\10\0\2\13\1\0\2\13\2\0\6\13"+
    "\1\234\7\13\1\0\1\13\1\0\10\13\15\0\2\13"+
    "\10\0\2\13\1\0\2\13\2\0\4\13\1\235\11\13"+
    "\1\0\1\13\1\0\10\13\15\0\2\13\47\0\1\236"+
    "\43\0\1\237\67\0\1\240\60\0\1\241\102\0\1\242"+
    "\57\0\1\243\52\0\2\13\1\0\2\13\2\0\4\13"+
    "\1\244\11\13\1\0\1\13\1\0\10\13\15\0\2\13"+
    "\10\0\2\13\1\0\2\13\2\0\11\13\1\245\4\13"+
    "\1\0\1\13\1\0\10\13\15\0\2\13\10\0\2\13"+
    "\1\0\2\13\2\0\10\13\1\246\5\13\1\0\1\13"+
    "\1\0\10\13\15\0\2\13\10\0\2\13\1\0\2\13"+
    "\2\0\4\13\1\247\11\13\1\0\1\13\1\0\10\13"+
    "\15\0\2\13\10\0\2\13\1\0\2\13\2\0\14\13"+
    "\1\250\1\13\1\0\1\13\1\0\10\13\15\0\2\13"+
    "\10\0\2\13\1\0\2\13\2\0\1\251\15\13\1\0"+
    "\1\13\1\0\10\13\15\0\2\13\10\0\2\13\1\0"+
    "\2\13\2\0\12\13\1\252\3\13\1\0\1\13\1\0"+
    "\10\13\15\0\2\13\10\0\2\13\1\0\2\13\2\0"+
    "\14\13\1\253\1\13\1\0\1\13\1\0\10\13\15\0"+
    "\2\13\10\0\2\13\1\0\2\13\2\0\2\13\1\254"+
    "\13\13\1\0\1\13\1\0\10\13\15\0\2\13\10\0"+
    "\2\13\1\0\2\13\2\0\10\13\1\255\5\13\1\0"+
    "\1\13\1\0\10\13\15\0\2\13\10\0\2\13\1\0"+
    "\2\13\2\0\4\13\1\256\11\13\1\0\1\13\1\0"+
    "\10\13\15\0\2\13\10\0\2\13\1\0\2\13\2\0"+
    "\12\13\1\257\3\13\1\0\1\13\1\0\10\13\15\0"+
    "\2\13\10\0\2\13\1\0\2\13\2\0\16\13\1\260"+
    "\1\13\1\0\10\13\15\0\2\13\10\0\2\13\1\0"+
    "\2\13\2\0\1\261\15\13\1\0\1\13\1\0\10\13"+
    "\15\0\2\13\10\0\2\13\1\0\2\13\2\0\16\13"+
    "\1\0\1\13\1\0\2\13\1\262\5\13\15\0\2\13"+
    "\10\0\2\13\1\0\2\13\2\0\6\13\1\263\7\13"+
    "\1\0\1\13\1\0\10\13\15\0\2\13\10\0\2\13"+
    "\1\0\2\13\2\0\3\13\1\264\12\13\1\0\1\13"+
    "\1\0\10\13\15\0\2\13\10\0\2\13\1\0\2\13"+
    "\2\0\6\13\1\265\7\13\1\0\1\13\1\0\10\13"+
    "\15\0\2\13\10\0\2\13\1\0\2\13\2\0\1\266"+
    "\15\13\1\0\1\13\1\0\10\13\15\0\2\13\10\0"+
    "\2\13\1\0\2\13\2\0\6\13\1\267\7\13\1\0"+
    "\1\13\1\0\10\13\15\0\2\13\10\0\2\13\1\0"+
    "\2\13\2\0\1\270\15\13\1\0\1\13\1\0\10\13"+
    "\15\0\2\13\10\0\2\13\1\0\2\13\2\0\16\13"+
    "\1\0\1\13\1\0\2\13\1\271\5\13\15\0\2\13"+
    "\25\0\1\272\104\0\1\273\43\0\1\274\65\0\1\275"+
    "\66\0\1\276\57\0\2\13\1\0\2\13\2\0\5\13"+
    "\1\277\10\13\1\0\1\13\1\0\10\13\15\0\2\13"+
    "\10\0\2\13\1\0\2\13\2\0\4\13\1\300\11\13"+
    "\1\0\1\13\1\0\10\13\15\0\2\13\10\0\2\13"+
    "\1\0\2\13\2\0\3\13\1\301\12\13\1\0\1\13"+
    "\1\0\10\13\15\0\2\13\10\0\2\13\1\0\2\13"+
    "\2\0\16\13\1\0\1\13\1\0\6\13\1\302\1\13"+
    "\15\0\2\13\10\0\2\13\1\0\2\13\2\0\6\13"+
    "\1\303\7\13\1\0\1\13\1\0\10\13\15\0\2\13"+
    "\10\0\2\13\1\0\2\13\2\0\12\13\1\304\3\13"+
    "\1\0\1\13\1\0\10\13\15\0\2\13\10\0\2\13"+
    "\1\0\2\13\2\0\14\13\1\305\1\13\1\0\1\13"+
    "\1\0\10\13\15\0\2\13\10\0\2\13\1\0\2\13"+
    "\2\0\16\13\1\0\1\13\1\0\10\13\10\0\1\306"+
    "\4\0\2\13\10\0\2\13\1\0\2\13\2\0\12\13"+
    "\1\307\3\13\1\0\1\13\1\0\10\13\15\0\2\13"+
    "\10\0\2\13\1\0\2\13\2\0\11\13\1\310\4\13"+
    "\1\0\1\13\1\0\10\13\15\0\2\13\10\0\2\13"+
    "\1\0\2\13\2\0\5\13\1\311\10\13\1\0\1\13"+
    "\1\0\10\13\15\0\2\13\21\0\1\312\55\0\2\13"+
    "\1\0\2\13\2\0\16\13\1\0\1\313\1\0\10\13"+
    "\15\0\2\13\10\0\2\13\1\0\2\13\2\0\11\13"+
    "\1\314\4\13\1\0\1\13\1\0\10\13\15\0\2\13"+
    "\10\0\2\13\1\0\2\13\2\0\12\13\1\315\3\13"+
    "\1\0\1\13\1\0\10\13\15\0\2\13\10\0\2\13"+
    "\1\0\2\13\2\0\2\13\1\316\13\13\1\0\1\13"+
    "\1\0\10\13\15\0\2\13\10\0\2\13\1\0\2\13"+
    "\2\0\15\13\1\317\1\0\1\13\1\0\10\13\15\0"+
    "\2\13\10\0\2\13\1\0\2\13\2\0\2\13\1\320"+
    "\13\13\1\0\1\13\1\0\10\13\15\0\2\13\10\0"+
    "\2\13\1\0\2\13\2\0\1\13\1\321\14\13\1\0"+
    "\1\13\1\0\10\13\15\0\2\13\10\0\2\13\1\0"+
    "\2\13\2\0\3\13\1\322\12\13\1\0\1\13\1\0"+
    "\10\13\15\0\2\13\43\0\1\323\62\0\1\324\54\0"+
    "\1\325\73\0\1\326\77\0\1\327\33\0\2\13\1\0"+
    "\2\13\2\0\6\13\1\330\7\13\1\0\1\13\1\0"+
    "\10\13\15\0\2\13\10\0\2\13\1\0\2\13\2\0"+
    "\16\13\1\0\1\331\1\0\10\13\15\0\2\13\10\0"+
    "\2\13\1\0\2\13\2\0\3\13\1\332\12\13\1\0"+
    "\1\13\1\0\10\13\15\0\2\13\10\0\2\13\1\0"+
    "\2\13\2\0\11\13\1\333\4\13\1\0\1\13\1\0"+
    "\10\13\15\0\2\13\10\0\2\13\1\0\2\13\2\0"+
    "\2\13\1\334\13\13\1\0\1\13\1\0\10\13\15\0"+
    "\2\13\10\0\2\13\1\0\2\13\2\0\1\335\15\13"+
    "\1\0\1\13\1\0\10\13\15\0\2\13\10\0\2\13"+
    "\1\0\2\13\2\0\16\13\1\0\1\13\1\0\10\13"+
    "\10\0\1\336\4\0\2\13\21\0\1\337\55\0\2\13"+
    "\1\0\2\13\2\0\1\340\15\13\1\0\1\13\1\0"+
    "\10\13\15\0\2\13\10\0\2\13\1\0\2\13\2\0"+
    "\10\13\1\341\5\13\1\0\1\13\1\0\10\13\15\0"+
    "\2\13\10\0\2\13\1\0\2\13\2\0\6\13\1\342"+
    "\7\13\1\0\1\13\1\0\10\13\15\0\2\13\32\0"+
    "\1\343\44\0\2\13\1\0\2\13\2\0\6\13\1\344"+
    "\7\13\1\0\1\13\1\0\10\13\15\0\2\13\10\0"+
    "\2\13\1\0\2\13\2\0\13\13\1\345\2\13\1\0"+
    "\1\13\1\0\10\13\15\0\2\13\10\0\2\13\1\0"+
    "\2\13\2\0\13\13\1\346\2\13\1\0\1\13\1\0"+
    "\10\13\15\0\2\13\10\0\2\13\1\0\2\13\2\0"+
    "\12\13\1\347\3\13\1\0\1\13\1\0\10\13\15\0"+
    "\2\13\10\0\2\13\1\0\2\13\2\0\6\13\1\350"+
    "\7\13\1\0\1\13\1\0\10\13\15\0\2\13\37\0"+
    "\1\351\45\0\1\352\107\0\1\353\47\0\1\354\56\0"+
    "\2\13\1\0\2\13\2\0\6\13\1\355\7\13\1\0"+
    "\1\13\1\0\10\13\15\0\2\13\10\0\2\13\1\0"+
    "\2\13\2\0\14\13\1\356\1\13\1\0\1\13\1\0"+
    "\10\13\15\0\2\13\10\0\2\13\1\0\2\13\2\0"+
    "\14\13\1\357\1\13\1\0\1\13\1\0\10\13\15\0"+
    "\2\13\10\0\2\13\1\0\2\13\2\0\13\13\1\360"+
    "\2\13\1\0\1\13\1\0\10\13\15\0\2\13\21\0"+
    "\1\361\74\0\1\362\47\0\2\13\1\0\2\13\2\0"+
    "\15\13\1\363\1\0\1\13\1\0\10\13\15\0\2\13"+
    "\10\0\2\13\1\0\2\13\2\0\12\13\1\364\3\13"+
    "\1\0\1\13\1\0\10\13\15\0\2\13\20\0\1\365"+
    "\56\0\2\13\1\0\2\13\2\0\16\13\1\0\1\13"+
    "\1\0\3\13\1\366\4\13\15\0\2\13\10\0\2\13"+
    "\1\0\2\13\2\0\4\13\1\367\11\13\1\0\1\13"+
    "\1\0\10\13\15\0\2\13\16\0\1\370\60\0\1\371"+
    "\2\0\2\371\2\0\16\371\1\0\1\371\1\0\10\371"+
    "\15\0\2\371\10\0\1\372\2\0\2\372\2\0\16\372"+
    "\1\0\1\372\1\0\10\372\15\0\2\372\67\0\1\373"+
    "\7\0\2\13\1\0\2\13\2\0\1\13\1\374\14\13"+
    "\1\0\1\13\1\0\10\13\15\0\2\13\10\0\2\13"+
    "\1\0\2\13\2\0\1\13\1\375\14\13\1\0\1\13"+
    "\1\0\10\13\15\0\2\13\27\0\1\376\61\0\1\377"+
    "\54\0\2\13\1\0\2\13\2\0\6\13\1\u0100\7\13"+
    "\1\0\1\13\1\0\10\13\15\0\2\13\10\0\2\13"+
    "\1\0\2\13\2\0\1\u0101\15\13\1\0\1\13\1\0"+
    "\10\13\15\0\2\13\24\0\1\u0102\52\0\2\13\1\0"+
    "\2\13\2\0\1\u0103\15\13\1\0\1\13\1\0\10\13"+
    "\15\0\2\13\10\0\2\13\1\0\2\13\2\0\1\13"+
    "\1\u0104\14\13\1\0\1\13\1\0\10\13\15\0\2\13"+
    "\10\0\1\u0105\2\0\2\u0105\2\0\16\u0105\1\0\1\u0105"+
    "\1\0\10\u0105\15\0\2\u0105\10\0\2\371\1\0\2\371"+
    "\2\0\16\371\1\0\1\371\1\0\10\371\15\0\2\371"+
    "\10\0\2\372\1\0\2\372\2\0\16\372\1\0\1\372"+
    "\1\0\10\372\15\0\2\372\11\0\1\373\1\0\1\373"+
    "\54\0\1\u0106\6\0\2\13\1\0\2\13\2\0\12\13"+
    "\1\u0107\3\13\1\0\1\13\1\0\10\13\15\0\2\13"+
    "\10\0\2\13\1\0\2\13\2\0\14\13\1\u0108\1\13"+
    "\1\0\1\13\1\0\10\13\15\0\2\13\22\0\1\u0109"+
    "\66\0\1\u010a\54\0\2\13\1\0\2\13\2\0\14\13"+
    "\1\u010b\1\13\1\0\1\13\1\0\10\13\15\0\2\13"+
    "\10\0\2\13\1\0\2\13\2\0\13\13\1\u010c\2\13"+
    "\1\0\1\13\1\0\10\13\15\0\2\13\17\0\1\u010d"+
    "\57\0\2\13\1\0\2\13\2\0\3\13\1\u010e\12\13"+
    "\1\0\1\13\1\0\10\13\15\0\2\13\10\0\2\13"+
    "\1\0\2\13\2\0\12\13\1\u010f\3\13\1\0\1\13"+
    "\1\0\10\13\15\0\2\13\10\0\2\u0105\1\0\2\u0105"+
    "\2\0\16\u0105\1\0\1\u0105\1\0\10\u0105\15\0\2\u0105"+
    "\10\0\2\13\1\0\2\13\2\0\16\13\1\0\1\13"+
    "\1\u0110\10\13\15\0\2\13\22\0\1\u0111\54\0\2\13"+
    "\1\0\2\13\2\0\1\13\1\u0112\14\13\1\0\1\13"+
    "\1\0\10\13\15\0\2\13\31\0\1\u0113\45\0\2\13"+
    "\1\0\2\13\2\0\6\13\1\u0114\7\13\1\0\1\13"+
    "\1\0\10\13\15\0\2\13\40\0\1\u0115\36\0\2\13"+
    "\1\0\2\13\2\0\14\13\1\u0116\1\13\1\0\1\13"+
    "\1\0\10\13\15\0\2\13\17\0\1\u0117\66\0\1\u0118"+
    "\101\0\1\u0119\65\0\1\u011a\55\0\1\u011b\107\0\1\u011c"+
    "\60\0\1\u011d\35\0";

  /** 
   * The transition table of the DFA
   */
  final private static int yytrans [] = yy_unpack();


  /* error codes */
  final private static int YY_UNKNOWN_ERROR = 0;
  final private static int YY_ILLEGAL_STATE = 1;
  final private static int YY_NO_MATCH = 2;
  final private static int YY_PUSHBACK_2BIG = 3;

  /* error messages for the codes above */
  final private static String YY_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Internal error: unknown state",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * YY_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private final static byte YY_ATTRIBUTE[] = {
     0,  0,  0,  0,  0,  0,  0,  0,  1,  9,  1,  1,  1,  9,  9,  1, 
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  9,  9, 
     1,  9,  1,  0,  0,  9,  9,  9,  9,  1,  0,  1,  9,  9,  1,  9, 
     9,  9,  1,  1,  1,  0,  9,  1,  9,  1,  1,  9,  1,  1,  0,  1, 
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 
     1,  1,  1,  1,  1,  1,  1,  9,  9,  9,  9,  9,  9,  9,  0,  0, 
     0,  0,  0,  1,  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  0, 
     0,  0,  0,  0,  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  9,  0,  0, 
     0,  0,  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  0, 
     1,  1,  1,  1,  1,  1,  1,  1,  1,  0,  0,  0,  0,  0,  1,  1, 
     1,  1,  1,  1,  1,  0,  1,  1,  1,  0,  1,  1,  1,  1,  1,  1, 
     1,  1,  0,  0,  0,  0,  9,  1,  1,  1,  1,  1,  1,  0,  0,  1, 
     1,  1,  0,  1,  1,  1,  1,  1,  0,  0,  0,  0,  1,  1,  1,  1, 
     0,  0,  1,  1,  0,  1,  1,  0,  1,  1,  0,  1,  1,  0,  0,  1, 
     1,  0,  1,  1,  1,  9,  1,  1,  0,  9,  1,  1,  0,  1,  1,  0, 
     9,  1,  0,  1,  0,  1,  0,  0,  0,  0,  0,  9,  9
  };

  /** the input device */
  private java.io.Reader yy_reader;

  /** the current state of the DFA */
  private int yy_state;

  /** the current lexical state */
  private int yy_lexical_state = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char yy_buffer[] = new char[YY_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int yy_markedPos;

  /** the textposition at the last state to be included in yytext */
  private int yy_pushbackPos;

  /** the current text position in the buffer */
  private int yy_currentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int yy_startRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int yy_endRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn; 

  /** 
   * yy_atBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean yy_atBOL = true;

  /** yy_atEOF == true <=> the scanner is at the EOF */
  private boolean yy_atEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean yy_eof_done;

  /* user code: */
	private MessageManager errors;

	private boolean extra_comment_line = false;
        private boolean debug = false ;

	private int return_state = YYINITIAL;

        private StringBuffer string = new StringBuffer();
        private HashMap table = new HashMap();

	/**
	 * Constructs a scanner that records error messages in the
	 * given {@link ErrorMessage} object.
	 *
	 * @param in the java.io.InputStream to read input from.
	 * @param errors the object to use for recording error messages.
	 */
	public Lexer(InputStream in, MessageManager errors) {
		this(in);
		this.errors = errors;
	}

	/**
	 * Constructs a scanner that records error messages in the
	 * given {@link ErrorMessage} object.
	 *
	 * @param in the java.io.Reader to read input from.
	 * @param errors the object to use for recording error messages.
	 */
	public Lexer(Reader in, MessageManager errors) {
		this(in);
		this.errors = errors;
	}
	
	/**
	 * Turns on and off lexer debug mode.
	 * 
	 * @param debug true value enables and a false value disables debuging messages.
	 */
        public void setDebugMode(boolean debug) {
                this.debug = debug;
        }

	public void defineMacros(HashMap macros) {
		table = macros;
	}

	private Symbol yysym(int sym, Token val) {
		return new Symbol(sym, val.left_col, val.right_col, val);
	}

	private Symbol token(int sym) {
		Token value = new Token(yyline, yycolumn, yycolumn + yylength());
		return yysym(sym, value);
	}

	private Symbol token(int sym, Double num) {
		Token value = new DoubleToken(yyline, yycolumn, yycolumn + yylength(), num);
		return yysym(sym, value);
	}

	private Symbol token(int sym, String str) {
		Token value = new StringToken(yyline, yycolumn, yycolumn + yylength(), str);
		return yysym(sym, value);
	}

	public static Symbol makeMacroValue(String str) {
		Token value = new StringToken(-1, -1, 0, str);
		return new Symbol(sym.STRING, -1, -1, value);
	}	

        private void debug(String text) {
	        if (debug)
		        System.out.println(text);
        }



  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public Lexer(java.io.Reader in) {
    this.yy_reader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public Lexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the split, compressed DFA transition table.
   *
   * @return the unpacked transition table
   */
  private static int [] yy_unpack() {
    int [] trans = new int[12485];
    int offset = 0;
    offset = yy_unpack(yy_packed0, offset, trans);
    return trans;
  }

  /** 
   * Unpacks the compressed DFA transition table.
   *
   * @param packed   the packed transition table
   * @return         the index of the last entry
   */
  private static int yy_unpack(String packed, int offset, int [] trans) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do trans[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] yy_unpack_cmap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 150) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   IOException  if any I/O-Error occurs
   */
  private boolean yy_refill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (yy_startRead > 0) {
      System.arraycopy(yy_buffer, yy_startRead, 
                       yy_buffer, 0, 
                       yy_endRead-yy_startRead);

      /* translate stored positions */
      yy_endRead-= yy_startRead;
      yy_currentPos-= yy_startRead;
      yy_markedPos-= yy_startRead;
      yy_pushbackPos-= yy_startRead;
      yy_startRead = 0;
    }

    /* is the buffer big enough? */
    if (yy_currentPos >= yy_buffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[yy_currentPos*2];
      System.arraycopy(yy_buffer, 0, newBuffer, 0, yy_buffer.length);
      yy_buffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = yy_reader.read(yy_buffer, yy_endRead, 
                                            yy_buffer.length-yy_endRead);

    if (numRead < 0) {
      return true;
    }
    else {
      yy_endRead+= numRead;  
      return false;
    }
  }


  /**
   * Closes the input stream.
   */
  final public void yyclose() throws java.io.IOException {
    yy_atEOF = true;            /* indicate end of file */
    yy_endRead = yy_startRead;  /* invalidate buffer    */

    if (yy_reader != null)
      yy_reader.close();
  }


  /**
   * Closes the current stream, and resets the
   * scanner to read from a new input stream.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>YY_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  final public void yyreset(java.io.Reader reader) throws java.io.IOException {
    yyclose();
    yy_reader = reader;
    yy_atBOL  = true;
    yy_atEOF  = false;
    yy_endRead = yy_startRead = 0;
    yy_currentPos = yy_markedPos = yy_pushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    yy_lexical_state = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  final public int yystate() {
    return yy_lexical_state;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  final public void yybegin(int newState) {
    yy_lexical_state = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  final public String yytext() {
    return new String( yy_buffer, yy_startRead, yy_markedPos-yy_startRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  final public char yycharat(int pos) {
    return yy_buffer[yy_startRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  final public int yylength() {
    return yy_markedPos-yy_startRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void yy_ScanError(int errorCode) {
    String message;
    try {
      message = YY_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = YY_ERROR_MSG[YY_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  private void yypushback(int number)  {
    if ( number > yylength() )
      yy_ScanError(YY_PUSHBACK_2BIG);

    yy_markedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void yy_do_eof() throws java.io.IOException {
    if (!yy_eof_done) {
      yy_eof_done = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException {
    int yy_input;
    int yy_action;

    // cached fields:
    int yy_currentPos_l;
    int yy_startRead_l;
    int yy_markedPos_l;
    int yy_endRead_l = yy_endRead;
    char [] yy_buffer_l = yy_buffer;
    char [] yycmap_l = yycmap;

    int [] yytrans_l = yytrans;
    int [] yy_rowMap_l = yy_rowMap;
    byte [] yy_attr_l = YY_ATTRIBUTE;

    while (true) {
      yy_markedPos_l = yy_markedPos;

      boolean yy_r = false;
      for (yy_currentPos_l = yy_startRead; yy_currentPos_l < yy_markedPos_l;
                                                             yy_currentPos_l++) {
        switch (yy_buffer_l[yy_currentPos_l]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          yy_r = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          yy_r = true;
          break;
        case '\n':
          if (yy_r)
            yy_r = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          yy_r = false;
          yycolumn++;
        }
      }

      if (yy_r) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean yy_peek;
        if (yy_markedPos_l < yy_endRead_l)
          yy_peek = yy_buffer_l[yy_markedPos_l] == '\n';
        else if (yy_atEOF)
          yy_peek = false;
        else {
          boolean eof = yy_refill();
          yy_markedPos_l = yy_markedPos;
          yy_buffer_l = yy_buffer;
          if (eof) 
            yy_peek = false;
          else 
            yy_peek = yy_buffer_l[yy_markedPos_l] == '\n';
        }
        if (yy_peek) yyline--;
      }
      yy_action = -1;

      yy_startRead_l = yy_currentPos_l = yy_currentPos = 
                       yy_startRead = yy_markedPos_l;

      yy_state = yy_lexical_state;


      yy_forAction: {
        while (true) {

          if (yy_currentPos_l < yy_endRead_l)
            yy_input = yy_buffer_l[yy_currentPos_l++];
          else if (yy_atEOF) {
            yy_input = YYEOF;
            break yy_forAction;
          }
          else {
            // store back cached positions
            yy_currentPos  = yy_currentPos_l;
            yy_markedPos   = yy_markedPos_l;
            boolean eof = yy_refill();
            // get translated positions and possibly new buffer
            yy_currentPos_l  = yy_currentPos;
            yy_markedPos_l   = yy_markedPos;
            yy_buffer_l      = yy_buffer;
            yy_endRead_l     = yy_endRead;
            if (eof) {
              yy_input = YYEOF;
              break yy_forAction;
            }
            else {
              yy_input = yy_buffer_l[yy_currentPos_l++];
            }
          }
          int yy_next = yytrans_l[ yy_rowMap_l[yy_state] + yycmap_l[yy_input] ];
          if (yy_next == -1) break yy_forAction;
          yy_state = yy_next;

          int yy_attributes = yy_attr_l[yy_state];
          if ( (yy_attributes & 1) == 1 ) {
            yy_action = yy_state; 
            yy_markedPos_l = yy_currentPos_l; 
            if ( (yy_attributes & 8) == 8 ) break yy_forAction;
          }

        }
      }

      // store back cached position
      yy_markedPos = yy_markedPos_l;

      switch (yy_action) {

        case 263: 
          {  return token(sym.CONDS);  }
        case 286: break;
        case 207: 
          {  return token(sym.STATIC);  }
        case 287: break;
        case 206: 
          {  return token(sym.STDDEV);  }
        case 288: break;
        case 204: 
          {  return token(sym.TARGET);  }
        case 289: break;
        case 184: 
          {  return token(sym.GROUP);  }
        case 290: break;
        case 174: 
          {  return token(sym.EVENT);  }
        case 291: break;
        case 169: 
          {  return token(sym.COUNT);  }
        case 292: break;
        case 39: 
          {  /* return token(sym.UNION); */  }
        case 293: break;
        case 38: 
          {  /* return token(sym.KLEENE); */  }
        case 294: break;
        case 28: 
          {  return token(sym.LBRACE);  }
        case 295: break;
        case 29: 
          {  return token(sym.COLON);  }
        case 296: break;
        case 30: 
          {  return token(sym.RBRACE);  }
        case 297: break;
        case 261: 
          {  debug("Processed version variable.");
				  debug("VERSION = " + yytext().substring(8, yylength() - 1)); 
				  yybegin(COMMENT);  }
        case 298: break;
        case 249: 
          {  String key = yytext().substring(7);
	                          yybegin(MACROVAL);
				  debug("Calling next_token");
                                  Symbol value = next_token();
				  table.put(key, value);
	                          yybegin(COMMENT); 
				  debug("Processed define.");  }
        case 299: break;
        case 214: 
          {  yybegin(COMMENT); 
                        	  debug("Processed endif.");  }
        case 300: break;
        case 8: 
        case 9: 
          {  /* Ignore all whitespace */  }
        case 301: break;
        case 49: 
        case 50: 
        case 51: 
        case 52: 
          {  yybegin(COMMENT); 
				  yypushback(yylength());  }
        case 302: break;
        case 55: 
        case 56: 
          {   }
        case 303: break;
        case 284: 
          {  return token(sym.ANTICONDS);  }
        case 304: break;
        case 283: 
          {  return token(sym.INSTRUMENT);  }
        case 305: break;
        case 265: 
          {  return token(sym.USECS_CALL);  }
        case 306: break;
        case 13: 
          {  /* return token(sym.NON_EMPTY); */  }
        case 307: break;
        case 87: 
          {  return token(sym.LCOLBRACE);  }
        case 308: break;
        case 88: 
          {  return token(sym.RCOLBRACE);  }
        case 309: break;
        case 14: 
        case 43: 
          {  return_state = yystate(); debug("Expanding Macro"); yybegin(EXPAND);  }
        case 310: break;
        case 45: 
          {  /* Eat up comment text up to end of line */  }
        case 311: break;
        case 270: 
          {  return token(sym.TOTCOUNT);  }
        case 312: break;
        case 238: 
          {  return token(sym.NUMSUBRS);  }
        case 313: break;
        case 237: 
          {  return token(sym.NUMCALLS);  }
        case 314: break;
        case 231: 
          {  return token(sym.PROFILE);  }
        case 315: break;
        case 230: 
          {  return token(sym.PERCENT);  }
        case 316: break;
        case 227: 
          {  return token(sym.RUNTIME);  }
        case 317: break;
        case 225: 
          {  return token(sym.EXCLUDE);  }
        case 318: break;
        case 219: 
          {  return token(sym.CUMUSEC);  }
        case 319: break;
        case 215: 
          {  return token(sym.INCLUDE);  }
        case 320: break;
        case 277: 
          {  return token(sym.DECS);  }
        case 321: break;
        case 266: 
          {  return token(sym.DIRS);  }
        case 322: break;
        case 155: 
          {  return token(sym.FILE);  }
        case 323: break;
        case 150: 
          {  return token(sym.TYPE);  }
        case 324: break;
        case 140: 
          {  return token(sym.USEC);  }
        case 325: break;
        case 122: 
          {  return token(sym.PDT);  }
        case 326: break;
        case 111: 
          {  return token(sym.END);  }
        case 327: break;
        case 108: 
          {  return token(sym.USE);  }
        case 328: break;
        case 37: 
          {  debug("Found a String"); yybegin(STRING); string.setLength(0);  }
        case 329: break;
        case 31: 
          {  return token(sym.AND);  }
        case 330: break;
        case 11: 
        case 61: 
        case 99: 
          {  return token(sym.NUM, new Double(yytext()));  }
        case 331: break;
        case 89: 
          {  return token(sym.LTEQ);  }
        case 332: break;
        case 90: 
          {  return token(sym.GTEQ);  }
        case 333: break;
        case 91: 
          {  return token(sym.NEQ);  }
        case 334: break;
        case 275: 
          {  return token(sym.TAU_PROFILE);  }
        case 335: break;
        case 272: 
          {  return token(sym.COUNTS_CALL);  }
        case 336: break;
        case 10: 
        case 12: 
        case 15: 
        case 16: 
        case 17: 
        case 18: 
        case 19: 
        case 20: 
        case 21: 
        case 22: 
        case 23: 
        case 24: 
        case 25: 
        case 26: 
        case 27: 
        case 63: 
        case 64: 
        case 65: 
        case 66: 
        case 67: 
        case 68: 
        case 69: 
        case 70: 
        case 72: 
        case 73: 
        case 74: 
        case 75: 
        case 77: 
        case 78: 
        case 79: 
        case 80: 
        case 81: 
        case 82: 
        case 83: 
        case 84: 
        case 85: 
        case 86: 
        case 101: 
        case 102: 
        case 103: 
        case 104: 
        case 105: 
        case 106: 
        case 107: 
        case 109: 
        case 110: 
        case 112: 
        case 113: 
        case 114: 
        case 115: 
        case 116: 
        case 117: 
        case 118: 
        case 119: 
        case 120: 
        case 121: 
        case 123: 
        case 124: 
        case 125: 
        case 126: 
        case 133: 
        case 134: 
        case 135: 
        case 136: 
        case 137: 
        case 138: 
        case 139: 
        case 141: 
        case 142: 
        case 143: 
        case 144: 
        case 145: 
        case 146: 
        case 147: 
        case 148: 
        case 149: 
        case 151: 
        case 152: 
        case 153: 
        case 154: 
        case 156: 
        case 163: 
        case 164: 
        case 165: 
        case 166: 
        case 167: 
        case 168: 
        case 170: 
        case 171: 
        case 172: 
        case 173: 
        case 176: 
        case 177: 
        case 178: 
        case 179: 
        case 180: 
        case 181: 
        case 182: 
        case 183: 
        case 190: 
        case 191: 
        case 192: 
        case 193: 
        case 194: 
        case 195: 
        case 196: 
        case 198: 
        case 199: 
        case 200: 
        case 202: 
        case 203: 
        case 205: 
        case 208: 
        case 209: 
        case 216: 
        case 217: 
        case 218: 
        case 220: 
        case 223: 
        case 224: 
        case 228: 
        case 229: 
        case 236: 
        case 239: 
        case 242: 
        case 243: 
        case 245: 
        case 246: 
        case 251: 
        case 252: 
        case 255: 
        case 256: 
        case 258: 
        case 259: 
        case 262: 
        case 267: 
        case 269: 
        case 273: 
          {  return token(sym.ID, yytext());  }
        case 337: break;
        case 44: 
          {  yybegin(YYINITIAL);
				  return token(sym.STRING, string.toString());  }
        case 338: break;
        case 260: 
          {  String key = yytext().substring(8);
	                          if (table.containsKey(key))
				    yybegin(IGNORE);
				  else 
				    yybegin(COMMENT);
	                          debug("Processed ifndef.");  }
        case 339: break;
        case 58: 
          {  yybegin(return_state);
				  debug("MACRO = $" + yytext());
		                  debug("MACRO TABLE = " + table.toString());
				  Symbol macro = (Symbol) table.get(yytext()); 
				  if (macro != null) 
				    return (Symbol) table.get(yytext());  }
        case 340: break;
        case 59: 
        case 60: 
          {  yypushback(yylength()); return null;  }
        case 341: break;
        case 248: 
          {  String key = yytext().substring(7);
				  System.out.println("key : " + key);
	                          if (table.containsKey(key))
				    yybegin(COMMENT);
				  else
				    yybegin(IGNORE);
	                          debug("Processed ifdef.");  }
        case 342: break;
        case 34: 
          {  return token(sym.GT);  }
        case 343: break;
        case 33: 
          {  return token(sym.EQ);  }
        case 344: break;
        case 32: 
          {  return token(sym.LT);  }
        case 345: break;
        case 46: 
        case 47: 
          {  if (extra_comment_line)
					extra_comment_line = false;
				  else
					yybegin(YYINITIAL);  }
        case 346: break;
        case 71: 
          {  return token(sym.DB);  }
        case 347: break;
        case 76: 
          {  return token(sym.AS);  }
        case 348: break;
        case 93: 
          {  errors.report(new ErrorMessage(yyline + ":Illegal escape sequence \"" + yytext() + "\""));  }
        case 349: break;
        case 41: 
          {  string.append(yytext());  }
        case 350: break;
        case 54: 
        case 57: 
          {  /* Do Nothing until endif directive found */  }
        case 351: break;
        case 48: 
          {  extra_comment_line = true;  }
        case 352: break;
        case 157: 
          {  yybegin(ENVIRONMENT);  }
        case 353: break;
        case 40: 
          {  yybegin(PREPROCESS);  }
        case 354: break;
        case 92: 
          {  yybegin(COMMENT);  }
        case 355: break;
        default: 
          if (yy_input == YYEOF && yy_startRead == yy_currentPos) {
            yy_atEOF = true;
            yy_do_eof();
              { return new java_cup.runtime.Symbol(sym.EOF); }
          } 
          else {
            yy_ScanError(YY_NO_MATCH);
          }
      }
    }
  }

  /**
   * Converts an int token code into the name of the
   * token by reflection on the cup symbol class/interface sym
   *
   * This code was contributed by Karl Meissner <meissnersd@yahoo.com>
   * <a href="http://meissner.v0.net/msd.htm">meissner.v0.net/msd.htm</a>
   */
  private String getTokenName(int token) {
    try {
      java.lang.reflect.Field [] class_fields = sym.class.getFields();
      for (int i = 0; i < class_fields.length; i++) {
        if (class_fields[i].getInt(null) == token) {
          return class_fields[i].getName();
        }
      }
    } catch (Exception e) {
      e.printStackTrace(System.err);
    }

    return "UNKNOWN TOKEN";
  }

  /**
   * Same as next_token but also prints the token to standard out
   * for debugging.
   *
   * This code was contributed by Karl Meissner <meissnersd@yahoo.com>
   * <a href="http://meissner.v0.net/msd.htm">meissner.v0.net/msd.htm</a>
   */
  public java_cup.runtime.Symbol debug_next_token() throws java.io.IOException {
    java_cup.runtime.Symbol s = next_token();
    System.out.println( "line:" + (yyline+1) + " col:" + (yycolumn+1) + " --"+ yytext() + "--" + getTokenName(s.sym) + "--");
    return s;
  }

  /**
   * Runs the scanner on input files.
   *
   * This main method is the debugging routine for the scanner.
   * It prints debugging information about each returned token to
   * System.out until the end of file is reached, or an error occured.
   *
   * @param argv   the command line, contains the filenames to run
   *               the scanner on.
   */
  public static void main(String argv[]) {
    if (argv.length == 0) {
      System.out.println("Usage : java Lexer <inputfile>");
    }
    else {
      for (int i = 0; i < argv.length; i++) {
        Lexer scanner = null;
        try {
          scanner = new Lexer( new java.io.FileReader(argv[i]) );
          while ( !scanner.yy_atEOF ) scanner.debug_next_token();
        }
        catch (java.io.FileNotFoundException e) {
          System.out.println("File not found : \""+argv[i]+"\"");
        }
        catch (java.io.IOException e) {
          System.out.println("IO error scanning file \""+argv[i]+"\"");
          System.out.println(e);
        }
        catch (Exception e) {
          System.out.println("Unexpected exception:");
          e.printStackTrace();
        }
      }
    }
  }


}
