/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.FunctionDataWindowPanel;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.PreferencesWindow;
import edu.uoregon.tau.paraprof.enums.SortType;
import edu.uoregon.tau.paraprof.enums.ValueType;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import edu.uoregon.tau.paraprof.interfaces.UnitListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class FunctionDataWindow
extends JFrame
implements ActionListener,
MenuListener,
Observer,
ChangeListener,
ParaProfWindow,
UnitListener {
    private ParaProfTrial ppTrial = null;
    private DataSorter dataSorter = null;
    private Function function = null;
    private JMenu optionsMenu = null;
    private JMenu unitsSubMenu = null;
    private JCheckBoxMenuItem sortByNCTCheckbox = null;
    private JCheckBoxMenuItem descendingOrderCheckBox = null;
    private JCheckBoxMenuItem showValuesAsPercent = null;
    private JCheckBoxMenuItem showPathTitleInReverse = null;
    private JCheckBoxMenuItem showMetaData = null;
    private JLabel barLengthLabel = new JLabel("Bar Width");
    private JSlider barLengthSlider = new JSlider(0, 2000, 250);
    private FunctionDataWindowPanel panel = null;
    private JScrollPane sp = null;
    private List list = new ArrayList();
    private double maxValue;
    private int units = ParaProf.preferences.getUnits();

    public FunctionDataWindow(ParaProfTrial paraProfTrial, Function function) {
        this.ppTrial = paraProfTrial;
        paraProfTrial.getSystemEvents().addObserver(this);
        this.function = function;
        int n = 650;
        int n2 = 550;
        this.setSize(new Dimension(n, n2));
        this.setTitle("Function Data Window: " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FunctionDataWindow.this.thisWindowClosing(windowEvent);
            }
        });
        this.dataSorter = new DataSorter(paraProfTrial);
        this.dataSorter.setSelectedMetricID(paraProfTrial.getDefaultMetricID());
        this.dataSorter.setValueType(ValueType.EXCLUSIVE_PERCENT);
        if (ParaProf.helpWindow.isVisible()) {
            this.help(false);
        }
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panel = new FunctionDataWindowPanel(paraProfTrial, function, this);
        this.sp = new JScrollPane(this.panel);
        JScrollBar jScrollBar = this.sp.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(35);
        this.setupMenus();
        this.setHeader();
        this.sortLocalData();
        this.barLengthSlider.setPaintTicks(true);
        this.barLengthSlider.setMajorTickSpacing(400);
        this.barLengthSlider.setMinorTickSpacing(50);
        this.barLengthSlider.setPaintLabels(true);
        this.barLengthSlider.setSnapToTicks(false);
        this.barLengthSlider.addChangeListener(this);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        this.addCompItem(this.sp, gridBagConstraints, 0, 0, 1, 1);
        ParaProf.incrementNumWindows();
    }

    private Component createMetricMenu(final ValueType valueType, boolean bl, ButtonGroup buttonGroup) {
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        if (this.ppTrial.getNumberOfMetrics() == 1) {
            jRadioButtonMenuItem = new JRadioButtonMenuItem(valueType.toString(), bl);
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FunctionDataWindow.this.dataSorter.setValueType(valueType);
                    FunctionDataWindow.this.sortLocalData();
                    FunctionDataWindow.this.panel.repaint();
                }
            });
            buttonGroup.add(jRadioButtonMenuItem);
            return jRadioButtonMenuItem;
        }
        JMenu jMenu = new JMenu(valueType.toString() + "...");
        int n = 0;
        while (n < this.ppTrial.getNumberOfMetrics()) {
            jRadioButtonMenuItem = n == this.dataSorter.getSelectedMetricID() && bl ? new JRadioButtonMenuItem(this.ppTrial.getMetric(n).getName(), true) : new JRadioButtonMenuItem(this.ppTrial.getMetric(n).getName());
            final int n2 = n++;
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FunctionDataWindow.this.dataSorter.setSelectedMetricID(n2);
                    FunctionDataWindow.this.dataSorter.setValueType(valueType);
                    FunctionDataWindow.this.sortLocalData();
                    FunctionDataWindow.this.panel.repaint();
                }
            });
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
        }
        return jMenu;
    }

    private void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = null;
        Object var3_3 = null;
        this.optionsMenu = new JMenu("Options");
        JCheckBoxMenuItem jCheckBoxMenuItem = null;
        ButtonGroup buttonGroup = null;
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        jCheckBoxMenuItem = new JCheckBoxMenuItem("Show Width Slider", false);
        jCheckBoxMenuItem.addActionListener(this);
        this.optionsMenu.add(jCheckBoxMenuItem);
        this.showMetaData = new JCheckBoxMenuItem("Show Meta Data in Panel", true);
        this.showMetaData.addActionListener(this);
        this.optionsMenu.add(this.showMetaData);
        this.optionsMenu.add(new JSeparator());
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionDataWindow.this.sortLocalData();
                FunctionDataWindow.this.panel.repaint();
            }
        };
        this.sortByNCTCheckbox = new JCheckBoxMenuItem("Sort By N,C,T", true);
        this.sortByNCTCheckbox.addActionListener(actionListener);
        this.optionsMenu.add(this.sortByNCTCheckbox);
        this.descendingOrderCheckBox = new JCheckBoxMenuItem("Descending Order", false);
        this.descendingOrderCheckBox.addActionListener(actionListener);
        this.optionsMenu.add(this.descendingOrderCheckBox);
        this.showValuesAsPercent = new JCheckBoxMenuItem("Show Values as Percent", ParaProf.preferences.getShowValuesAsPercent());
        this.showValuesAsPercent.addActionListener(actionListener);
        this.optionsMenu.add(this.showValuesAsPercent);
        this.unitsSubMenu = ParaProfUtils.createUnitsMenu(this, this.units, true);
        this.optionsMenu.add(this.unitsSubMenu);
        jMenu = new JMenu("Select Metric...");
        buttonGroup = new ButtonGroup();
        jMenu.add(this.createMetricMenu(ValueType.EXCLUSIVE, this.dataSorter.getValueType() == ValueType.EXCLUSIVE || this.dataSorter.getValueType() == ValueType.EXCLUSIVE_PERCENT, buttonGroup));
        jMenu.add(this.createMetricMenu(ValueType.INCLUSIVE, this.dataSorter.getValueType() == ValueType.INCLUSIVE || this.dataSorter.getValueType() == ValueType.INCLUSIVE_PERCENT, buttonGroup));
        jMenu.add(this.createMetricMenu(ValueType.INCLUSIVE_PER_CALL, this.dataSorter.getValueType() == ValueType.INCLUSIVE_PER_CALL, buttonGroup));
        jMenu.add(this.createMetricMenu(ValueType.EXCLUSIVE_PER_CALL, this.dataSorter.getValueType() == ValueType.EXCLUSIVE_PER_CALL, buttonGroup));
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Calls", this.dataSorter.getValueType() == ValueType.NUMCALLS);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionDataWindow.this.dataSorter.setValueType(ValueType.NUMCALLS);
                FunctionDataWindow.this.sortLocalData();
                FunctionDataWindow.this.panel.repaint();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Child Calls", this.dataSorter.getValueType() == ValueType.NUMSUBR);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionDataWindow.this.dataSorter.setValueType(ValueType.NUMSUBR);
                FunctionDataWindow.this.sortLocalData();
                FunctionDataWindow.this.panel.repaint();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        this.optionsMenu.add(jMenu);
        this.optionsMenu.addMenuListener(this);
        jMenuBar.add(ParaProfUtils.createFileMenu(this, this.panel, this.panel));
        jMenuBar.add(this.optionsMenu);
        jMenuBar.add(ParaProfUtils.createWindowsMenu(this.ppTrial, this));
        jMenuBar.add(ParaProfUtils.createHelpMenu(this, this));
        this.setJMenuBar(jMenuBar);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block6: {
            try {
                Object object = actionEvent.getSource();
                if (!(object instanceof JMenuItem)) break block6;
                String string = actionEvent.getActionCommand();
                if (string.equals("Show Width Slider")) {
                    if (((JCheckBoxMenuItem)object).isSelected()) {
                        this.showWidthSlider(true);
                    } else {
                        this.showWidthSlider(false);
                    }
                    break block6;
                }
                if (string.equals("Show Meta Data in Panel")) {
                    this.setHeader();
                    break block6;
                }
                throw new ParaProfException("Menu system not implemented properly: " + string);
            }
            catch (Exception exception) {
                ParaProfUtils.handleException(exception);
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        try {
            this.panel.setBarLength(this.barLengthSlider.getValue());
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void menuSelected(MenuEvent menuEvent) {
        try {
            if (this.dataSorter.getValueType() == ValueType.EXCLUSIVE || this.dataSorter.getValueType() == ValueType.INCLUSIVE || this.dataSorter.getValueType() == ValueType.EXCLUSIVE_PERCENT || this.dataSorter.getValueType() == ValueType.INCLUSIVE_PERCENT) {
                this.showValuesAsPercent.setEnabled(true);
                if (this.showValuesAsPercent.isSelected()) {
                    this.unitsSubMenu.setEnabled(false);
                } else {
                    String string = this.ppTrial.getMetricName(this.dataSorter.getSelectedMetricID());
                    string = string.toUpperCase();
                    if (this.dataSorter.isTimeMetric()) {
                        this.unitsSubMenu.setEnabled(true);
                    } else {
                        this.unitsSubMenu.setEnabled(false);
                    }
                }
            } else {
                this.showValuesAsPercent.setEnabled(false);
                if (this.dataSorter.getValueType() == ValueType.EXCLUSIVE_PER_CALL || this.dataSorter.getValueType() == ValueType.INCLUSIVE_PER_CALL) {
                    if (this.dataSorter.isTimeMetric()) {
                        this.unitsSubMenu.setEnabled(true);
                    } else {
                        this.unitsSubMenu.setEnabled(false);
                    }
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("prefEvent")) {
            this.setHeader();
            this.panel.repaint();
        } else if (string.equals("colorEvent")) {
            this.panel.repaint();
        } else if (string.equals("dataEvent")) {
            this.dataSorter.setSelectedMetricID(this.ppTrial.getDefaultMetricID());
            this.setupMenus();
            this.validate();
            this.sortLocalData();
            this.setHeader();
            this.panel.repaint();
        } else if (string.equals("subWindowCloseEvent")) {
            this.closeThisWindow();
        }
    }

    public void help(boolean bl) {
        ParaProf.helpWindow.clearText();
        if (bl) {
            ParaProf.helpWindow.show();
        }
        ParaProf.helpWindow.writeText("This is the function data window for:");
        ParaProf.helpWindow.writeText(ParaProfUtils.getFunctionName(this.function));
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("This window shows you this function's statistics across all the threads.");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("Right click anywhere within this window to bring up a popup");
        ParaProf.helpWindow.writeText("menu. In this menu you can change or reset the default color");
        ParaProf.helpWindow.writeText("for this function.");
    }

    public DataSorter getDataSorter() {
        return this.dataSorter;
    }

    public void sortLocalData() {
        if (this.sortByNCTCheckbox.isSelected()) {
            this.dataSorter.setSortType(SortType.NCT);
        } else {
            this.dataSorter.setSortType(SortType.VALUE);
        }
        this.dataSorter.setDescendingOrder(this.descendingOrderCheckBox.isSelected());
        if (this.showValuesAsPercent.isSelected()) {
            if (this.dataSorter.getValueType() == ValueType.EXCLUSIVE) {
                this.dataSorter.setValueType(ValueType.EXCLUSIVE_PERCENT);
            } else if (this.dataSorter.getValueType() == ValueType.INCLUSIVE) {
                this.dataSorter.setValueType(ValueType.INCLUSIVE_PERCENT);
            }
        } else if (this.dataSorter.getValueType() == ValueType.EXCLUSIVE_PERCENT) {
            this.dataSorter.setValueType(ValueType.EXCLUSIVE);
        } else if (this.dataSorter.getValueType() == ValueType.INCLUSIVE_PERCENT) {
            this.dataSorter.setValueType(ValueType.INCLUSIVE);
        }
        this.setHeader();
        this.list = this.dataSorter.getFunctionData(this.function, true, true);
        this.maxValue = 0.0;
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)iterator.next();
            double d = pPFunctionProfile.getValue();
            this.maxValue = Math.max(this.maxValue, d);
        }
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public List getData() {
        return this.list;
    }

    public boolean isPercent() {
        return this.showValuesAsPercent.isSelected();
    }

    public int units() {
        if (this.showValuesAsPercent.isEnabled() && this.showValuesAsPercent.isSelected()) {
            return 0;
        }
        if (!this.dataSorter.isTimeMetric()) {
            return 0;
        }
        if (this.dataSorter.getValueType() == ValueType.NUMCALLS || this.dataSorter.getValueType() == ValueType.NUMSUBR) {
            return 0;
        }
        return this.units;
    }

    public Dimension getViewportSize() {
        return this.sp.getViewport().getExtentSize();
    }

    public Rectangle getViewRect() {
        return this.sp.getViewport().getViewRect();
    }

    public void setVerticalScrollBarPosition(int n) {
        JScrollBar jScrollBar = this.sp.getVerticalScrollBar();
        jScrollBar.setValue(n);
    }

    public void setHeader() {
        if (this.showMetaData.isSelected()) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setEditable(false);
            PreferencesWindow preferencesWindow = this.ppTrial.getPreferencesWindow();
            jTextArea.setFont(new Font(preferencesWindow.getParaProfFont(), preferencesWindow.getFontStyle(), preferencesWindow.getFontSize()));
            jTextArea.append(this.getHeaderString());
            this.sp.setColumnHeaderView(jTextArea);
        } else {
            this.sp.setColumnHeaderView(null);
        }
    }

    public String getHeaderString() {
        if (this.dataSorter.getValueType() == ValueType.NUMCALLS || this.dataSorter.getValueType() == ValueType.NUMSUBR || this.showValuesAsPercent.isSelected()) {
            return "Metric Name: " + this.ppTrial.getMetricName(this.dataSorter.getSelectedMetricID()) + "\n" + "Name: " + ParaProfUtils.getFunctionName(this.function) + "\n" + "Value Type: " + this.dataSorter.getValueType() + "\n";
        }
        return "Metric Name: " + this.ppTrial.getMetricName(this.dataSorter.getSelectedMetricID()) + "\n" + "Name: " + ParaProfUtils.getFunctionName(this.function) + "\n" + "Value Type: " + this.dataSorter.getValueType() + "\n" + "Units: " + UtilFncs.getUnitsString((int)this.units, (boolean)this.dataSorter.isTimeMetric(), (boolean)this.dataSorter.isDerivedMetric()) + "\n";
    }

    private void showWidthSlider(boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (bl) {
            this.getContentPane().remove(this.sp);
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.weightx = 0.1;
            gridBagConstraints.weighty = 0.01;
            this.addCompItem(this.barLengthLabel, gridBagConstraints, 0, 0, 1, 1);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.7;
            gridBagConstraints.weighty = 0.01;
            this.addCompItem(this.barLengthSlider, gridBagConstraints, 1, 0, 1, 1);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.99;
            this.addCompItem(this.sp, gridBagConstraints, 0, 1, 2, 1);
        } else {
            this.getContentPane().remove(this.barLengthLabel);
            this.getContentPane().remove(this.barLengthSlider);
            this.getContentPane().remove(this.sp);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.weighty = 100.0;
            this.addCompItem(this.sp, gridBagConstraints, 0, 0, 1, 1);
        }
        this.validate();
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    public void closeThisWindow() {
        try {
            this.setVisible(false);
            this.ppTrial.getSystemEvents().deleteObserver(this);
            ParaProf.decrementNumWindows();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dispose();
    }

    public void setUnits(int n) {
        this.units = n;
        this.setHeader();
        this.panel.repaint();
    }
}

