/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.UserEvent;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.PPUserEventProfile;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfErrorDialog;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.UserEventWindow;
import edu.uoregon.tau.paraprof.interfaces.ImageExport;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class UserEventWindowPanel
extends JPanel
implements ActionListener,
MouseListener,
Printable,
ImageExport {
    private String counterName = null;
    private UserEvent userEvent = null;
    private int barHeight = -1;
    private int barSpacing = -1;
    private int baseBarLength = 250;
    private int barLength = 0;
    private int textOffset = 60;
    private int maxXLength = 0;
    private boolean groupMember = false;
    private ParaProfTrial ppTrial = null;
    private UserEventWindow window = null;
    private List list = new ArrayList();
    private int xPanelSize = 0;
    private int yPanelSize = 0;
    private JPopupMenu popup = new JPopupMenu();
    private int lastHeaderEndPosition = 0;

    public UserEventWindowPanel(ParaProfTrial paraProfTrial, UserEvent userEvent, UserEventWindow userEventWindow) {
        this.ppTrial = paraProfTrial;
        this.window = userEventWindow;
        this.userEvent = userEvent;
        this.barLength = this.baseBarLength;
        this.setBackground(Color.white);
        this.addMouseListener(this);
        JMenuItem jMenuItem = new JMenuItem("Change User Event Color");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        jMenuItem = new JMenuItem("Reset to Generic Color");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            this.export((Graphics2D)graphics, true, false, false);
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
            this.window.closeThisWindow();
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        try {
            if (n >= 1) {
                return 1;
            }
            ParaProfUtils.scaleForPrint(graphics, pageFormat, this.xPanelSize, this.yPanelSize);
            this.export((Graphics2D)graphics, false, true, false);
            return 0;
        }
        catch (Exception exception) {
            new ParaProfErrorDialog(exception);
            return 1;
        }
    }

    public void export(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        this.list = this.window.getData();
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        int n2 = 0;
        int n3 = this.barLength + this.textOffset;
        PPUserEventProfile pPUserEventProfile = null;
        this.ppTrial.getPreferencesWindow().setBarDetails(graphics2D);
        this.barSpacing = this.ppTrial.getPreferencesWindow().getBarSpacing();
        this.barHeight = this.ppTrial.getPreferencesWindow().getBarHeight();
        Font font = new Font(this.ppTrial.getPreferencesWindow().getParaProfFont(), this.ppTrial.getPreferencesWindow().getFontStyle(), this.barHeight);
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        d2 = this.window.getValueType().getMaxValue(this.userEvent);
        n = fontMetrics.stringWidth(UtilFncs.getOutputString((int)0, (double)d2, (int)ParaProf.defaultNumberPrecision));
        if (this.resizePanel(fontMetrics, n3 += n) && bl) {
            this.revalidate();
            return;
        }
        int[] nArray = ParaProfUtils.computeClipping(graphics2D.getClipBounds(), this.window.getViewRect(), bl, bl2, this.list.size(), this.barSpacing, n2);
        int n4 = nArray[0];
        int n5 = nArray[1];
        n2 = nArray[2];
        if (bl3) {
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            Insets insets = this.getInsets();
            n2 += this.barSpacing;
            String string = this.window.getHeaderString();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "'\n'");
            while (stringTokenizer.hasMoreTokens()) {
                AttributedString attributedString = new AttributedString(stringTokenizer.nextToken());
                attributedString.addAttribute(TextAttribute.FONT, font);
                AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
                LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
                float f = this.getSize().width - insets.left - insets.right;
                float f2 = insets.left;
                float f3 = insets.right;
                while (lineBreakMeasurer.getPosition() < attributedCharacterIterator.getEndIndex()) {
                    TextLayout textLayout = lineBreakMeasurer.nextLayout(f);
                    textLayout.draw(graphics2D, f2, n2 += this.barSpacing);
                    f2 = insets.left;
                }
            }
            this.lastHeaderEndPosition = n2;
        }
        int n6 = n4;
        while (n6 <= n5) {
            pPUserEventProfile = (PPUserEventProfile)this.list.get(n6);
            d = this.window.getValueType().getValue(pPUserEventProfile.getUserEventProfile());
            this.drawBar(graphics2D, fontMetrics, d, d2, "n,c,t " + pPUserEventProfile.getNodeID() + "," + pPUserEventProfile.getContextID() + "," + pPUserEventProfile.getThreadID(), n3, n2 += this.barSpacing, this.barHeight, this.groupMember);
            ++n6;
        }
    }

    private void drawBar(Graphics2D graphics2D, FontMetrics fontMetrics, double d, double d2, String string, int n, int n2, int n3, boolean bl) {
        int n4 = 0;
        double d3 = 0.0;
        String string2 = null;
        int n5 = 0;
        int n6 = 0;
        d3 = d / d2;
        n4 = (int)(d3 * (double)this.barLength);
        if (n4 == 0) {
            n4 = 1;
        }
        if (n4 > 2 && n3 > 2) {
            graphics2D.setColor(this.userEvent.getColor());
            graphics2D.fillRect(n - n4 + 1, n2 - n3 + 1, n4 - 1, n3 - 1);
            if (this.userEvent == this.ppTrial.getHighlightedUserEvent()) {
                graphics2D.setColor(this.ppTrial.getColorChooser().getUserEventHighlightColor());
                graphics2D.drawRect(n - n4, n2 - n3, n4, n3);
                graphics2D.drawRect(n - n4 + 1, n2 - n3 + 1, n4 - 2, n3 - 2);
            } else {
                graphics2D.setColor(Color.black);
                graphics2D.drawRect(n - n4, n2 - n3, n4, n3);
            }
        } else {
            if (this.userEvent == this.ppTrial.getHighlightedUserEvent()) {
                graphics2D.setColor(this.ppTrial.getColorChooser().getUserEventHighlightColor());
            } else {
                graphics2D.setColor(this.userEvent.getColor());
            }
            graphics2D.fillRect(n - n4, n2 - n3, n4, n3);
        }
        graphics2D.setColor(Color.black);
        string2 = UtilFncs.getOutputString((int)0, (double)d, (int)ParaProf.defaultNumberPrecision);
        n5 = fontMetrics.stringWidth(string2);
        n6 = n - n4 - n5 - 5;
        graphics2D.drawString(string2, n6, n2);
        graphics2D.drawString(string, n + 5, n2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Change User Event Color")) {
                    Color color = this.userEvent.getColor();
                    if ((color = JColorChooser.showDialog(this, "Please select a new color", color)) != null) {
                        this.userEvent.setSpecificColor(color);
                        this.userEvent.setColorFlag(true);
                        this.ppTrial.getSystemEvents().updateRegisteredObjects("colorEvent");
                    }
                } else if (string.equals("Reset to Generic Color")) {
                    this.userEvent.setColorFlag(false);
                    this.ppTrial.getSystemEvents().updateRegisteredObjects("colorEvent");
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            if (ParaProfUtils.rightClick(mouseEvent)) {
                this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        Dimension dimension = null;
        dimension = bl ? this.getSize() : this.window.getSize();
        dimension.setSize(dimension.getWidth(), dimension.getHeight() + (double)this.lastHeaderEndPosition);
        return dimension;
    }

    private boolean resizePanel(FontMetrics fontMetrics, int n) {
        boolean bl = false;
        int n2 = (this.window.getData().size() + 2) * this.barSpacing + 10;
        int[] nArray = this.ppTrial.getMaxNCTNumbers();
        String string = "n,c,t " + nArray[0] + "," + nArray[1] + "," + nArray[2];
        int n3 = n + 5 + fontMetrics.stringWidth(string) + 25;
        if (n2 != this.yPanelSize || n3 != this.xPanelSize) {
            this.yPanelSize = n2;
            this.xPanelSize = n3;
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            bl = false;
        }
        return bl;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize, this.yPanelSize);
    }

    public void setBarLength(int n) {
        this.barLength = Math.max(1, n);
        this.repaint();
    }
}

