/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.UtilFncs;
import java.util.Collections;
import java.util.Vector;

public class Context
implements Comparable {
    int nodeID = -1;
    int contextID = -1;
    Vector threads;

    public Context() {
        this.threads = new Vector();
    }

    public Context(int n, int n2) {
        this.nodeID = n;
        this.contextID = n2;
        this.threads = new Vector();
    }

    public void setThreadId(int n) {
        this.nodeID = n;
    }

    public int getThreadID() {
        return this.nodeID;
    }

    public void setContextID(int n) {
        this.contextID = n;
    }

    public int getContextID() {
        return this.contextID;
    }

    public void addThread(Thread thread) {
        try {
            if (thread.getThreadID() < 0) {
                System.out.println("Error - Invalid thread id (id less than zero). Thread not added!");
                return;
            }
            int n = this.getThreadPosition(thread);
            if (n >= 0) {
                System.out.println("Error - Thread already present. Thread not added!");
            } else {
                this.threads.insertElementAt(thread, -(n + 1));
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError(exception, null, "N1");
        }
    }

    public Thread addThread(int n) {
        Thread thread = null;
        try {
            if (n < 0) {
                System.out.println("Error - Invalid thread id (id less than zero). Thread not added!");
                return null;
            }
            int n2 = this.getThreadPosition(new Integer(n));
            if (n2 >= 0) {
                System.out.println("Error - Thread already present. Thread not added!");
            } else {
                thread = new Thread(this.nodeID, this.contextID, n);
                this.threads.insertElementAt(thread, -(n2 + 1));
            }
            return thread;
        }
        catch (Exception exception) {
            UtilFncs.systemError(exception, null, "N2");
            return thread;
        }
    }

    public Thread addThread(int n, int n2) {
        Thread thread = null;
        try {
            if (n < 0) {
                System.out.println("Error - Invalid thread id (id less than zero). Thread not added!");
                return null;
            }
            int n3 = this.getThreadPosition(new Integer(n));
            if (n3 >= 0) {
                System.out.println("Error - Thread already present. Thread not added!");
            } else {
                thread = new Thread(this.nodeID, this.contextID, n, n2);
                this.threads.insertElementAt(thread, -(n3 + 1));
            }
            return thread;
        }
        catch (Exception exception) {
            UtilFncs.systemError(exception, null, "N2");
            return thread;
        }
    }

    public Vector getThreads() {
        return this.threads;
    }

    public Thread getThread(int n) {
        Thread thread = null;
        try {
            int n2 = this.getThreadPosition(new Integer(n));
            if (n2 >= 0) {
                thread = (Thread)this.threads.elementAt(n2);
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError(exception, null, "N3");
        }
        return thread;
    }

    public int getNumberOfThreads() {
        return this.threads.size();
    }

    private int getThreadPosition(Integer n) {
        return Collections.binarySearch(this.threads, n);
    }

    private int getThreadPosition(Thread thread) {
        return Collections.binarySearch(this.threads, thread);
    }

    public int compareTo(Object object) {
        if (object instanceof Integer) {
            return this.contextID - (Integer)object;
        }
        return this.contextID - ((Context)object).getContextID();
    }
}

