/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.loader;

import edu.uoregon.tau.dms.dss.Application;
import edu.uoregon.tau.dms.dss.DynaprofOutputSession;
import edu.uoregon.tau.dms.dss.Experiment;
import edu.uoregon.tau.dms.dss.GprofOutputSession;
import edu.uoregon.tau.dms.dss.HPMToolkitDataSession;
import edu.uoregon.tau.dms.dss.MpiPOutputSession;
import edu.uoregon.tau.dms.dss.PSRunDataSession;
import edu.uoregon.tau.dms.dss.ParaProfDataSession;
import edu.uoregon.tau.dms.dss.PerfDMFSession;
import edu.uoregon.tau.dms.dss.TauOutputSession;
import edu.uoregon.tau.dms.dss.TauPprofOutputSession;
import edu.uoregon.tau.dms.dss.Trial;
import edu.uoregon.tau.dms.dss.XMLSupport;
import edu.uoregon.tau.dms.loader.FileFilter;
import jargs.gnu.CmdLineParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;

public class LoadTrial {
    private File writeXml;
    private String trialTime;
    private String[] sourceFiles;
    private Application app;
    private Experiment exp;
    private boolean fixNames = false;
    private int expID = 0;
    public int trialID = 0;
    private int fileType = 0;
    private ParaProfDataSession dataSession = null;
    public String trialName = new String();
    public String problemFile = new String();
    PerfDMFSession dbSession = null;
    Trial trial = null;

    public static void usage() {
        System.err.println("Usage: perfdmf_loadtrial -e <experiment id> -n <name> [options] <files>\n\ntry `perfdmf_loadtrial --help' for more information");
    }

    public static void outputHelp() {
        System.err.println("Usage: perfdmf_loadtrial -e <experiment id> -n <name> [options] <files>\n\nRequired Arguments:\n\n  -e, --experimentid <number>    Specify associated experiment ID for this trial\n  -n, --name <text>              Specify the name of the trial\n\nOptional Arguments:\n\n  -f, --filetype <filetype>      Specify type of performance data, options are:\n                                   profiles (default), pprof, dynaprof, mpip,\n                                   gprof, psrun, hpm\n  -t, --trialid <number>         Specify trial ID\n  -i, --fixnames                 Use the fixnames option for gprof\n\nNotes:\n  For the TAU profiles type, you can specify either a specific set of profile\nfiles on the commandline, or you can specify a directory (by default the current\ndirectory).  The specified directory will be searched for profile.*.*.* files,\nor, in the case of multiple counters, directories named MULTI_* containing\nprofile data.\n\nExamples:\n\n  perfdmf_loadtrial -e 12 -n \"Batch 001\"\n    This will load profile.* (or multiple counters directories MULTI_*) into\n    experiment 12 and give the trial the name \"Batch 001\"\n\n  perfdmf_loadtrial -e 12 -n \"HPM data 01\" perfhpm*\n    This will load perfhpm* files of type HPMToolkit into experiment 12 and give\n    the trial the name \"HPM data 01\"\n");
    }

    public LoadTrial(String string, String[] stringArray) {
        this.sourceFiles = stringArray;
        this.dbSession = new PerfDMFSession();
        this.dbSession.initialize(string);
    }

    public boolean checkForExp(String string) {
        this.expID = Integer.parseInt(string);
        this.exp = this.dbSession.setExperiment(this.expID);
        if (this.exp == null) {
            System.err.println("Experiment id " + string + " not found,  please enter a valid experiment ID.");
            System.exit(-1);
            return false;
        }
        return true;
    }

    public boolean checkForTrial(String string) {
        Trial trial = this.dbSession.setTrial(Integer.parseInt(string));
        return trial != null;
    }

    public void loadTrial(int n) {
        this.trial = null;
        this.fileType = n;
        Vector<File[]> vector = null;
        File[] fileArray = new File[1];
        switch (n) {
            case 0: {
                if (this.sourceFiles.length != 1) {
                    System.err.println("pprof type: you must specify exactly one file");
                    System.exit(-1);
                }
                if (this.isDirectory(this.sourceFiles[0])) {
                    System.err.println("pprof type: you must specify a file, not a directory");
                    System.exit(-1);
                }
                fileArray[0] = new File(this.sourceFiles[0]);
                vector = new Vector<File[]>();
                vector.add(fileArray);
                this.dataSession = new TauPprofOutputSession();
                break;
            }
            case 1: {
                if (this.sourceFiles.length < 1) {
                    vector = this.helperFindFiles(System.getProperty("user.dir"), "\\Aprofile\\..*\\..*\\..*\\z");
                } else if (this.isDirectory(this.sourceFiles[0])) {
                    if (this.sourceFiles.length > 1) {
                        System.err.println("profiles type: you can only specify one directory");
                        System.exit(-1);
                    }
                    vector = this.helperFindFiles(this.sourceFiles[0], "\\Aprofile\\..*\\..*\\..*\\z");
                } else {
                    vector = new Vector();
                    File[] fileArray2 = new File[this.sourceFiles.length];
                    for (int i = 0; i < this.sourceFiles.length; ++i) {
                        fileArray2[i] = new File(this.sourceFiles[i]);
                    }
                    vector.add(fileArray2);
                }
                this.dataSession = new TauOutputSession();
                break;
            }
            case 2: {
                fileArray[0] = new File(this.sourceFiles[0]);
                vector = new Vector<File[]>();
                vector.add(fileArray);
                this.dataSession = new DynaprofOutputSession();
                break;
            }
            case 3: {
                if (this.sourceFiles.length != 1) {
                    System.err.println("MpiP type: you must specify exactly one file");
                    System.exit(-1);
                }
                if (this.isDirectory(this.sourceFiles[0])) {
                    System.err.println("MpiP type: you must specify a file, not a directory");
                    System.exit(-1);
                }
                fileArray[0] = new File(this.sourceFiles[0]);
                vector = new Vector();
                vector.add(fileArray);
                this.dataSession = new MpiPOutputSession();
                break;
            }
            case 4: {
                vector = new Vector<File[]>();
                File[] fileArray3 = new File[this.sourceFiles.length];
                for (int i = 0; i < this.sourceFiles.length; ++i) {
                    fileArray3[i] = new File(this.sourceFiles[i]);
                }
                vector.add(fileArray3);
                this.dataSession = new HPMToolkitDataSession();
                break;
            }
            case 5: {
                vector = new Vector();
                File[] fileArray4 = new File[this.sourceFiles.length];
                for (int i = 0; i < this.sourceFiles.length; ++i) {
                    fileArray4[i] = new File(this.sourceFiles[i]);
                }
                vector.add(fileArray4);
                this.dataSession = new GprofOutputSession(this.fixNames);
                break;
            }
            case 6: {
                vector = new Vector();
                File[] fileArray5 = new File[this.sourceFiles.length];
                for (int i = 0; i < this.sourceFiles.length; ++i) {
                    fileArray5[i] = new File(this.sourceFiles[i]);
                }
                vector.add(fileArray5);
                this.dataSession = new PSRunDataSession();
                break;
            }
        }
        this.trial = new Trial(0);
        this.trial.setDataSession(this.dataSession);
        this.dataSession.initialize(vector);
        if (this.trialID == 0) {
            this.saveTrial();
        } else {
            this.appendToTrial();
        }
    }

    public void writeTrial() {
        XMLSupport xMLSupport = new XMLSupport(this.trial);
        xMLSupport.writeXmlFiles(0, this.writeXml);
    }

    public void saveTrial() {
        this.trial.setName(this.trialName);
        System.out.println("TrialName: " + this.trialName);
        this.trial.setExperimentID(this.expID);
        this.dbSession.saveParaProfTrial(this.trial, -1);
        System.out.println("Done saving trial!");
    }

    public void appendToTrial() {
        this.trial.setID(this.trialID);
        this.dbSession.saveParaProfTrial(this.trial, 0);
        System.out.println("Done adding metric to trial!");
    }

    public String getProblemString() {
        if (this.problemFile == null) {
            return new String("");
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(this.problemFile));
        }
        catch (Exception exception) {
            System.out.println("Problem file not found!  Exiting...");
            System.exit(0);
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            String string;
            try {
                string = bufferedReader.readLine();
            }
            catch (Exception exception) {
                string = null;
            }
            if (string == null) break;
            stringBuffer.append(string.replaceAll("'", "'"));
        }
        try {
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    private boolean isDirectory(String string) {
        File file = new File(string);
        return file.isDirectory();
    }

    private boolean fileExists() {
        boolean bl = false;
        try {
            BufferedReader bufferedReader;
            InputStreamReader inputStreamReader;
            FileInputStream fileInputStream = new FileInputStream(this.sourceFiles[0]);
            if (fileInputStream != null && (inputStreamReader = new InputStreamReader(fileInputStream)) != null && (bufferedReader = new BufferedReader(inputStreamReader)) != null) {
                bl = true;
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    private String[] extractSourcePath() {
        File file = new File(this.sourceFiles[0]);
        String[] stringArray = new String[2];
        stringArray[0] = new String(file.getParent());
        if (stringArray[0] != null) {
            stringArray[1] = new String(file.getName());
        }
        return stringArray;
    }

    public static void main(String[] stringArray) {
        CmdLineParser cmdLineParser = new CmdLineParser();
        CmdLineParser.Option option = cmdLineParser.addBooleanOption('h', "help");
        CmdLineParser.Option option2 = cmdLineParser.addStringOption('g', "configfile");
        CmdLineParser.Option option3 = cmdLineParser.addStringOption('e', "experimentid");
        CmdLineParser.Option option4 = cmdLineParser.addStringOption('n', "name");
        CmdLineParser.Option option5 = cmdLineParser.addStringOption('t', "trialid");
        CmdLineParser.Option option6 = cmdLineParser.addStringOption('f', "filetype");
        CmdLineParser.Option option7 = cmdLineParser.addBooleanOption('i', "fixnames");
        try {
            cmdLineParser.parse(stringArray);
        }
        catch (CmdLineParser.OptionException optionException) {
            System.err.println(optionException.getMessage());
            LoadTrial.usage();
            System.exit(-1);
        }
        Boolean bl = (Boolean)cmdLineParser.getOptionValue(option);
        String string = (String)cmdLineParser.getOptionValue(option2);
        String string2 = (String)cmdLineParser.getOptionValue(option3);
        String string3 = (String)cmdLineParser.getOptionValue(option4);
        String string4 = (String)cmdLineParser.getOptionValue(option5);
        String string5 = (String)cmdLineParser.getOptionValue(option6);
        Boolean bl2 = (Boolean)cmdLineParser.getOptionValue(option7);
        if (bl != null && bl.booleanValue()) {
            LoadTrial.outputHelp();
            System.exit(-1);
        }
        if (string == null) {
            System.err.println("Error: Missing config file (perfdmf_loadtrial should supply it)\n");
            LoadTrial.usage();
            System.exit(-1);
        } else if (string3 == null) {
            System.err.println("Error: Missing trial name\n");
            LoadTrial.usage();
            System.exit(-1);
        } else if (string2 == null) {
            System.err.println("Error: Missing experiment id\n");
            LoadTrial.usage();
            System.exit(-1);
        }
        String[] stringArray2 = cmdLineParser.getRemainingArgs();
        int n = 1;
        Object var18_19 = null;
        if (string5 != null) {
            if (string5.equals("pprof")) {
                n = 0;
            } else if (string5.equals("profiles")) {
                n = 1;
            } else if (string5.equals("dynaprof")) {
                n = 2;
            } else if (string5.equals("mpip")) {
                n = 3;
            } else if (string5.equals("hpm")) {
                n = 4;
            } else if (string5.equals("gprof")) {
                n = 5;
            } else if (string5.equals("psrun")) {
                n = 6;
            } else {
                System.err.println("Error: unknown type '" + string5 + "'\n");
                LoadTrial.usage();
                System.exit(-1);
            }
        }
        if (string3 == null) {
            string3 = new String("");
        }
        if (bl2 == null) {
            bl2 = new Boolean(false);
        }
        LoadTrial loadTrial = new LoadTrial(string, stringArray2);
        loadTrial.checkForExp(string2);
        if (string4 != null) {
            loadTrial.checkForTrial(string4);
            loadTrial.trialID = Integer.parseInt(string4);
        }
        loadTrial.trialName = string3;
        loadTrial.fixNames = bl2;
        loadTrial.loadTrial(n);
    }

    private Vector helperFindFiles(String string, String string2) {
        Vector<File[]> vector = new Vector<File[]>();
        File file = new File(string);
        if (!file.isDirectory()) {
            return vector;
        }
        FileFilter fileFilter = new FileFilter(string2);
        File[] fileArray = file.listFiles(fileFilter);
        if (fileArray.length == 0) {
            FileFilter fileFilter2 = new FileFilter("MULTI__.*");
            File[] fileArray2 = file.listFiles(fileFilter2);
            for (int i = 0; i < fileArray2.length; ++i) {
                File[] fileArray3 = fileArray2[i].listFiles(fileFilter);
                vector.add(fileArray3);
            }
        } else {
            vector.add(fileArray);
            return vector;
        }
        return vector;
    }
}

