/*
 * Decompiled with CFR 0.152.
 */
package jRacy;

import jRacy.DB;
import jRacy.DBAcct;
import jRacy.JDBCAcct;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DBConnector
implements DB {
    private Statement statement;
    private DBAcct acct = null;
    private Connection conn = null;
    public String dbaddress = null;
    public String driverName = "org.postgresql.Driver";

    public DBConnector() throws SQLException {
        this.dbaddress = "jdbc:postgresql://127.0.0.1:5432/perfdb;";
        this.register();
    }

    public DBConnector(DBAcct dBAcct, String string) throws SQLException {
        this.dbaddress = "jdbc:postgresql://" + string + ":5432/perfdb;";
        this.setAcct(dBAcct);
        this.register();
        this.connect();
    }

    public void close() {
        try {
            if (this.conn.isClosed()) {
                return;
            }
            this.conn.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public boolean connect() {
        try {
            if (this.conn != null) {
                return true;
            }
            this.conn = DriverManager.getConnection(this.getConnectString());
            return true;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return false;
        }
    }

    public boolean connect(DBAcct dBAcct) {
        this.setAcct(dBAcct);
        return this.connect();
    }

    public boolean connect(Connection connection) {
        this.conn = connection;
        return true;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        if (this.statement == null) {
            if (this.conn == null) {
                System.err.println("Database is closed for " + string);
                return null;
            }
            this.statement = this.conn.createStatement();
        }
        return this.statement.executeQuery(string.trim());
    }

    public boolean execute(String string) throws SQLException {
        if (this.statement == null) {
            if (this.conn == null) {
                System.err.println("Database is closed for " + string);
                return false;
            }
            this.statement = this.conn.createStatement();
        }
        return this.statement.execute(string.trim());
    }

    public int executeUpdate(String string) throws SQLException {
        try {
            if (this.statement == null) {
                if (this.conn == null) {
                    System.err.println("Database is closed for " + string);
                    return 0;
                }
                this.statement = this.conn.createStatement();
            }
            return this.statement.executeUpdate(string.trim());
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return 0;
        }
    }

    public DBAcct getAcct() {
        return this.acct;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public String getConnectString() {
        return this.getDBAddress() + this.getAcct();
    }

    public String getDBAddress() {
        return this.dbaddress;
    }

    public String getDataItem(String string) {
        try {
            ResultSet resultSet = this.executeQuery(string);
            if (!resultSet.next()) {
                resultSet.close();
                return null;
            }
            String string2 = resultSet.getString(1);
            resultSet.close();
            return string2;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return null;
        }
    }

    public boolean isClosed() {
        if (this.conn == null) {
            return true;
        }
        try {
            return this.conn.isClosed();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return true;
        }
    }

    public void register() {
        try {
            Class.forName(this.driverName);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setAcct(JDBCAcct jDBCAcct) {
        this.acct = jDBCAcct;
    }

    public void setAcct(DBAcct dBAcct) {
        this.acct = dBAcct;
    }

    public void setDBAddress(String string) {
        this.dbaddress = string;
    }
}

