/*
 * Decompiled with CFR 0.152.
 */
package translator;

import jargs.gnu.CmdLineParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import perfdb.ConnectionManager;
import translator.GlobalContext;
import translator.GlobalMapping;
import translator.GlobalMappingElement;
import translator.GlobalNode;
import translator.GlobalThread;
import translator.GlobalThreadDataElement;

public class Translator
implements Serializable {
    private File readPprof;
    private File writeXml;
    private String metricStr;
    private String trialTime;
    private ConnectionManager connector;
    int maxNode;
    int maxContext;
    int maxThread;
    String funAmount;
    int ueAmount = 0;
    private Vector NodeList;
    GlobalMapping globalMapping;
    private String heading;
    private String userEventHeading;
    private boolean isUserEventHeadingSet;

    public Translator(String configFileName, String sourcename, String targetname) {
        this.readPprof = new File(sourcename);
        Date date = new Date(this.readPprof.lastModified());
        this.trialTime = date.toString();
        this.writeXml = new File(targetname);
        if (this.readPprof.exists()) {
            System.out.println("Found " + sourcename + " ... Loading");
        } else {
            System.out.println("Did not find pprof.dat file!");
            System.exit(-1);
        }
        if (!this.writeXml.exists()) {
            try {
                if (this.writeXml.createNewFile()) {
                    System.out.println("Create pprof.xml!");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.globalMapping = new GlobalMapping();
        this.NodeList = new Vector();
        this.heading = null;
        this.userEventHeading = null;
        this.isUserEventHeadingSet = false;
        this.maxNode = 0;
        this.maxContext = 0;
        this.maxThread = 0;
        this.connector = new ConnectionManager(configFileName);
        this.connector.connect();
    }

    public Vector getNodeList() {
        return this.NodeList;
    }

    void initializeGlobalMapping(int inNumberOfFunctions) {
        int i = 0;
        while (i < inNumberOfFunctions) {
            this.globalMapping.addGlobalFunction("Name has not been set!");
            ++i;
        }
    }

    GlobalMapping getGlobalMapping() {
        return this.globalMapping;
    }

    /*
     * WARNING - void declaration
     */
    public void buildPprof() {
        try {
            String inputString;
            BufferedReader preader = new BufferedReader(new FileReader(this.readPprof));
            int functionID = -1;
            int userEventID = -1;
            int node = -1;
            int context = -1;
            int thread = -1;
            double value = -1.0;
            double percentValue = -1.0;
            double calls = -1.0;
            double subrs = -1.0;
            double inclpcall = -1.0;
            GlobalNode currentGlobalNode = null;
            GlobalContext currentGlobalContext = null;
            GlobalThread currentGlobalThread = null;
            Object tmpGlobalThreadDataElement = null;
            int lastNode = -1;
            int lastContext = -1;
            int lastThread = -1;
            int numOfFunctions = 0;
            int counter = 0;
            int i = 0;
            while ((inputString = preader.readLine()) != null) {
                if (i > 0) {
                    void var2_23;
                    if (i == 1) {
                        this.funAmount = this.getFunAmt((String)var2_23);
                    }
                    StringTokenizer genericTokenizer = new StringTokenizer((String)var2_23, " \t\n\r");
                    if (i != 1) {
                        if (i != 2) {
                            String functionGroup;
                            String functionName;
                            if (this.checkForBeginningT((String)var2_23)) {
                                ++counter;
                                if (this.checkForExclusiveWithTOrM((String)var2_23)) {
                                    functionName = this.getFunctionName((String)var2_23);
                                    if (!this.globalMapping.setFunctionNameAt(functionName, functionID = this.getFunctionID((String)var2_23))) {
                                        System.out.println("There was an error adding function to the global mapping");
                                    }
                                    if (this.isAGroupMember((String)var2_23) && !this.globalMapping.setFunctionGroupAt(functionGroup = this.getFunctionGroup((String)var2_23), functionID)) {
                                        System.out.println("There was an error adding function to the global mapping");
                                    }
                                    value = this.getValue((String)var2_23);
                                    percentValue = this.getPercentValue((String)var2_23);
                                    if (!this.globalMapping.setTotalExclusiveValueAt(value, functionID)) {
                                        System.out.println("There was an error setting Exc/Inc total time");
                                    } else {
                                        this.globalMapping.setTotalExclusivePercentValueAt(percentValue, functionID);
                                    }
                                } else if (this.checkForInclusiveWithTOrM((String)var2_23)) {
                                    functionID = this.getFunctionID((String)var2_23);
                                    value = this.getValue((String)var2_23);
                                    percentValue = this.getPercentValue((String)var2_23);
                                    if (!this.globalMapping.setTotalInclusiveValueAt(value, functionID)) {
                                        System.out.println("There was an error setting Exc/Inc total time");
                                    } else {
                                        this.globalMapping.setTotalInclusivePercentValueAt(percentValue, functionID);
                                        inputString = preader.readLine();
                                        calls = this.getCall(inputString);
                                        subrs = this.getSubrs(inputString);
                                        inclpcall = this.getInclPCall(inputString);
                                        this.globalMapping.getGlobalMappingElement(functionID).setTotalCall(calls);
                                        this.globalMapping.getGlobalMappingElement(functionID).setTotalSubrs(subrs);
                                        this.globalMapping.getGlobalMappingElement(functionID).setTotalInclPCall(inclpcall);
                                    }
                                }
                            } else if (this.checkForBeginningM(inputString)) {
                                GlobalMappingElement tmpGlobalMappingElement;
                                if (this.checkForExclusiveWithTOrM(inputString)) {
                                    functionID = this.getFunctionID(inputString);
                                    value = this.getValue(inputString);
                                    percentValue = this.getPercentValue(inputString);
                                    tmpGlobalMappingElement = this.globalMapping.getGlobalMappingElement(functionID);
                                    tmpGlobalMappingElement.setMeanExclusiveValue(value);
                                    tmpGlobalMappingElement.setMeanExclusivePercentValue(percentValue);
                                } else if (this.checkForInclusiveWithTOrM(inputString)) {
                                    functionID = this.getFunctionID(inputString);
                                    value = this.getValue(inputString);
                                    percentValue = this.getPercentValue(inputString);
                                    tmpGlobalMappingElement = this.globalMapping.getGlobalMappingElement(functionID);
                                    tmpGlobalMappingElement.setMeanInclusiveValue(value);
                                    tmpGlobalMappingElement.setMeanInclusivePercentValue(percentValue);
                                    inputString = preader.readLine();
                                    calls = this.getCall(inputString);
                                    subrs = this.getSubrs(inputString);
                                    inclpcall = this.getInclPCall(inputString);
                                    tmpGlobalMappingElement.setMeanCall(calls);
                                    tmpGlobalMappingElement.setMeanSubrs(subrs);
                                    tmpGlobalMappingElement.setMeanInclPCall(inclpcall);
                                }
                            } else if (this.checkForExclusive(inputString)) {
                                GlobalThreadDataElement tmpGTDE;
                                functionID = this.getFunctionID(inputString);
                                functionName = this.getFunctionName(inputString);
                                functionGroup = this.isAGroupMember(inputString) ? this.getFunctionGroup(inputString) : null;
                                value = this.getValue(inputString);
                                percentValue = this.getPercentValue(inputString);
                                node = this.getNode(inputString, false);
                                context = this.getContext(inputString, false);
                                thread = this.getThread(inputString, false);
                                if (this.maxNode < node) {
                                    this.maxNode = node;
                                }
                                if (this.maxContext < context) {
                                    this.maxContext = context;
                                }
                                if (this.maxThread < thread) {
                                    this.maxThread = thread;
                                }
                                if (lastNode != node) {
                                    lastContext = -1;
                                    lastThread = -1;
                                }
                                if (lastContext != context) {
                                    lastThread = -1;
                                }
                                if (lastThread != thread) {
                                    if (thread == 0) {
                                        currentGlobalThread = new GlobalThread(0);
                                        i = 0;
                                        while (i < numOfFunctions) {
                                            GlobalThreadDataElement tmpRef = null;
                                            currentGlobalThread.addThreadDataElement(tmpRef);
                                            ++i;
                                        }
                                        lastThread = thread;
                                        Vector tmpVector = currentGlobalThread.getThreadDataList();
                                        tmpGTDE = null;
                                        tmpGTDE = (GlobalThreadDataElement)tmpVector.elementAt(functionID);
                                        if (tmpGTDE == null) {
                                            tmpGTDE = new GlobalThreadDataElement();
                                            tmpGTDE.setFunctionID(functionID);
                                            tmpGTDE.setFunctionName(functionName);
                                            tmpGTDE.setFunctionGroup(functionGroup);
                                            currentGlobalThread.addThreadDataElement(tmpGTDE, functionID);
                                        }
                                        tmpGTDE.setFunctionExists();
                                        tmpGTDE.setExclValue(value);
                                        tmpGTDE.setExclPercValue(percentValue);
                                        if (context == 0) {
                                            currentGlobalContext = new GlobalContext(0);
                                            currentGlobalContext.addThread(currentGlobalThread);
                                            currentGlobalNode = new GlobalNode(node);
                                            currentGlobalNode.addContext(currentGlobalContext);
                                            this.NodeList.addElement(currentGlobalNode);
                                            lastContext = context;
                                            lastNode = node;
                                        } else {
                                            currentGlobalContext = new GlobalContext(context);
                                            currentGlobalContext.addThread(currentGlobalThread);
                                            currentGlobalNode.addContext(currentGlobalContext);
                                            lastContext = context;
                                        }
                                    } else {
                                        currentGlobalThread = new GlobalThread(thread);
                                        i = 0;
                                        while (i < numOfFunctions) {
                                            GlobalThreadDataElement tmpRef = null;
                                            currentGlobalThread.addThreadDataElement(tmpRef);
                                            ++i;
                                        }
                                        lastThread = thread;
                                        Vector tmpVector = currentGlobalThread.getThreadDataList();
                                        tmpGTDE = null;
                                        tmpGTDE = (GlobalThreadDataElement)tmpVector.elementAt(functionID);
                                        if (tmpGTDE == null) {
                                            tmpGTDE = new GlobalThreadDataElement();
                                            tmpGTDE.setFunctionID(functionID);
                                            tmpGTDE.setFunctionName(functionName);
                                            tmpGTDE.setFunctionGroup(functionGroup);
                                            currentGlobalThread.addThreadDataElement(tmpGTDE, functionID);
                                        }
                                        tmpGTDE.setFunctionExists();
                                        tmpGTDE.setExclValue(value);
                                        tmpGTDE.setExclPercValue(percentValue);
                                        currentGlobalContext.addThread(currentGlobalThread);
                                    }
                                } else {
                                    Vector tmpVector = currentGlobalThread.getThreadDataList();
                                    tmpGTDE = null;
                                    tmpGTDE = (GlobalThreadDataElement)tmpVector.elementAt(functionID);
                                    if (tmpGTDE == null) {
                                        tmpGTDE = new GlobalThreadDataElement();
                                        tmpGTDE.setFunctionID(functionID);
                                        tmpGTDE.setFunctionName(functionName);
                                        tmpGTDE.setFunctionGroup(functionGroup);
                                        currentGlobalThread.addThreadDataElement(tmpGTDE, functionID);
                                    }
                                    tmpGTDE.setFunctionExists();
                                    tmpGTDE.setExclValue(value);
                                    tmpGTDE.setExclPercValue(percentValue);
                                }
                            } else if (this.checkForInclusive(inputString)) {
                                GlobalNode tmpGS;
                                Vector tmpGlobalContextList;
                                GlobalContext tmpGC;
                                Vector tmpGlobalThreadList;
                                GlobalThread tmpGT;
                                Vector tmpGlobalThreadDataElementList;
                                GlobalThreadDataElement tmpGTDE;
                                functionID = this.getFunctionID(inputString);
                                functionName = this.getFunctionName(inputString);
                                functionGroup = this.isAGroupMember(inputString) ? this.getFunctionGroup(inputString) : null;
                                value = this.getValue(inputString);
                                percentValue = this.getPercentValue(inputString);
                                node = this.getNode(inputString, false);
                                context = this.getContext(inputString, false);
                                thread = this.getThread(inputString, false);
                                if (this.maxNode < node) {
                                    this.maxNode = node;
                                }
                                if (this.maxContext < context) {
                                    this.maxContext = context;
                                }
                                if (this.maxThread < thread) {
                                    this.maxThread = thread;
                                }
                                if ((tmpGTDE = (GlobalThreadDataElement)(tmpGlobalThreadDataElementList = (tmpGT = (GlobalThread)(tmpGlobalThreadList = (tmpGC = (GlobalContext)(tmpGlobalContextList = (tmpGS = (GlobalNode)this.NodeList.elementAt(node)).getContextList()).elementAt(context)).getThreadList()).elementAt(thread)).getThreadDataList()).elementAt(functionID)) == null) {
                                    tmpGTDE = new GlobalThreadDataElement();
                                    tmpGTDE.setFunctionID(functionID);
                                    tmpGTDE.setFunctionName(functionName);
                                    tmpGTDE.setFunctionGroup(functionGroup);
                                    currentGlobalThread.addThreadDataElement(tmpGTDE, functionID);
                                }
                                tmpGTDE.setInclValue(value);
                                tmpGTDE.setInclPercValue(percentValue);
                                inputString = preader.readLine();
                                calls = this.getCall(inputString);
                                subrs = this.getSubrs(inputString);
                                inclpcall = this.getInclPCall(inputString);
                                tmpGTDE.setCall(calls);
                                tmpGTDE.setSubrs(subrs);
                                tmpGTDE.setInclPCall(inclpcall);
                            } else if (this.checkForUserEvents(inputString)) {
                                int numberOfUserEvents;
                                this.ueAmount = numberOfUserEvents = this.getNumberOfUserEvents(inputString);
                                this.userEventHeading = inputString = preader.readLine();
                                GlobalNode tmpGSUE = null;
                                Vector tmpGlobalContextListUE = null;
                                GlobalContext tmpGCUE = null;
                                Vector tmpGlobalThreadListUE = null;
                                GlobalThread tmpGTUE = null;
                                Vector tmpGlobalThreadDataElementListUE = null;
                                int j = 0;
                                while (j < numberOfUserEvents) {
                                    inputString = preader.readLine();
                                    if (j == 0) {
                                        node = this.getNode(inputString, true);
                                        context = this.getContext(inputString, true);
                                        thread = this.getThread(inputString, true);
                                        tmpGSUE = (GlobalNode)this.NodeList.elementAt(node);
                                        tmpGlobalContextListUE = tmpGSUE.getContextList();
                                        tmpGCUE = (GlobalContext)tmpGlobalContextListUE.elementAt(context);
                                        tmpGlobalThreadListUE = tmpGCUE.getThreadList();
                                        tmpGTUE = (GlobalThread)tmpGlobalThreadListUE.elementAt(thread);
                                        int k = 0;
                                        while (k < numberOfUserEvents) {
                                            tmpGTUE.addUserThreadDataElement(new GlobalThreadDataElement());
                                            ++k;
                                        }
                                        tmpGlobalThreadDataElementListUE = tmpGTUE.getUserThreadDataList();
                                    }
                                    String userEventNameString = this.getUserEventName(inputString);
                                    userEventID = this.getUserEventID(inputString);
                                    GlobalThreadDataElement tmpGTDEUE = (GlobalThreadDataElement)tmpGlobalThreadDataElementListUE.elementAt(userEventID);
                                    tmpGTDEUE.setUserEventID(userEventID);
                                    tmpGTDEUE.setUserEventName(userEventNameString);
                                    tmpGTDEUE.setUserEventNumberValue(this.getUENValue(inputString));
                                    tmpGTDEUE.setUserEventMinValue(this.getUEMinValue(inputString));
                                    tmpGTDEUE.setUserEventMaxValue(this.getUEMaxValue(inputString));
                                    tmpGTDEUE.setUserEventMeanValue(this.getUEMeanValue(inputString));
                                    tmpGTDEUE.setUserEventStdDevValue(this.getUEStdDevValue(inputString));
                                    inputString = preader.readLine();
                                    ++j;
                                }
                            }
                        }
                    } else {
                        String tokenString = genericTokenizer.nextToken();
                        numOfFunctions = Integer.parseInt(tokenString);
                        this.initializeGlobalMapping(numOfFunctions);
                        tokenString = genericTokenizer.nextToken();
                        this.metricStr = this.getMetric(tokenString);
                        if (this.metricStr.length() == 0) {
                            this.metricStr = "time";
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeXmlFiles(String appid, String expid, String trialName) {
        block17: {
            try {
                GlobalMappingElement globalmappingObject;
                String sys = "";
                String config = "";
                String instru = "";
                String compiler = "";
                String appname = "";
                String version = "";
                String hostname = InetAddress.getLocalHost().getHostName();
                BufferedReader ireader = new BufferedReader(new InputStreamReader(System.in));
                if (appid == null) {
                    System.out.println("Please tell me the ID of the application this trial belongs to.");
                    appid = ireader.readLine().trim();
                }
                if (appid.length() > 0) {
                    appid = this.checkForApp(appid);
                } else {
                    System.out.println("If you don't know the exact application ID, please tell me the application group the trial belongs to:");
                    appname = ireader.readLine().trim();
                    System.out.println("Please tell me the application version");
                    version = ireader.readLine().trim();
                    appid = this.checkForApp(appname, version);
                }
                if (appid == null) {
                    System.out.println("Cannot find such an application. Quit translanting.");
                    System.exit(-1);
                }
                if (expid == null) {
                    System.out.println("Please tell me the ID of the experiment group this trial belongs to.");
                    expid = ireader.readLine().trim();
                }
                if (expid.length() > 0) {
                    expid = this.checkForEnv(expid);
                } else {
                    System.out.println("If you don't know the exact experiment ID number, please tell me the location of environment files,");
                    System.out.println("if they are different from ./Sys_Info.xml, ./Config_Info.xml, ./Instru_Info.xml and ./Compiler_Info.xml respectively.");
                    System.out.println("System information:");
                    sys = ireader.readLine().trim();
                    File ff = sys.trim().length() == 0 ? new File("Sys_Info.xml") : new File(sys);
                    sys = hostname + ":" + ff.getAbsolutePath();
                    System.out.println("Configuration information:");
                    config = ireader.readLine().trim();
                    ff = config.trim().length() == 0 ? new File("Config_Info.xml") : new File(config);
                    config = hostname + ":" + ff.getAbsolutePath();
                    System.out.println("Instrumentation information:");
                    instru = ireader.readLine().trim();
                    ff = instru.trim().length() == 0 ? new File("Instru_Info.xml") : new File(instru);
                    instru = hostname + ":" + ff.getAbsolutePath();
                    System.out.println("Compiler information:");
                    compiler = ireader.readLine().trim();
                    ff = compiler.trim().length() == 0 ? new File("Compiler_Info.xml") : new File(compiler);
                    compiler = hostname + ":" + ff.getAbsolutePath();
                    expid = this.checkForEnv(sys, config, compiler, instru, appid);
                }
                if (expid == null) {
                    System.out.println("Cannot find such an experiment that is in accordance with the information you provided above. Quit translanting.");
                    System.exit(-1);
                    break block17;
                }
                BufferedWriter xwriter = new BufferedWriter(new FileWriter(this.writeXml));
                xwriter.write("<?xml version=\"1.0\"?>", 0, "<?xml version=\"1.0\"?>".length());
                xwriter.newLine();
                xwriter.write("<Trials>", 0, "<Trials>".length());
                xwriter.newLine();
                xwriter.write("    <Onetrial Metric='" + this.metricStr + "'>", 0, ("    <Onetrial Metric='" + this.metricStr + "'>").length());
                xwriter.newLine();
                this.writeComputationModel(xwriter, this.maxNode + 1, this.maxContext + 1, this.maxThread + 1);
                xwriter.write("\t<Env>", 0, "\t<Env>".length());
                xwriter.newLine();
                xwriter.write("\t   <AppID>" + appid + "</AppID>", 0, ("\t   <AppID>" + appid + "</AppID>").length());
                xwriter.newLine();
                xwriter.write("\t   <ExpID>" + expid + "</ExpID>", 0, ("\t   <ExpID>" + expid + "</ExpID>").length());
                xwriter.newLine();
                xwriter.write("\t   <TrialName>" + trialName + "</TrialName>", 0, ("\t   <TrialName>" + trialName + "</TrialName>").length());
                xwriter.newLine();
                xwriter.write("\t</Env>", 0, "\t</Env>".length());
                xwriter.newLine();
                xwriter.write("\t<Trialtime>" + this.trialTime + "</Trialtime>", 0, ("\t<Trialtime>" + this.trialTime + "</Trialtime>").length());
                xwriter.newLine();
                xwriter.write("\t<FunAmt>" + this.funAmount + "</FunAmt>", 0, ("\t<FunAmt>" + this.funAmount + "</FunAmt>").length());
                xwriter.newLine();
                xwriter.write("\t<UserEventAmt>" + this.ueAmount + "</UserEventAmt>", 0, ("\t<UserEventAmt>" + this.ueAmount + "</UserEventAmt>").length());
                xwriter.newLine();
                xwriter.write("\t<Pprof>", 0, "\t<Pprof>".length());
                xwriter.newLine();
                Enumeration en = this.NodeList.elements();
                while (en.hasMoreElements()) {
                    GlobalNode nodeObject = (GlobalNode)en.nextElement();
                    int currentnode = nodeObject.getNodeName();
                    Vector ContextList = nodeObject.getContextList();
                    Enumeration ec = ContextList.elements();
                    while (ec.hasMoreElements()) {
                        GlobalContext contextObject = (GlobalContext)ec.nextElement();
                        int currentcontext = contextObject.getContextName();
                        Vector ThreadList = contextObject.getThreadList();
                        Enumeration et = ThreadList.elements();
                        while (et.hasMoreElements()) {
                            GlobalThread threadObject = (GlobalThread)et.nextElement();
                            int currentthread = threadObject.getThreadName();
                            Vector ThreadDataList = threadObject.getThreadDataList();
                            Vector UserThreadDataList = threadObject.getUserThreadDataList();
                            this.writeIDs(xwriter, currentnode, currentcontext, currentthread);
                            Enumeration ef = ThreadDataList.elements();
                            while (ef.hasMoreElements()) {
                                GlobalThreadDataElement funObject = (GlobalThreadDataElement)ef.nextElement();
                                if (funObject == null) continue;
                                this.writeFunName(xwriter, funObject.getFunctionName());
                                this.writeFunID(xwriter, funObject.getFunctionID());
                                this.writeFunGroup(xwriter, funObject.getFunctionGroup());
                                this.writeInclPerc(xwriter, funObject.getInclPercValue());
                                this.writeIncl(xwriter, funObject.getInclValue());
                                this.writeExclPerc(xwriter, funObject.getExclPercValue());
                                this.writeExcl(xwriter, funObject.getExclValue());
                                this.writeCall(xwriter, funObject.getCall());
                                this.writeSubrs(xwriter, funObject.getSubrs());
                                this.writeInclPCall(xwriter, funObject.getInclPCall());
                            }
                            Enumeration uef = UserThreadDataList.elements();
                            while (uef.hasMoreElements()) {
                                GlobalThreadDataElement ueObject = (GlobalThreadDataElement)uef.nextElement();
                                if (ueObject == null) continue;
                                this.writeUEName(xwriter, ueObject.getUserEventName());
                                this.writeUEID(xwriter, ueObject.getUserEventID());
                                this.writeNumofSamples(xwriter, ueObject.getUserEventNumberValue());
                                this.writeMaxValue(xwriter, ueObject.getUserEventMaxValue());
                                this.writeMinValue(xwriter, ueObject.getUserEventMinValue());
                                this.writeMeanValue(xwriter, ueObject.getUserEventMeanValue());
                                this.writeStdDevValue(xwriter, ueObject.getUserEventStdDevValue());
                            }
                        }
                    }
                }
                xwriter.write("\t</Pprof>", 0, "\t</Pprof>".length());
                xwriter.newLine();
                xwriter.newLine();
                xwriter.write("\t<totalfunsummary>", 0, "\t<totalfunsummary>".length());
                xwriter.newLine();
                Vector globalMappingElementList = this.globalMapping.getNameIDMapping();
                Enumeration et = globalMappingElementList.elements();
                while (et.hasMoreElements()) {
                    globalmappingObject = (GlobalMappingElement)et.nextElement();
                    if (globalmappingObject.getFunctionName() == "Name has not been set!") continue;
                    this.writeTotalFunName(xwriter, globalmappingObject.getFunctionName());
                    this.writeTotalFunID(xwriter, globalmappingObject.getGlobalID());
                    this.writeTotalFunGroup(xwriter, globalmappingObject.getFunctionGroup());
                    this.writeTotalInclPerc(xwriter, globalmappingObject.getTotalInclusivePercentValue());
                    this.writeTotalIncl(xwriter, globalmappingObject.getTotalInclusiveValue());
                    this.writeTotalExclPerc(xwriter, globalmappingObject.getTotalExclusivePercentValue());
                    this.writeTotalExcl(xwriter, globalmappingObject.getTotalExclusiveValue());
                    this.writeTotalCall(xwriter, globalmappingObject.getTotalCall());
                    this.writeTotalSubrs(xwriter, globalmappingObject.getTotalSubrs());
                    this.writeTotalInclPCall(xwriter, globalmappingObject.getTotalInclPCall());
                }
                xwriter.write("\t</totalfunsummary>", 0, "\t</totalfunsummary>".length());
                xwriter.newLine();
                xwriter.newLine();
                xwriter.write("\t<meanfunsummary>", 0, "\t<meanfunsummary>".length());
                xwriter.newLine();
                Enumeration em = globalMappingElementList.elements();
                while (em.hasMoreElements()) {
                    globalmappingObject = (GlobalMappingElement)em.nextElement();
                    if (globalmappingObject.getFunctionName() == "Name has not been set!") continue;
                    this.writeMeanFunName(xwriter, globalmappingObject.getFunctionName());
                    this.writeMeanFunID(xwriter, globalmappingObject.getGlobalID());
                    this.writeMeanFunGroup(xwriter, globalmappingObject.getFunctionGroup());
                    this.writeMeanInclPerc(xwriter, globalmappingObject.getMeanInclusivePercentValue());
                    this.writeMeanIncl(xwriter, globalmappingObject.getMeanInclusiveValue());
                    this.writeMeanExclPerc(xwriter, globalmappingObject.getMeanExclusivePercentValue());
                    this.writeMeanExcl(xwriter, globalmappingObject.getMeanExclusiveValue());
                    this.writeMeanCall(xwriter, globalmappingObject.getMeanCall());
                    this.writeMeanSubrs(xwriter, globalmappingObject.getMeanSubrs());
                    this.writeMeanInclPCall(xwriter, globalmappingObject.getMeanInclPCall());
                }
                xwriter.write("\t</meanfunsummary>", 0, "\t</meanfunsummary>".length());
                xwriter.newLine();
                xwriter.write("    </Onetrial>", 0, "    </Onetrial>".length());
                xwriter.newLine();
                xwriter.write("</Trials>", 0, "</Trials>".length());
                xwriter.newLine();
                xwriter.close();
                this.connector.dbclose();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    boolean checkForBeginningT(String inString) {
        try {
            StringTokenizer checkForBeginningTTokenizer = new StringTokenizer(inString, " \t\n\r");
            String tmpString = checkForBeginningTTokenizer.nextToken();
            return tmpString.equals("t");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    boolean checkForBeginningM(String inString) {
        try {
            StringTokenizer checkForBeginningTTokenizer = new StringTokenizer(inString, " \t\n\r");
            String tmpString = checkForBeginningTTokenizer.nextToken();
            return tmpString.equals("m");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    boolean checkForExclusive(String inString) {
        try {
            StringTokenizer checkTokenizer = new StringTokenizer(inString, " ");
            String tmpString2 = checkTokenizer.nextToken();
            if (tmpString2.indexOf(",") != -1) {
                StringTokenizer checkQuotesTokenizer = new StringTokenizer(inString, "\"");
                String tmpString = checkQuotesTokenizer.nextToken();
                tmpString = checkQuotesTokenizer.nextToken();
                tmpString = checkQuotesTokenizer.nextToken();
                StringTokenizer checkForExclusiveTokenizer = new StringTokenizer(tmpString, " \t\n\r");
                if ((tmpString = checkForExclusiveTokenizer.nextToken()).equals("excl")) {
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    boolean checkForExclusiveWithTOrM(String inString) {
        try {
            StringTokenizer checkQuotesTokenizer = new StringTokenizer(inString, "\"");
            String tmpString = checkQuotesTokenizer.nextToken();
            tmpString = checkQuotesTokenizer.nextToken();
            tmpString = checkQuotesTokenizer.nextToken();
            StringTokenizer checkForExclusiveTokenizer = new StringTokenizer(tmpString, " \t\n\r");
            tmpString = checkForExclusiveTokenizer.nextToken();
            return tmpString.equals("excl");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    boolean checkForInclusive(String inString) {
        try {
            StringTokenizer checkTokenizer = new StringTokenizer(inString, " ");
            String tmpString2 = checkTokenizer.nextToken();
            if (tmpString2.indexOf(",") != -1) {
                StringTokenizer checkQuotesTokenizer = new StringTokenizer(inString, "\"");
                String tmpString = checkQuotesTokenizer.nextToken();
                tmpString = checkQuotesTokenizer.nextToken();
                tmpString = checkQuotesTokenizer.nextToken();
                StringTokenizer checkForInclusiveTokenizer = new StringTokenizer(tmpString, " \t\n\r");
                if ((tmpString = checkForInclusiveTokenizer.nextToken()).equals("incl")) {
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    boolean checkForInclusiveWithTOrM(String inString) {
        try {
            StringTokenizer checkQuotesTokenizer = new StringTokenizer(inString, "\"");
            String tmpString = checkQuotesTokenizer.nextToken();
            tmpString = checkQuotesTokenizer.nextToken();
            tmpString = checkQuotesTokenizer.nextToken();
            StringTokenizer checkForInclusiveTokenizer = new StringTokenizer(tmpString, " \t\n\r");
            tmpString = checkForInclusiveTokenizer.nextToken();
            return tmpString.equals("incl");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    String getFunctionName(String inString) {
        try {
            StringTokenizer getFunctionNameTokenizer = new StringTokenizer(inString, "\"");
            String tmpString = getFunctionNameTokenizer.nextToken();
            tmpString = getFunctionNameTokenizer.nextToken();
            return tmpString.trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    int getFunctionID(String inString) {
        try {
            StringTokenizer getFunctionIDTokenizer = new StringTokenizer(inString, " \t\n\r");
            String tmpString = getFunctionIDTokenizer.nextToken();
            tmpString = getFunctionIDTokenizer.nextToken();
            return Integer.parseInt(tmpString);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    boolean isAGroupMember(String inString) {
        try {
            StringTokenizer getFunctionGroupTokenizer = new StringTokenizer(inString, "\"");
            if (getFunctionGroupTokenizer.countTokens() > 3) {
                String tmpString = getFunctionGroupTokenizer.nextToken();
                tmpString = getFunctionGroupTokenizer.nextToken();
                tmpString = getFunctionGroupTokenizer.nextToken();
                return tmpString.trim().endsWith("GROUP=");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    String getFunctionGroup(String inString) {
        try {
            StringTokenizer getFunctionGroupTokenizer = new StringTokenizer(inString, "\"");
            String tmpString = getFunctionGroupTokenizer.nextToken();
            tmpString = getFunctionGroupTokenizer.nextToken();
            tmpString = getFunctionGroupTokenizer.nextToken();
            tmpString = getFunctionGroupTokenizer.nextToken();
            return tmpString.trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    double getValue(String inString) {
        try {
            StringTokenizer valueQuotesTokenizer = new StringTokenizer(inString, "\"");
            String tmpString = valueQuotesTokenizer.nextToken();
            tmpString = valueQuotesTokenizer.nextToken();
            tmpString = valueQuotesTokenizer.nextToken();
            StringTokenizer valueTokenizer = new StringTokenizer(tmpString, " \t\n\r");
            tmpString = valueTokenizer.nextToken();
            tmpString = valueTokenizer.nextToken();
            return Double.parseDouble(tmpString);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1.0;
        }
    }

    double getPercentValue(String inString) {
        try {
            StringTokenizer percentValueQuotesTokenizer = new StringTokenizer(inString, "\"");
            String tmpString = percentValueQuotesTokenizer.nextToken();
            tmpString = percentValueQuotesTokenizer.nextToken();
            tmpString = percentValueQuotesTokenizer.nextToken();
            StringTokenizer percentValueTokenizer = new StringTokenizer(tmpString, " \t\n\r");
            tmpString = percentValueTokenizer.nextToken();
            tmpString = percentValueTokenizer.nextToken();
            tmpString = percentValueTokenizer.nextToken();
            return Double.parseDouble(tmpString);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1.0;
        }
    }

    double getCall(String inString) {
        try {
            StringTokenizer callValueTokenizer = new StringTokenizer(inString, " \t\n\r");
            String tmpString = callValueTokenizer.nextToken();
            tmpString = callValueTokenizer.nextToken();
            tmpString = callValueTokenizer.nextToken();
            tmpString = callValueTokenizer.nextToken();
            return Double.parseDouble(tmpString);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1.0;
        }
    }

    double getSubrs(String inString) {
        try {
            StringTokenizer callValueTokenizer = new StringTokenizer(inString, " \t\n\r");
            String tmpString = callValueTokenizer.nextToken();
            tmpString = callValueTokenizer.nextToken();
            tmpString = callValueTokenizer.nextToken();
            tmpString = callValueTokenizer.nextToken();
            tmpString = callValueTokenizer.nextToken();
            return Double.parseDouble(tmpString);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1.0;
        }
    }

    double getInclPCall(String inString) {
        try {
            StringTokenizer callValueTokenizer = new StringTokenizer(inString, " \t\n\r");
            String tmpString = callValueTokenizer.nextToken();
            tmpString = callValueTokenizer.nextToken();
            tmpString = callValueTokenizer.nextToken();
            tmpString = callValueTokenizer.nextToken();
            tmpString = callValueTokenizer.nextToken();
            tmpString = callValueTokenizer.nextToken();
            return Double.parseDouble(tmpString);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1.0;
        }
    }

    boolean checkForUserEvents(String inString) {
        try {
            StringTokenizer checkForUserEventsTokenizer = new StringTokenizer(inString, " \t\n\r");
            String tmpString = checkForUserEventsTokenizer.nextToken();
            tmpString = checkForUserEventsTokenizer.nextToken();
            return tmpString.equals("userevents");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    int getNumberOfUserEvents(String inString) {
        try {
            StringTokenizer getNumberOfUserEventsTokenizer = new StringTokenizer(inString, " \t\n\r");
            String tmpString = getNumberOfUserEventsTokenizer.nextToken();
            return Integer.parseInt(tmpString);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    String getUserEventName(String inString) {
        try {
            StringTokenizer getUserEventNameTokenizer = new StringTokenizer(inString, "\"");
            String tmpString = getUserEventNameTokenizer.nextToken();
            tmpString = getUserEventNameTokenizer.nextToken();
            return tmpString;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    int getUserEventID(String inString) {
        try {
            StringTokenizer getUserEventIDTokenizer = new StringTokenizer(inString, " \t\n\r");
            String tmpString = getUserEventIDTokenizer.nextToken();
            tmpString = getUserEventIDTokenizer.nextToken();
            tmpString = getUserEventIDTokenizer.nextToken();
            return Integer.parseInt(tmpString);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    int getUENValue(String inString) {
        try {
            StringTokenizer uEQuotesTokenizer = new StringTokenizer(inString, "\"");
            String tmpString = uEQuotesTokenizer.nextToken();
            tmpString = uEQuotesTokenizer.nextToken();
            tmpString = uEQuotesTokenizer.nextToken();
            StringTokenizer uETokenizer = new StringTokenizer(tmpString, " \t\n\r");
            tmpString = uETokenizer.nextToken();
            return (int)Double.parseDouble(tmpString);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    double getUEMinValue(String inString) {
        try {
            StringTokenizer uEQuotesTokenizer = new StringTokenizer(inString, "\"");
            String tmpString = uEQuotesTokenizer.nextToken();
            tmpString = uEQuotesTokenizer.nextToken();
            tmpString = uEQuotesTokenizer.nextToken();
            StringTokenizer uETokenizer = new StringTokenizer(tmpString, " \t\n\r");
            tmpString = uETokenizer.nextToken();
            tmpString = uETokenizer.nextToken();
            tmpString = uETokenizer.nextToken();
            return Double.parseDouble(tmpString);
        }
        catch (Exception e) {
            return -1.0;
        }
    }

    double getUEMaxValue(String inString) {
        try {
            StringTokenizer uEQuotesTokenizer = new StringTokenizer(inString, "\"");
            String tmpString = uEQuotesTokenizer.nextToken();
            tmpString = uEQuotesTokenizer.nextToken();
            tmpString = uEQuotesTokenizer.nextToken();
            StringTokenizer uETokenizer = new StringTokenizer(tmpString, " \t\n\r");
            tmpString = uETokenizer.nextToken();
            tmpString = uETokenizer.nextToken();
            return Double.parseDouble(tmpString);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1.0;
        }
    }

    double getUEMeanValue(String inString) {
        try {
            StringTokenizer uEQuotesTokenizer = new StringTokenizer(inString, "\"");
            String tmpString = uEQuotesTokenizer.nextToken();
            tmpString = uEQuotesTokenizer.nextToken();
            tmpString = uEQuotesTokenizer.nextToken();
            StringTokenizer uETokenizer = new StringTokenizer(tmpString, " \t\n\r");
            tmpString = uETokenizer.nextToken();
            tmpString = uETokenizer.nextToken();
            tmpString = uETokenizer.nextToken();
            tmpString = uETokenizer.nextToken();
            return Double.parseDouble(tmpString);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1.0;
        }
    }

    double getUEStdDevValue(String inString) {
        try {
            StringTokenizer uEQuotesTokenizer = new StringTokenizer(inString, "\"");
            String tmpString = uEQuotesTokenizer.nextToken();
            tmpString = uEQuotesTokenizer.nextToken();
            tmpString = uEQuotesTokenizer.nextToken();
            StringTokenizer uETokenizer = new StringTokenizer(tmpString, " \t\n\r");
            tmpString = uETokenizer.nextToken();
            tmpString = uETokenizer.nextToken();
            tmpString = uETokenizer.nextToken();
            tmpString = uETokenizer.nextToken();
            tmpString = uETokenizer.nextToken();
            return Double.parseDouble(tmpString);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1.0;
        }
    }

    int getNode(String inString, boolean UEvent) {
        try {
            String tmpString;
            StringTokenizer getNodeTokenizer = new StringTokenizer(inString, ", \t\n\r");
            if (UEvent) {
                tmpString = getNodeTokenizer.nextToken();
            }
            tmpString = getNodeTokenizer.nextToken();
            Integer tmpInteger = new Integer(tmpString);
            int tmpInt = tmpInteger;
            return tmpInt;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    int getContext(String inString, boolean UEvent) {
        try {
            String tmpString;
            StringTokenizer getContextTokenizer = new StringTokenizer(inString, ", \t\n\r");
            if (UEvent) {
                tmpString = getContextTokenizer.nextToken();
            }
            tmpString = getContextTokenizer.nextToken();
            tmpString = getContextTokenizer.nextToken();
            Integer tmpInteger = new Integer(tmpString);
            int tmpInt = tmpInteger;
            return tmpInt;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    int getThread(String inString, boolean UEvent) {
        try {
            String tmpString;
            StringTokenizer getThreadTokenizer = new StringTokenizer(inString, ", \t\n\r");
            if (UEvent) {
                tmpString = getThreadTokenizer.nextToken();
            }
            tmpString = getThreadTokenizer.nextToken();
            tmpString = getThreadTokenizer.nextToken();
            tmpString = getThreadTokenizer.nextToken();
            Integer tmpInteger = new Integer(tmpString);
            int tmpInt = tmpInteger;
            return tmpInt;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void writeComputationModel(BufferedWriter writer, int node, int context, int thread) {
        try {
            writer.write("\t<ComputationModel>", 0, "\t<ComputationModel>".length());
            writer.newLine();
            String tmpString = "\t   <node level=\"Top\" statis_info=\"sum\">" + node + "</node>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
            tmpString = "\t   <context level=\"Secondary\" statis_info=\"contextPnode\">" + context + "</context>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
            tmpString = "\t   <thread level=\"Lowest\" statis_info=\"threadPcontext\">" + thread + "</thread>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
            writer.write("\t</ComputationModel>", 0, "\t</ComputationModel>".length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeIDs(BufferedWriter writer, int node, int context, int thread) {
        try {
            String tmpString = "\t   <nodeID>" + node + "</nodeID>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
            tmpString = "\t   <contextID>" + context + "</contextID>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
            tmpString = "\t   <threadID>" + thread + "</threadID>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeFunName(BufferedWriter writer, String funname) {
        try {
            writer.write("\t   <instrumentedobj>", 0, "\t   <instrumentedobj>".length());
            writer.newLine();
            funname = this.replace(funname, "&", "&amp;");
            funname = this.replace(funname, "<", "&lt;");
            funname = this.replace(funname, ">", "&gt;");
            String tmpString = "\t\t<funname>" + funname + "</funname>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeFunID(BufferedWriter writer, int funID) {
        try {
            String tmpString = "\t\t<funID>" + funID + "</funID>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeFunGroup(BufferedWriter writer, String funGroup) {
        try {
            String tmpString = "\t\t<fungroup>" + funGroup + "</fungroup>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeInclPerc(BufferedWriter writer, double InclPercValue) {
        try {
            String tmpString = "\t\t<inclperc>" + InclPercValue + "</inclperc>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeIncl(BufferedWriter writer, double InclValue) {
        try {
            String tmpString = "\t\t<inclutime>" + InclValue + "</inclutime>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeExclPerc(BufferedWriter writer, double ExclPercValue) {
        try {
            String tmpString = "\t\t<exclperc>" + ExclPercValue + "</exclperc>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeExcl(BufferedWriter writer, double ExclValue) {
        try {
            String tmpString = "\t\t<exclutime>" + ExclValue + "</exclutime>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeCall(BufferedWriter writer, double calls) {
        try {
            String tmpString = "\t\t<call>" + calls + "</call>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeSubrs(BufferedWriter writer, double subrs) {
        try {
            String tmpString = "\t\t<subrs>" + subrs + "</subrs>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeInclPCall(BufferedWriter writer, double InclPCall) {
        try {
            String tmpString = "\t\t<inclutimePcall>" + InclPCall + "</inclutimePcall>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
            writer.write("\t   </instrumentedobj>", 0, "\t   </instrumentedobj>".length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeUEName(BufferedWriter writer, String name) {
        try {
            writer.write("\t   <userevent>", 0, "\t   <userevent>".length());
            writer.newLine();
            String tmpString = "\t\t<uename>" + name + "</uename>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeUEID(BufferedWriter writer, int ueID) {
        try {
            String tmpString = "\t\t<ueID>" + ueID + "</ueID>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeNumofSamples(BufferedWriter writer, int numofsamples) {
        try {
            String tmpString = "\t\t<numofsamples>" + numofsamples + "</numofsamples>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeMaxValue(BufferedWriter writer, double maxValue) {
        try {
            String tmpString = "\t\t<maxvalue>" + maxValue + "</maxvalue>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeMinValue(BufferedWriter writer, double minValue) {
        try {
            String tmpString = "\t\t<minvalue>" + minValue + "</minvalue>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeMeanValue(BufferedWriter writer, double meanValue) {
        try {
            String tmpString = "\t\t<meanvalue>" + meanValue + "</meanvalue>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeStdDevValue(BufferedWriter writer, double stdDevValue) {
        try {
            String tmpString = "\t\t<stddevvalue>" + stdDevValue + "</stddevvalue>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
            writer.write("\t   </userevent>", 0, "\t   </userevent>".length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeTotalFunName(BufferedWriter writer, String funname) {
        try {
            writer.write("\t   <totalfunction>", 0, "\t   <totalfunction>".length());
            writer.newLine();
            funname = this.replace(funname, "&", "&amp;");
            funname = this.replace(funname, "<", "&lt;");
            funname = this.replace(funname, ">", "&gt;");
            String tmpString = "\t\t<funname>" + funname + "</funname>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeTotalFunID(BufferedWriter writer, int funID) {
        try {
            String tmpString = "\t\t<funID>" + funID + "</funID>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeTotalFunGroup(BufferedWriter writer, String funGroup) {
        try {
            String tmpString = "\t\t<fungroup>" + funGroup + "</fungroup>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeTotalInclPerc(BufferedWriter writer, double inclperc) {
        try {
            String tmpString = "\t\t<inclperc>" + inclperc + "</inclperc>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeTotalIncl(BufferedWriter writer, double incl) {
        try {
            String tmpString = "\t\t<inclutime>" + incl + "</inclutime>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeTotalExclPerc(BufferedWriter writer, double exclperc) {
        try {
            String tmpString = "\t\t<exclperc>" + exclperc + "</exclperc>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeTotalExcl(BufferedWriter writer, double excl) {
        try {
            String tmpString = "\t\t<exclutime>" + excl + "</exclutime>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeTotalCall(BufferedWriter writer, double calls) {
        try {
            String tmpString = "\t\t<call>" + calls + "</call>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeTotalSubrs(BufferedWriter writer, double subrs) {
        try {
            String tmpString = "\t\t<subrs>" + subrs + "</subrs>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeTotalInclPCall(BufferedWriter writer, double InclPCall) {
        try {
            String tmpString = "\t\t<inclutimePcall>" + InclPCall + "</inclutimePcall>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
            writer.write("\t   </totalfunction>", 0, "\t   </totalfunction>".length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeMeanFunID(BufferedWriter writer, int funID) {
        try {
            String tmpString = "\t\t<funID>" + funID + "</funID>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeMeanFunName(BufferedWriter writer, String funname) {
        try {
            writer.write("\t   <meanfunction>", 0, "\t   <meanfunction>".length());
            writer.newLine();
            funname = this.replace(funname, "&", "&amp;");
            funname = this.replace(funname, "<", "&lt;");
            funname = this.replace(funname, ">", "&gt;");
            String tmpString = "\t\t<funname>" + funname + "</funname>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeMeanFunGroup(BufferedWriter writer, String funGroup) {
        try {
            String tmpString = "\t\t<fungroup>" + funGroup + "</fungroup>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeMeanInclPerc(BufferedWriter writer, double inclperc) {
        try {
            String tmpString = "\t\t<inclperc>" + inclperc + "</inclperc>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeMeanIncl(BufferedWriter writer, double incl) {
        try {
            String tmpString = "\t\t<inclutime>" + incl + "</inclutime>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeMeanExclPerc(BufferedWriter writer, double exclperc) {
        try {
            String tmpString = "\t\t<exclperc>" + exclperc + "</exclperc>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeMeanExcl(BufferedWriter writer, double excl) {
        try {
            String tmpString = "\t\t<exclutime>" + excl + "</exclutime>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeMeanCall(BufferedWriter writer, double calls) {
        try {
            String tmpString = "\t\t<call>" + calls + "</call>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeMeanSubrs(BufferedWriter writer, double subrs) {
        try {
            String tmpString = "\t\t<subrs>" + subrs + "</subrs>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeMeanInclPCall(BufferedWriter writer, double inclpcall) {
        try {
            String tmpString = "\t\t<inclutimePcall>" + inclpcall + "</inclutimePcall>";
            writer.write(tmpString, 0, tmpString.length());
            writer.newLine();
            writer.write("\t   </meanfunction>", 0, "\t   </meanfunction>".length());
            writer.newLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getMetric(String str) {
        if (str.length() > 26) {
            return str.substring(26, str.length());
        }
        return new String("");
    }

    /*
     * WARNING - void declaration
     */
    public String replace(String str, String lstr, String rstr) {
        int i;
        String tempStr = "";
        while ((i = str.indexOf(lstr)) != -1) {
            void var5_5;
            if (var5_5 > 0) {
                tempStr = tempStr + str.substring(0, (int)var5_5);
            }
            tempStr = tempStr + rstr;
            str = str.substring((int)(var5_5 + true));
        }
        tempStr = tempStr + str;
        return tempStr;
    }

    public String getFunAmt(String inString) {
        try {
            StringTokenizer funAmtTokenizer = new StringTokenizer(inString, " \t\n\r");
            String tmpString = funAmtTokenizer.nextToken();
            return tmpString;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String checkForApp(String appid) {
        String returnVal = null;
        StringBuffer buf = new StringBuffer();
        buf.append("select a.id from ");
        buf.append("application a ");
        buf.append("where a.id=" + appid + "; ");
        try {
            returnVal = this.connector.getDB().getDataItem(buf.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return returnVal;
    }

    public String checkForApp(String appname, String appversion) {
        String appid = null;
        StringBuffer buf = new StringBuffer();
        buf.append("select a.id from ");
        buf.append("application a ");
        buf.append("where a.name='" + appname.trim() + "' and a.version='" + appversion.trim() + "'; ");
        try {
            appid = this.connector.getDB().getDataItem(buf.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return appid;
    }

    public String checkForEnv(String expid) {
        String returnVal = null;
        StringBuffer buf = new StringBuffer();
        buf.append("select e.id from ");
        buf.append("experiment e ");
        buf.append("where e.id=" + expid + "; ");
        try {
            returnVal = this.connector.getDB().getDataItem(buf.toString());
            if (returnVal == null) {
                System.out.println("No proper experiment group found");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return returnVal;
    }

    public String checkForEnv(String sys, String config, String compiler, String instru, String appid) {
        String expid = null;
        StringBuffer buf = new StringBuffer();
        buf.append("select e.id from ");
        buf.append("experiment e ");
        buf.append("where e.application='" + appid.trim() + "' and e.system_info like '%" + sys + "%' and e.configuration_info like '%" + config + "%' and e.instrumentation_info like '%" + instru + "%' and e.compiler_info like '%" + compiler + "%'; ");
        try {
            expid = this.connector.getDB().getDataItem(buf.toString());
            if (expid == null) {
                System.out.println("Error: No proper experiment group found");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return expid;
    }

    public static void main(String[] args) {
        String USAGE = "USAGE: perfdb_translate [{-s,--sourcefile} sourcefilename] [{-d,destinationfile} destinationname] [{-a,--applicationid} application_id] [{-e,--experimentid} experiment_id] [{-n,--name} trial_name]";
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option helpOpt = parser.addBooleanOption('h', "help");
        CmdLineParser.Option configfileOpt = parser.addStringOption('g', "configfile");
        CmdLineParser.Option sourcefileOpt = parser.addStringOption('s', "sourcefile");
        CmdLineParser.Option destinationfileOpt = parser.addStringOption('d', "destinationfile");
        CmdLineParser.Option experimentidOpt = parser.addStringOption('e', "experimentid");
        CmdLineParser.Option applicationidOpt = parser.addStringOption('a', "applicationid");
        CmdLineParser.Option nameOpt = parser.addStringOption('n', "name");
        try {
            parser.parse(args);
        }
        catch (CmdLineParser.OptionException e) {
            System.err.println(e.getMessage());
            System.err.println(USAGE);
            System.exit(-1);
        }
        Boolean help = (Boolean)parser.getOptionValue(helpOpt);
        String configFile = (String)parser.getOptionValue(configfileOpt);
        String sourceFile = (String)parser.getOptionValue(sourcefileOpt);
        String destinationFile = (String)parser.getOptionValue(destinationfileOpt);
        String applicationID = (String)parser.getOptionValue(applicationidOpt);
        String experimentID = (String)parser.getOptionValue(experimentidOpt);
        String trialName = (String)parser.getOptionValue(nameOpt);
        if (help != null && help.booleanValue()) {
            System.err.println(USAGE);
            System.exit(-1);
        }
        if (configFile == null) {
            System.err.println("Please enter a valid config file.");
            System.err.println(USAGE);
            System.exit(-1);
        } else if (sourceFile == null) {
            System.err.println("Please enter a valid source file.");
            System.err.println(USAGE);
            System.exit(-1);
        } else if (destinationFile == null) {
            System.err.println("Please enter a valid destination file.");
            System.err.println(USAGE);
            System.exit(-1);
        } else if (applicationID == null) {
            System.err.println("Please enter a valid application ID.");
            System.err.println(USAGE);
            System.exit(-1);
        } else if (experimentID == null) {
            System.err.println("Please enter a valid experiment ID.");
            System.err.println(USAGE);
            System.exit(-1);
        }
        if (trialName == null) {
            trialName = new String("");
        }
        Translator trans = new Translator(configFile, sourceFile, destinationFile);
        trans.buildPprof();
        trans.writeXmlFiles(applicationID, experimentID, trialName);
        System.out.println("Done - Translating pprof.dat into pprof.xml!");
    }
}

