/*
 * Decompiled with CFR 0.152.
 */
package org.jatha.dynatype;

import java.io.PrintStream;
import java.math.BigInteger;
import org.jatha.Jatha;
import org.jatha.dynatype.LispBignum;
import org.jatha.dynatype.LispInteger;
import org.jatha.dynatype.LispReal;
import org.jatha.dynatype.LispValue;
import org.jatha.dynatype.StandardLispInteger;

public class StandardLispBignum
extends StandardLispInteger
implements LispBignum {
    private BigInteger value;

    public StandardLispBignum() {
    }

    public StandardLispBignum(Jatha lisp, BigInteger theValue) {
        super(lisp);
        this.value = theValue;
    }

    public StandardLispBignum(Jatha lisp, long theValue) {
        super(lisp);
        this.value = BigInteger.valueOf(theValue);
    }

    public StandardLispBignum(Jatha lisp, double theValue) {
        super(lisp);
        this.value = BigInteger.valueOf((long)theValue);
    }

    public StandardLispBignum(Jatha lisp) {
        super(lisp);
        this.value = LispBignum.ZERO;
    }

    public double getDoubleValue() {
        return this.value.doubleValue();
    }

    public BigInteger getBigIntegerValue() {
        return this.value;
    }

    public long getLongValue() {
        return this.value.longValue();
    }

    public void internal_princ(PrintStream os) {
        os.print(this.value);
    }

    public void internal_prin1(PrintStream os) {
        os.print(this.value);
    }

    public void internal_print(PrintStream os) {
        os.print(this.value);
    }

    public boolean basic_bignump() {
        return true;
    }

    public boolean basic_integerp() {
        return true;
    }

    public Object toJava(String typeHint) {
        if (typeHint == null) {
            return this.toJava();
        }
        if (typeHint.equalsIgnoreCase("Double")) {
            return new Double(this.getDoubleValue());
        }
        if (typeHint.equalsIgnoreCase("Float")) {
            return new Float(this.getDoubleValue());
        }
        if (typeHint.equalsIgnoreCase("Integer")) {
            return new Integer((int)this.getLongValue());
        }
        if (typeHint.equalsIgnoreCase("Long")) {
            return new Long(this.getLongValue());
        }
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    public LispValue abs() {
        if (this.value.signum() > 0) {
            return this;
        }
        return new StandardLispBignum(this.f_lisp, this.value.negate());
    }

    public LispValue eql(LispValue val) {
        if (val instanceof LispBignum) {
            if (this.value.equals(((LispBignum)val).getBigIntegerValue())) {
                return this.f_lisp.T;
            }
            return this.f_lisp.NIL;
        }
        if (val instanceof LispInteger) {
            StandardLispBignum n = new StandardLispBignum(this.f_lisp, ((LispInteger)val).getLongValue());
            if (this.value.equals(n.getBigIntegerValue())) {
                return this.f_lisp.T;
            }
            return this.f_lisp.NIL;
        }
        if (val instanceof LispReal) {
            LispReal r = (LispReal)val;
            if ((double)StrictMath.round(r.getDoubleValue()) != r.getDoubleValue()) {
                return this.f_lisp.NIL;
            }
            StandardLispBignum n = new StandardLispBignum(this.f_lisp, r.getDoubleValue());
            if (this.value.equals(n.getBigIntegerValue())) {
                return this.f_lisp.T;
            }
            return this.f_lisp.NIL;
        }
        return super.eql(val);
    }

    public LispValue equal(LispValue val) {
        return this.eql(val);
    }

    public LispValue add(LispValue args) {
        BigInteger sum = this.value;
        while (args != this.f_lisp.NIL) {
            LispValue addend = args.car();
            if (addend.numberp() != this.f_lisp.T) {
                this.add(args.car());
                return this.f_lisp.NIL;
            }
            if (addend.floatp() == this.f_lisp.T) {
                LispReal realValue = this.f_lisp.makeReal(this.getDoubleValue());
                return realValue.add(args);
            }
            sum = addend instanceof LispBignum ? sum.add(((LispBignum)addend).getBigIntegerValue()) : sum.add(BigInteger.valueOf(((LispInteger)addend).getLongValue()));
            args = args.cdr();
        }
        if (sum.compareTo(LispBignum.MAXINT) <= 0 && sum.compareTo(LispBignum.MININT) >= 0) {
            return this.f_lisp.makeInteger(sum.longValue());
        }
        return this.f_lisp.makeBignum(sum);
    }

    public LispValue divide(LispValue args) {
        BigInteger quotient = this.getBigIntegerValue();
        int argCount = 1;
        while (args != this.f_lisp.NIL) {
            BigInteger[] quotientAndRem;
            BigInteger term_value;
            LispValue term = args.car();
            if (term.numberp() != this.f_lisp.T) {
                this.divide(args.car());
                return this.f_lisp.NIL;
            }
            ++argCount;
            if (term.floatp() == this.f_lisp.T) {
                LispReal realValue = this.f_lisp.makeReal(quotient.doubleValue());
                return realValue.divide(args);
            }
            if (!(term instanceof LispBignum)) {
                term = new StandardLispBignum(this.f_lisp, ((LispInteger)term).getLongValue());
            }
            if ((term_value = ((LispBignum)term).getBigIntegerValue()).compareTo(LispBignum.ZERO) != 0) {
                quotientAndRem = quotient.divideAndRemainder(term_value);
                if (quotientAndRem[1].compareTo(LispBignum.ZERO) != 0) {
                    return this.f_lisp.makeReal(quotient.doubleValue()).divide(args);
                }
            } else {
                System.out.print("\n;; *** ERROR: Attempt to divide by 0.\n");
                return this.f_lisp.NIL;
            }
            quotient = quotientAndRem[0];
            args = args.cdr();
        }
        if (argCount == 1) {
            if (quotient.compareTo(LispBignum.ZERO) != 0) {
                return this.f_lisp.makeReal(1.0 / quotient.doubleValue());
            }
            System.out.print("\n;; *** ERROR: Attempt to divide by 0.\n");
            return this.f_lisp.NIL;
        }
        if (quotient.compareTo(LispBignum.MAXINT) <= 0 && quotient.compareTo(LispBignum.MININT) >= 0) {
            return this.f_lisp.makeInteger(quotient.longValue());
        }
        return this.f_lisp.makeBignum(quotient);
    }

    public LispValue multiply(LispValue args) {
        BigInteger product = this.getBigIntegerValue();
        while (args != this.f_lisp.NIL) {
            LispValue term = args.car();
            if (term.numberp() != this.f_lisp.T) {
                super.multiply(args.car());
                return this.f_lisp.NIL;
            }
            if (term.floatp() == this.f_lisp.T) {
                LispReal realValue = this.f_lisp.makeReal(this.getDoubleValue());
                return realValue.multiply(args);
            }
            product = term instanceof LispBignum ? product.multiply(((LispBignum)term).getBigIntegerValue()) : product.multiply(BigInteger.valueOf(((LispInteger)term).getLongValue()));
            args = args.cdr();
        }
        if (product.compareTo(LispBignum.MAXINT) <= 0 && product.compareTo(LispBignum.MININT) >= 0) {
            return this.f_lisp.makeInteger(product.longValue());
        }
        return this.f_lisp.makeBignum(product);
    }

    public LispValue subtract(LispValue args) {
        BigInteger sum = this.value.negate();
        int argCount = 1;
        while (args != this.f_lisp.NIL) {
            LispValue term = args.car();
            if (term.numberp() != this.f_lisp.T) {
                this.subtract(args.car());
                return this.f_lisp.NIL;
            }
            if (term.floatp() == this.f_lisp.T) {
                LispReal realValue = this.f_lisp.makeReal(this.getDoubleValue());
                return realValue.subtract(args);
            }
            if (++argCount == 2) {
                sum = sum.negate();
            }
            sum = term instanceof LispBignum ? sum.subtract(((LispBignum)term).getBigIntegerValue()) : sum.subtract(BigInteger.valueOf(((LispInteger)term).getLongValue()));
            args = args.cdr();
        }
        if (sum.compareTo(LispBignum.MAXINT) <= 0 && sum.compareTo(LispBignum.MININT) >= 0) {
            return this.f_lisp.makeInteger(sum.longValue());
        }
        return this.f_lisp.makeBignum(sum);
    }

    public LispValue bignump() {
        return this.f_lisp.T;
    }

    public LispValue integerp() {
        return this.f_lisp.T;
    }

    public LispValue negate() {
        return new StandardLispBignum(this.f_lisp, this.value.negate());
    }

    public LispValue type_of() {
        return this.f_lisp.BIGNUM_TYPE;
    }

    public LispValue typep(LispValue type) {
        LispValue result = super.typep(type);
        if (result == this.f_lisp.T || type == this.f_lisp.BIGNUM_TYPE) {
            return this.f_lisp.T;
        }
        return this.f_lisp.NIL;
    }

    public LispValue zerop() {
        if (this.value.equals(LispBignum.ZERO)) {
            return this.f_lisp.T;
        }
        return this.f_lisp.NIL;
    }
}

