/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.jogl.impl;

import java.util.ArrayList;
import net.java.games.jogl.impl.GLContext;
import net.java.games.jogl.impl.GLContextInitActionPair;

public class GLContextStack {
    private ArrayList data = new ArrayList();

    public void push(GLContext gLContext, Runnable runnable) {
        if (gLContext == null) {
            throw new IllegalArgumentException("Null contexts are not allowed here");
        }
        this.data.add(new GLContextInitActionPair(gLContext, runnable));
    }

    public GLContextInitActionPair pop() {
        if (this.data.size() == 0) {
            return null;
        }
        return (GLContextInitActionPair)this.data.remove(this.data.size() - 1);
    }

    public GLContextInitActionPair peek() {
        return this.peek(0);
    }

    public GLContextInitActionPair peek(int n) {
        if (this.data.size() - n <= 0) {
            return null;
        }
        return (GLContextInitActionPair)this.data.get(this.data.size() - n - 1);
    }

    public GLContext peekContext() {
        return this.peekContext(0);
    }

    public GLContext peekContext(int n) {
        GLContextInitActionPair gLContextInitActionPair = this.peek(n);
        if (gLContextInitActionPair == null) {
            return null;
        }
        return gLContextInitActionPair.getContext();
    }

    public Runnable peekInitAction() {
        return this.peekInitAction(0);
    }

    public Runnable peekInitAction(int n) {
        GLContextInitActionPair gLContextInitActionPair = this.peek(n);
        if (gLContextInitActionPair == null) {
            return null;
        }
        return gLContextInitActionPair.getInitAction();
    }

    public int size() {
        return this.data.size();
    }
}

