/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.jogl.impl.x11;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class X11SunJDKReflection {
    private static Class x11GraphicsDeviceClass;
    private static Method x11GraphicsDeviceGetScreenMethod;
    private static Class x11GraphicsConfigClass;
    private static Method x11GraphicsConfigGetVisualMethod;
    private static boolean initted;

    public static int graphicsDeviceGetScreen(GraphicsDevice graphicsDevice) {
        if (!initted) {
            return 0;
        }
        try {
            return (Integer)x11GraphicsDeviceGetScreenMethod.invoke((Object)graphicsDevice, new Object[0]);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static int graphicsConfigurationGetVisualID(GraphicsConfiguration graphicsConfiguration) {
        if (!initted) {
            return 0;
        }
        try {
            return (Integer)x11GraphicsConfigGetVisualMethod.invoke((Object)graphicsConfiguration, new Object[0]);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    x11GraphicsDeviceClass = Class.forName("sun.awt.X11GraphicsDevice");
                    x11GraphicsDeviceGetScreenMethod = x11GraphicsDeviceClass.getDeclaredMethod("getScreen", new Class[0]);
                    x11GraphicsDeviceGetScreenMethod.setAccessible(true);
                    x11GraphicsConfigClass = Class.forName("sun.awt.X11GraphicsConfig");
                    x11GraphicsConfigGetVisualMethod = x11GraphicsConfigClass.getDeclaredMethod("getVisual", new Class[0]);
                    x11GraphicsConfigGetVisualMethod.setAccessible(true);
                    initted = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }
}

