/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.util;

import java.awt.geom.Point2D;
import org.jgraph.util.Spline;

public class Spline2D {
    private double[] t;
    private Spline splineX;
    private Spline splineY;
    private double length;

    public Spline2D(Point2D[] point2DArray) {
        double[] dArray = new double[point2DArray.length];
        double[] dArray2 = new double[point2DArray.length];
        int n = 0;
        while (n < point2DArray.length) {
            dArray[n] = point2DArray[n].getX();
            dArray2[n] = point2DArray[n].getY();
            ++n;
        }
        this.init(dArray, dArray2);
    }

    public Spline2D(double[] dArray, double[] dArray2) {
        this.init(dArray, dArray2);
    }

    private void init(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Arrays must have the same length.");
        }
        this.t = new double[dArray.length];
        int n = 0;
        while (n < this.t.length) {
            if (n == 0) {
                this.t[0] = 0.0;
            } else {
                double d = dArray[n] - dArray[n - 1];
                double d2 = dArray2[n] - dArray2[n - 1];
                this.t[n] = Math.sqrt(d * d + d2 * d2);
                this.length += this.t[n];
                int n2 = n;
                this.t[n2] = this.t[n2] + this.t[n - 1];
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < this.t.length) {
            this.t[n3] = this.t[n3] / this.length;
            ++n3;
        }
        this.splineX = new Spline(this.t, dArray);
        this.splineY = new Spline(this.t, dArray2);
    }

    public double[] getPoint(double d) {
        double[] dArray = new double[]{this.splineX.getValue(d), this.splineY.getValue(d)};
        return dArray;
    }

    public double getDx(double d) {
        return this.splineX.getDx(d);
    }

    public double getDy(double d) {
        return this.splineY.getDx(d);
    }

    public double getLength() {
        return this.length;
    }
}

