/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.taujava.popup.actions;

import edu.uoregon.tau.taujava.TaujavaPlugin;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class InstrumentJava
implements IObjectActionDelegate {
    private Vector fileEx;
    private Vector fileIn;
    private Vector nameEx;
    private Vector nameIn;
    IStructuredSelection selection;
    private String source;
    private ICompilationUnit carrier;

    private void exclusionSetup() {
        this.fileEx = new Vector();
        this.fileIn = new Vector();
        this.nameEx = new Vector();
        this.nameIn = new Vector();
        IPreferenceStore pstore = TaujavaPlugin.getDefault().getPreferenceStore();
        String result = pstore.getString("exclusionPathPreference");
        if (result == null) {
            result = "";
        }
        if (result == "" || !pstore.getBoolean("exclusionPreference")) {
            return;
        }
        try {
            BufferedReader in = new BufferedReader(new FileReader(result));
            String aline = "";
            while ((aline = in.readLine()) != null) {
                if (aline.length() == 0 || aline.charAt(0) == '#') continue;
                if (aline.equals("BEGIN_EXCLUDE_LIST")) {
                    while ((aline = in.readLine()) != null) {
                        if (aline.equals("END_EXCLUDE_LIST")) break;
                        if (aline.length() == 0 || aline.charAt(0) == '#') continue;
                        this.nameEx.add(aline);
                    }
                    if (aline == null) {
                        return;
                    }
                }
                if (aline.equals("BEGIN_INCLUDE_LIST")) {
                    while ((aline = in.readLine()) != null) {
                        if (aline.equals("END_INCLUDE_LIST")) break;
                        if (aline.length() == 0 || aline.charAt(0) == '#') continue;
                        this.nameIn.add(aline);
                    }
                    if (aline == null) {
                        return;
                    }
                }
                if (aline.equals("BEGIN_FILE_EXCLUDE_LIST")) {
                    while ((aline = in.readLine()) != null) {
                        if (aline.equals("END_FILE_EXCLUDE_LIST")) break;
                        if (aline.length() == 0 || aline.charAt(0) == '#') continue;
                        this.fileEx.add(aline);
                    }
                    if (aline == null) {
                        return;
                    }
                }
                if (!aline.equals("BEGIN_FILE_INCLUDE_LIST")) continue;
                while ((aline = in.readLine()) != null) {
                    if (aline.equals("END_FILE_INCLUDE_LIST")) break;
                    if (aline.length() == 0 || aline.charAt(0) == '#') continue;
                    this.fileIn.add(aline);
                }
                if (aline != null) continue;
                return;
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public int classPathSetup(IJavaElement element) throws JavaModelException {
        IClasspathEntry[] newpath;
        IPreferenceStore pstore = TaujavaPlugin.getDefault().getPreferenceStore();
        String path = pstore.getString("tauDirPathPreference");
        if (path == null) {
            path = "";
        }
        if (path.equals("")) {
            return 1;
        }
        path = String.valueOf(path) + "/TAU.jar";
        IJavaProject javaProj = element.getJavaProject();
        Path cp = new Path(path);
        if (!cp.toFile().exists()) {
            return 1;
        }
        IClasspathEntry cpe = JavaCore.newLibraryEntry((IPath)cp, null, null);
        IClasspathEntry[] oldpath = javaProj.getRawClasspath();
        int i = 0;
        while (i < oldpath.length) {
            if (oldpath[i].getPath().toString().equals(cpe.getPath().toString())) {
                return 0;
            }
            ++i;
        }
        if (oldpath == null) {
            newpath = new IClasspathEntry[]{cpe};
        } else {
            newpath = new IClasspathEntry[oldpath.length + 1];
            System.arraycopy(oldpath, 0, newpath, 0, oldpath.length);
            newpath[newpath.length - 1] = cpe;
        }
        javaProj.setRawClasspath(newpath, null);
        return 0;
    }

    public void run(IAction action) {
        if (this.selection == null) {
            return;
        }
        try {
            this.exclusionSetup();
            IJavaElement element = (IJavaElement)this.selection.getFirstElement();
            if (this.classPathSetup(element) != 0) {
                Shell shell = new Shell();
                MessageDialog.openInformation((Shell)shell, (String)"Taujava Plug-in", (String)"TAU.jar not found.  Please select a viable tau library directory.  Instrumentation aborted.");
                return;
            }
            if (element.getElementType() == 2) {
                IJavaProject jproject = (IJavaProject)element;
                this.instrumentProject(jproject);
            } else if (element.getElementType() == 4) {
                IPackageFragment jfragment = (IPackageFragment)element;
                this.instrumentPackage(jfragment);
            } else if (element.getElementType() == 5) {
                ICompilationUnit jfile = (ICompilationUnit)element;
                this.instrumentJava(jfile);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        catch (MalformedTreeException e) {
            e.printStackTrace();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void instrumentProject(IJavaProject jproject) throws JavaModelException, MalformedTreeException, BadLocationException, IOException {
        IPackageFragment[] fragments = jproject.getPackageFragments();
        int i = 0;
        while (i < fragments.length) {
            this.instrumentPackage(fragments[i]);
            ++i;
        }
    }

    public boolean wildSeek(String test, Vector elements, String wildcard) {
        System.out.println("Checking: " + test + " with wild: " + wildcard);
        int i = 0;
        while (i < elements.size()) {
            String regExHold = (String)elements.get(i);
            regExHold = regExHold.trim();
            System.out.println("Against: " + regExHold);
            if (!wildcard.equals("*")) {
                regExHold = regExHold.replaceAll("\\*", "\\\\*");
            }
            regExHold = regExHold.replaceAll("\\.", "\\\\.");
            regExHold = wildcard.equals("*") ? regExHold.replaceAll("\\*", ".*") : regExHold.replaceAll(wildcard, ".*");
            regExHold = regExHold.replaceAll("\\(", "\\\\(");
            regExHold = regExHold.replaceAll("\\)", "\\\\)");
            regExHold = regExHold.replaceAll("\\[", "\\\\[");
            regExHold = regExHold.replaceAll("\\]", "\\\\]");
            System.out.println(regExHold);
            if (Pattern.matches(regExHold, test)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void instrumentPackage(IPackageFragment jfragment) throws JavaModelException, MalformedTreeException, BadLocationException {
        int i;
        ICompilationUnit[] compunits = jfragment.getCompilationUnits();
        Vector<ICompilationUnit> use = new Vector<ICompilationUnit>();
        if (this.fileEx.size() > 0) {
            i = 0;
            while (i < compunits.length) {
                if (!this.wildSeek(compunits[i].getElementName(), this.fileEx, "*")) {
                    use.add(compunits[i]);
                }
                ++i;
            }
            compunits = use.toArray(compunits);
        } else if (this.fileIn.size() > 0) {
            i = 0;
            while (i < compunits.length) {
                if (this.wildSeek(compunits[i].getElementName(), this.fileIn, "*")) {
                    use.add(compunits[i]);
                }
                ++i;
            }
            compunits = use.toArray(compunits);
        }
        i = 0;
        while (i < compunits.length) {
            if (compunits[i] == null) break;
            this.instrumentJava(compunits[i]);
            ++i;
        }
    }

    public void instrumentJava(ICompilationUnit jfile) throws JavaModelException {
        ICompilationUnit workingjfile = jfile.getWorkingCopy(null);
        IType[] types = workingjfile.getTypes();
        String pack = "";
        IPackageDeclaration[] packs = workingjfile.getPackageDeclarations();
        if (packs.length != 0) {
            pack = packs[0].getElementName();
        }
        String name = workingjfile.getElementName();
        String idname = name = name.substring(0, name.lastIndexOf(46));
        if (pack != null) {
            idname = String.valueOf(pack) + "." + name;
        }
        int numtypes = types.length;
        this.source = workingjfile.getBuffer().getContents();
        this.carrier = workingjfile;
        int typedex = 0;
        int i = 0;
        while (i < numtypes) {
            if (types[i].isClass() && !types[i].isAnonymous()) {
                this.instrumentClass(types[i], name, idname, 0, typedex);
                ++typedex;
                types = this.carrier.getTypes();
            }
            ++i;
        }
        workingjfile.commitWorkingCopy(true, null);
        jfile.save(null, true);
    }

    public void instrumentClass(IType type, String finame, String idname, int depth, int order) throws JavaModelException {
        IType[] types = type.getTypes();
        String usename = String.valueOf(finame) + "_" + type.getElementName();
        String useidname = String.valueOf(idname) + "." + type.getElementName();
        int numtypes = types.length;
        int typedex = 0;
        int i = 0;
        while (i < numtypes) {
            if (types[i].isClass() && !types[i].isAnonymous()) {
                this.instrumentClass(types[i], usename, useidname, depth + 1, typedex);
                type = this.carrier.getType(type.getElementName());
                types = type.getTypes();
                ++typedex;
            }
            ++i;
        }
        Vector<String> rootline = new Vector<String>();
        int openbrack = 0;
        if (depth == 0) {
            int start = type.getSourceRange().getOffset();
            openbrack = this.indexSansComments(this.source, "{", start);
        } else {
            IType rooter = type;
            rootline.add(0, rooter.getElementName());
            int i2 = depth;
            while (i2 > 0) {
                rooter = (IType)rooter.getParent();
                rootline.add(0, rooter.getElementName());
                --i2;
            }
            int start = rooter.getSourceRange().getOffset();
            openbrack = this.indexSansComments(this.source, "{", start);
        }
        IMethod[] methods = type.getMethods();
        int nummeths = methods.length;
        int mdex = 0;
        String tauinit = "\n/*TAU_INSTRUMENTATION - Do not edit between these comments.*/  static TAU.Profile[] " + usename + "Profiles = {";
        String methdef = "";
        int i3 = 0;
        while (i3 < nummeths) {
            methdef = String.valueOf(Signature.toString((String)methods[i3].getReturnType())) + " " + useidname + "." + methods[i3].getElementName().toString() + "(";
            String[] parn = methods[i3].getParameterNames();
            String[] part = methods[i3].getParameterTypes();
            int j = 0;
            while (j < parn.length) {
                if (j > 0) {
                    methdef = String.valueOf(methdef) + ", ";
                }
                methdef = String.valueOf(methdef) + Signature.toString((String)part[j]) + " " + parn[j];
                ++j;
            }
            methdef = String.valueOf(methdef) + ")";
            if (this.nameIn.size() == 0 && this.nameEx.size() == 0 || this.nameIn.size() > 0 && this.wildSeek(methdef, this.nameIn, "#") || this.nameEx.size() > 0 && !this.wildSeek(methdef, this.nameEx, "#")) {
                this.instrumentMethod(methods[i3], usename, mdex);
                if (rootline.size() > 0) {
                    type = this.carrier.getType((String)rootline.firstElement());
                    j = 1;
                    while (j < rootline.size()) {
                        type = type.getType((String)rootline.get(j));
                        ++j;
                    }
                } else {
                    type = this.carrier.getType(type.getElementName());
                }
                methods = type.getMethods();
                if (mdex > 0) {
                    tauinit = String.valueOf(tauinit) + ",";
                }
                tauinit = String.valueOf(tauinit) + " new TAU.Profile(\"" + methdef;
                tauinit = String.valueOf(tauinit) + "\", \"\", \"TAU_DEFAULT\", TAU.Profile.TAU_DEFAULT)";
                ++mdex;
            }
            ++i3;
        }
        tauinit = String.valueOf(tauinit) + "};/*TAU_INSTRUMENTATION - Do not edit between these comments.*/\n";
        this.source = String.valueOf(this.source.substring(0, openbrack + 1)) + tauinit + this.source.substring(openbrack + 1);
        this.carrier.getBuffer().setContents(this.source);
        this.carrier.makeConsistent(null);
    }

    public void instrumentMethod(IMethod method, String type, int order) throws JavaModelException {
        int closebrack;
        String msource = method.getSource();
        String tryadd = "\n/*TAU_INSTRUMENTATION - Do not edit between these comments.*/try{" + type + "Profiles[" + order + "].Start();/*TAU_INSTRUMENTATION - Do not edit between these comments.*/\n";
        int openbrack = this.indexSansComments(msource, "{", 0);
        if (openbrack == -1) {
            return;
        }
        if (method.isConstructor()) {
            int oparen;
            int fstsmc = this.indexSansComments(msource, ";", openbrack);
            if (fstsmc == -1) {
                return;
            }
            String clip = msource.substring(openbrack, fstsmc);
            int dexmod = 0;
            int condex = this.indexSansComments(clip, "super", 0);
            if (condex != -1) {
                dexmod = 5;
            } else {
                condex = this.indexSansComments(clip, "this", 0);
                dexmod = 4;
            }
            if (condex != -1 && (oparen = clip.indexOf(40, condex)) != -1 && clip.substring(condex + dexmod, oparen).trim().length() == 0) {
                openbrack = fstsmc;
            }
        }
        if ((closebrack = (msource = String.valueOf(msource.substring(0, openbrack + 1)) + tryadd + msource.substring(openbrack + 1)).lastIndexOf(125)) < 0) {
            System.out.println("BUG!");
            System.out.println(msource);
            return;
        }
        String finadd = "\n/*TAU_INSTRUMENTATION - Do not edit between these comments.*/}finally{" + type + "Profiles[" + order + "].Stop();}/*TAU_INSTRUMENTATION - Do not edit between these comments.*/\n";
        msource = String.valueOf(msource.substring(0, closebrack)) + finadd + msource.substring(closebrack);
        int mstart = method.getSourceRange().getOffset();
        int mend = mstart + method.getSourceRange().getLength();
        this.source = String.valueOf(this.source.substring(0, mstart)) + msource + this.source.substring(mend);
        this.carrier.getBuffer().setContents(this.source);
        this.carrier.makeConsistent(null);
    }

    private boolean inLineCom(String input, int index) {
        int lastret = input.lastIndexOf(10, index);
        int lastcom = input.lastIndexOf("//", index);
        if (lastcom == -1) {
            return false;
        }
        return lastret < lastcom;
    }

    /*
     * Unable to fully structure code
     */
    private boolean inBlockCom(String input, int index) {
        lastend = input.lastIndexOf("*/", index);
        lastcom = input.lastIndexOf("/*", index);
        if (lastcom != -1) ** GOTO lbl7
        return false;
lbl-1000:
        // 1 sources

        {
            if ((lastcom = input.lastIndexOf("/*", lastcom - 1)) != -1) continue;
            return false;
lbl7:
            // 2 sources

            ** while (this.inLineCom((String)input, (int)lastcom))
        }
lbl8:
        // 1 sources

        return lastend < lastcom;
    }

    /*
     * Unable to fully structure code
     */
    private int indexSansComments(String input, String find, int startdex) {
        seeker = input.indexOf(find, startdex);
        if (seeker != -1) ** GOTO lbl6
        return seeker;
lbl-1000:
        // 1 sources

        {
            if ((seeker = input.indexOf(find, seeker + 1)) != -1) continue;
            return seeker;
lbl6:
            // 2 sources

            ** while (this.inLineCom((String)input, (int)seeker) || this.inBlockCom((String)input, (int)seeker))
        }
lbl7:
        // 1 sources

        return seeker;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null;
    }
}

