/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.Edge;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.PortView;

public class DefaultEdge
extends DefaultGraphCell
implements Edge {
    protected Object source;
    protected Object target;

    public DefaultEdge() {
        this(null);
    }

    public DefaultEdge(Object object) {
        this(object, true);
    }

    public DefaultEdge(Object object, boolean bl) {
        super(object, bl);
        this.checkDefaults();
    }

    protected void checkDefaults() {
        Cloneable cloneable;
        List list = GraphConstants.getPoints(this.attributes);
        if (list == null) {
            cloneable = new ArrayList();
            cloneable.add(this.getAttributes().createPoint(10.0, 10.0));
            cloneable.add(this.getAttributes().createPoint(20.0, 20.0));
            GraphConstants.setPoints(this.attributes, (List)((Object)cloneable));
        }
        if ((cloneable = GraphConstants.getLabelPosition(this.attributes)) == null) {
            int n = 500;
            cloneable = new Point(n, n);
            GraphConstants.setLabelPosition(this.attributes, (Point)cloneable);
        }
    }

    public Map changeAttributes(Map map) {
        Map map2 = super.changeAttributes(map);
        this.checkDefaults();
        return map2;
    }

    public Object getSource() {
        return this.source;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setSource(Object object) {
        this.source = object;
    }

    public void setTarget(Object object) {
        this.target = object;
    }

    public Object clone() {
        DefaultEdge defaultEdge = (DefaultEdge)super.clone();
        defaultEdge.source = null;
        defaultEdge.target = null;
        return defaultEdge;
    }

    public static class DefaultRouting
    implements Edge.Routing {
        public int selfReferenceSize = 10;

        public void route(EdgeView edgeView, List list) {
            Point2D[] point2DArray;
            Cloneable cloneable;
            int n = list.size();
            Point2D point2D = edgeView.getPoint(0);
            if (edgeView.getSource() instanceof PortView) {
                point2D = ((PortView)edgeView.getSource()).getLocation(null);
            } else if (edgeView.getSource() != null) {
                cloneable = edgeView.getSource().getBounds();
                point2D = edgeView.getAttributes().createPoint(((RectangularShape)cloneable).getCenterX(), ((RectangularShape)cloneable).getCenterY());
            }
            cloneable = edgeView.getPoint(n - 1);
            if (edgeView.getTarget() instanceof PortView) {
                cloneable = ((PortView)edgeView.getTarget()).getLocation(null);
            } else if (edgeView.getTarget() != null) {
                point2DArray = edgeView.getTarget().getBounds();
                cloneable = edgeView.getAttributes().createPoint(point2DArray.getCenterX(), point2DArray.getCenterY());
            }
            if (point2D != null && cloneable != null) {
                if (edgeView.getSource() == edgeView.getTarget() && edgeView.getSource() != null) {
                    Rectangle2D rectangle2D = edgeView.getSource().getParentView().getBounds();
                    double d = this.selfReferenceSize;
                    double d2 = rectangle2D.getWidth() / 3.0;
                    point2DArray = new Point2D[]{edgeView.getAttributes().createPoint(rectangle2D.getX() + d2, rectangle2D.getY() + rectangle2D.getHeight()), edgeView.getAttributes().createPoint(rectangle2D.getX() + d2, rectangle2D.getY() + rectangle2D.getHeight() + d), edgeView.getAttributes().createPoint(rectangle2D.getX() + 2.0 * d2, rectangle2D.getY() + rectangle2D.getHeight() + d), edgeView.getAttributes().createPoint(rectangle2D.getX() + 2.0 * d2, rectangle2D.getY() + rectangle2D.getHeight())};
                } else {
                    double d = Math.abs(point2D.getX() - ((Point2D)cloneable).getX());
                    double d3 = Math.abs(point2D.getY() - ((Point2D)cloneable).getY());
                    double d4 = point2D.getX() + (((Point2D)cloneable).getX() - point2D.getX()) / 2.0;
                    double d5 = point2D.getY() + (((Point2D)cloneable).getY() - point2D.getY()) / 2.0;
                    point2DArray = new Point2D[2];
                    if (d > d3) {
                        point2DArray[0] = edgeView.getAttributes().createPoint(d4, point2D.getY());
                        point2DArray[1] = edgeView.getAttributes().createPoint(d4, ((Point2D)cloneable).getY());
                    } else {
                        point2DArray[0] = edgeView.getAttributes().createPoint(point2D.getX(), d5);
                        point2DArray[1] = edgeView.getAttributes().createPoint(((Point2D)cloneable).getX(), d5);
                    }
                }
                for (int i = 0; i < point2DArray.length; ++i) {
                    if (list.size() > i + 2) {
                        list.set(i + 1, point2DArray[i]);
                        continue;
                    }
                    list.add(i + 1, point2DArray[i]);
                }
                while (list.size() > point2DArray.length + 2) {
                    list.remove(list.size() - 2);
                }
            }
        }
    }
}

