package edu.uoregon.tau.taucdt.popup.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
//import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.window.Window;
//import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.managedbuilder.core.*;
//import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
//import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.core.model.ICProject;
//import org.eclipse.debug.core.ILaunchConfiguration;
//import org.eclipse.debug.ui.DebugUITools;
//import org.eclipse.debug.ui.IDebugModelPresentation;

import edu.uoregon.tau.taucdt.TaucdtPlugin;
public class TauConfCDT implements IObjectActionDelegate {

	/**
	 * Constructor for Action1.
	 */
	public TauConfCDT() {
		super();
	}
	/*The selected object*/
	IStructuredSelection selection;
	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		try{
		if(selection==null)return;
		//Produce the associated compilation unit and send it to launcher
		ICProject project = (ICProject) selection.getFirstElement();
		if (project == null){
			System.out.println("No project!");
			return;
		}
		if(!ManagedBuildManager.canGetBuildInfo(project.getResource()))
			{	
				Shell shell = new Shell();
				MessageDialog.openError(shell,
						"Taucdt Plug-in",
						"The TAU CDT Plugin only supports managed-make projects at this time");
				return;
			}
		IManagedBuildInfo info = ManagedBuildManager.getBuildInfo(project.getResource());
		if (info == null||!info.isValid()){
			System.out.println("No info!");
			return;
		}
		IManagedProject managedProj = info.getManagedProject();
		if (managedProj == null){
			System.out.println("No managed project!");
			return;
		}
		
		IConfiguration[] configs = info.getManagedProject().getConfigurations();
		List configlist = Collections.EMPTY_LIST;
		configlist = new ArrayList(configs.length);
		for(int i=0;i<configs.length;i++){
			configlist.add(configs[i]);
		}
		IConfiguration selectedconf=chooseBuildConfiguration(configlist);
		//if(selectedconf==null)return;
		
		
		//IConfiguration selectedconf = ManagedBuildManager.getSelectedConfiguration(project.getProject());
		if(selectedconf==null)
		{System.out.println("No Conf Selected");return;}
		if(selectedconf.getName()==null)
		{System.out.println("Uh Oh!");return;}
		
		IPreferenceStore pstore = TaucdtPlugin.getDefault().getPreferenceStore();
		String tbpath = pstore.getString("TAUCDTArchPath")+File.separator+"bin";
		
		String tmakepath = pstore.getString("makeCombo");
		if((tmakepath==null)||tmakepath.equals("Manual Spec")||tmakepath.equals(""))
			tmakepath=pstore.getString("TAUCDTMakefile");
			
		String tauoptchunk="";
		String tauopts = pstore.getString("TAUCDTOpts");
		if(!tauopts.equals("")){
			tauoptchunk=" -tau_options='"+tauopts+"'";
		}
		//System.out.println("TOC: "+tauoptchunk);
		String newname = selectedconf.getName()+("("+tmakepath.substring(tmakepath.lastIndexOf(".")+1)+")");
		//if(managedProj.getConfiguration(newname)!=null)
		
			IConfiguration[] confs = managedProj.getConfigurations();
			
			//int namecount = 1;
			for(int i =0; i<confs.length;i++)
			{
				if(confs[i].getName().equals(newname))
				{
					managedProj.removeConfiguration(confs[i].getId());
				}
			}
		
		//Clone works, basic create does not
		IConfiguration newConfig = managedProj.createConfigurationClone(
				selectedconf, selectedconf.getId()+"."+ManagedBuildManager.getRandomNumber());
		//managedProj.getConfiguration("Release")
		//managedProj.create
		if (newConfig == null){
			System.out.println("No config!");
			return;
		}
		newConfig.setName(newname);
		IToolChain chain = newConfig.getToolChain();
		
		//IConfigurationEnvironmentVariableSupplier envs = chain.getEnvironmentVariableSupplier();
		//IBuildEnvironmentVariable[] vars = 
		//envs.getVariables(newConfig,ManagedBuildManager.getEnvironmentVariableProvider());
		//vars[0].
		
		ITool[] tools = chain.getTools();
		//chain.
		//System.out.println("NumTools: "+tools.length);

		for(int i =0;i<tools.length;i++){
			//System.out.println(tools[i].getId()+" "+tools[i].getToolCommand()+" "+ tools[i].getCommandLinePattern()+"\n");
//			IOption[] topts = tools[i].getOptions();
			/*for(int j = 0; j<topts.length;j++)
			{System.out.println(topts[j].getName());}*/
			//System.out.println(tmakepath);
			if(tools[i].getToolCommand().equals("gcc"))
			{
				tools[i].setToolCommand(
						tbpath+File.separator+"tau_cc.sh"+" -tau_makefile="+tmakepath+tauoptchunk);
			}
			if(tools[i].getToolCommand().equals("g++"))
			{
				tools[i].setToolCommand(
						tbpath+File.separator+"tau_cxx.sh"+" -tau_makefile="+tmakepath+tauoptchunk);
			}
			if(tools[i].getToolCommand().equals("gfortran"))
			{
				tools[i].setToolCommand(
						tbpath+File.separator+"tau_f90.sh"+" -tau_makefile="+tmakepath+tauoptchunk);
			}
		}
		ManagedBuildManager.saveBuildInfo(project.getProject(),true);
		ManagedBuildManager.setDefaultConfiguration(project.getProject(),newConfig);
		}catch (Exception e){e.printStackTrace();}
	}
	
	private class IConfLP extends LabelProvider{


		public String getText(Object element) {
			// TODO Auto-generated method stub
			return ((IConfiguration)element).toString();
		}
	
	}
	
	protected IConfiguration chooseBuildConfiguration(List configList) {
		//IDebugModelPresentation labelProvider = new IConfLP();//DebugUITools.newDebugModelPresentation();
		//DebugUITools.new
		ILabelProvider labelProvider=new IConfLP();
		ElementListSelectionDialog dialog = new ElementListSelectionDialog(getShell(), labelProvider);
		/*String names[]=new String[configList.size()];
		for(int i=0;i<names.length;i++){
			names[i]=((IConfiguration)configList.get(i)).getName();
			System.out.println(names[i]);
		}*/
		dialog.setElements(configList.toArray());
		dialog.setTitle("Build Configuarion Selection");
		dialog.setMessage("Select a build configuration for TAU");
		//dialog.setTitle(getLaunchSelectionDialogTitleString(configList, mode)); 
		//dialog.setMessage(getLaunchSelectionDialogMessageString(configList, mode)); 
		dialog.setMultipleSelection(false);
		int result = dialog.open();
		labelProvider.dispose();
		if (result == Window.OK) {
			return (IConfiguration) dialog.getFirstResult();
		}
		return null;
	}
	protected Shell getShell() {
		return LaunchUIPlugin.getActiveWorkbenchShell();
	}
	
	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		if (selection instanceof IStructuredSelection)
			this.selection = (IStructuredSelection) selection;
		else
		{	//if the selection is invalid, stop
			this.selection = null;
			System.out.println("Invalid Selection");
		}
	}
}


