
#include "mysql.h"
#include "sql-interface.h"

const int maxResults = 16;

class Sql_mysql:public Sql_interface {
 private:
	MYSQL mysql;
	MYSQL_RES *results[maxResults];
	MYSQL_ROW row;
	int   connected;

	// Look for and return the next free result handle.
	int      getFreeResultHandle();

	char errormsg[255];

 public:
	Sql_mysql();
	Sql_mysql(int argc, char** argv);
	~Sql_mysql();

	int      connect(int argc, char **argv);
	int      isConnected()     { return connected; }
	int      selectdb(char *dbname);
	int      exec(char *cmd);
	int      query(char *cmd);
	int      numRows(int resHandle=0);
	void     endquery(int resHandle=0);
	Sql_row *fetchrow(int resHandle=0);

	char    *getErrorMsg();
};
