/*   -*- buffer-read-only: t -*- vi: set ro:
 *  
 *  DO NOT EDIT THIS FILE   (tcprewrite_opts.c)
 *  
 *  It has been AutoGen-ed  Thursday July 28, 2005 at 09:57:17 PM PDT
 *  From the definitions    tcprewrite_opts.def
 *  and the template file   options
 */
#include <stdio.h>
#include <limits.h>
#define OPTION_CODE_COMPILE 1
#include "tcprewrite_opts.h"

#ifdef  __cplusplus
extern "C" {
#endif
tSCC zCopyright[] =
       "tcprewrite copyright (c) 2004-2005 Aaron Turner, all rights reserved";
tSCC zCopyrightNotice[] =
       "tcprewrite is free software copyrighted by Aaron Turner.\n\n\
Redistribution and use in source and binary forms, with or without\n\
modification, are permitted provided that the following conditions\n\
are met:\n\
1. Redistributions of source code must retain the above copyright\n\
   notice, this list of conditions and the following disclaimer.\n\
2. Redistributions in binary form must reproduce the above copyright\n\
   notice, this list of conditions and the following disclaimer in the\n\
   documentation and/or other materials provided with the distribution.\n\
3. Neither the name ``Aaron Turner'' nor the name of any other\n\
   contributor may be used to endorse or promote products derived\n\
   from this software without specific prior written permission.\n\n\
tcprewrite IS PROVIDED BY Aaron Turner ``AS IS'' AND ANY EXPRESS\n\
OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\n\
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE\n\
ARE DISCLAIMED.  IN NO EVENT SHALL Aaron Turner OR ANY OTHER CONTRIBUTORS\n\
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR\n\
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF\n\
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR\n\
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,\n\
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR\n\
OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF\n\
ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
extern tUsageProc optionUsage;

/*
 *  global included definitions
 */
#include "defines.h"
#include "common.h"
#include "tcprewrite.h"
#include "mac.h"
extern char pcap_version[];
extern tcprewrite_opt_t options;


#ifndef NULL
#  define NULL 0
#endif
#ifndef EXIT_SUCCESS
#  define  EXIT_SUCCESS 0
#endif
#ifndef EXIT_FAILURE
#  define  EXIT_FAILURE 1
#endif
/*
 *  Dbug option description:
 */
tSCC    zDbugText[] =
        "Enable debugging output";
tSCC    zDbug_NAME[]               = "DBUG";
tSCC    zDbug_Name[]               = "dbug";
#define zDbugDefaultArg              ((tCC*)0)
#define DBUG_FLAGS       (OPTST_DISABLED \
	| OPTST_SET_ARGTYPE(OPARG_TYPE_NUMERIC))

/*
 *  Dmac option description:
 */
tSCC    zDmacText[] =
        "Rewrite destination MAC addresses";
tSCC    zDmac_NAME[]               = "DMAC";
tSCC    zDmac_Name[]               = "dmac";
#define DMAC_FLAGS       (OPTST_DISABLED \
	| OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Smac option description:
 */
tSCC    zSmacText[] =
        "Rewrite source MAC addresses";
tSCC    zSmac_NAME[]               = "SMAC";
tSCC    zSmac_Name[]               = "smac";
#define SMAC_FLAGS       (OPTST_DISABLED \
	| OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Proto option description:
 */
tSCC    zProtoText[] =
        "Override L2 protocol type for DLT_RAW";
tSCC    zProto_NAME[]              = "PROTO";
tSCC    zProto_Name[]              = "proto";
#define PROTO_FLAGS       (OPTST_DISABLED \
	| OPTST_SET_ARGTYPE(OPARG_TYPE_NUMERIC))

/*
 *  Dlink option description:
 */
tSCC    zDlinkText[] =
        "Rewrite Data-Link layer with specified data";
tSCC    zDlink_NAME[]              = "DLINK";
tSCC    zDlink_Name[]              = "dlink";
#define DLINK_FLAGS       (OPTST_DISABLED \
	| OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Portmap option description:
 */
tSCC    zPortmapText[] =
        "Rewrite TCP/UDP ports";
tSCC    zPortmap_NAME[]            = "PORTMAP";
tSCC    zPortmap_Name[]            = "portmap";
#define PORTMAP_FLAGS       (OPTST_DISABLED \
	| OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Seed option description:
 */
tSCC    zSeedText[] =
        "Randomize src/dst IP addresses w/ given seed";
tSCC    zSeed_NAME[]               = "SEED";
tSCC    zSeed_Name[]               = "seed";
#define SEED_FLAGS       (OPTST_DISABLED \
	| OPTST_SET_ARGTYPE(OPARG_TYPE_NUMERIC))

/*
 *  Pnat option description:
 */
tSCC    zPnatText[] =
        "Rewrite IP addresses using pseudo-NAT";
tSCC    zPnat_NAME[]               = "PNAT";
tSCC    zPnat_Name[]               = "pnat";
#define PNAT_FLAGS       (OPTST_DISABLED \
	| OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Endpoints option description:
 */
tSCC    zEndpointsText[] =
        "Rewrite IP addresses to be between two endpoints";
tSCC    zEndpoints_NAME[]          = "ENDPOINTS";
tSCC    zEndpoints_Name[]          = "endpoints";
#define ENDPOINTS_FLAGS       (OPTST_DISABLED \
	| OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Fixcsum option description:
 */
tSCC    zFixcsumText[] =
        "Force recalculation of IP/TCP/UDP checksums";
tSCC    zFixcsum_NAME[]            = "FIXCSUM";
tSCC    zFixcsum_Name[]            = "fixcsum";
#define FIXCSUM_FLAGS       (OPTST_DISABLED)

/*
 *  Infile option description:
 */
tSCC    zInfileText[] =
        "Input pcap file to be processed";
tSCC    zInfile_NAME[]             = "INFILE";
tSCC    zInfile_Name[]             = "infile";
#define INFILE_FLAGS       (OPTST_DISABLED | OPTST_MUST_SET \
	| OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Outfile option description:
 */
tSCC    zOutfileText[] =
        "Output pcap file";
tSCC    zOutfile_NAME[]            = "OUTFILE";
tSCC    zOutfile_Name[]            = "outfile";
#define OUTFILE_FLAGS       (OPTST_DISABLED | OPTST_MUST_SET \
	| OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Cachefile option description:
 */
tSCC    zCachefileText[] =
        "Split traffic via tcpprep cache file";
tSCC    zCachefile_NAME[]          = "CACHEFILE";
tSCC    zCachefile_Name[]          = "cachefile";
#define CACHEFILE_FLAGS       (OPTST_DISABLED \
	| OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Mtu option description:
 */
tSCC    zMtuText[] =
        "Override default MTU length (1500 bytes)";
tSCC    zMtu_NAME[]                = "MTU";
tSCC    zMtu_Name[]                = "mtu";
#define MTU_FLAGS       (OPTST_DISABLED \
	| OPTST_SET_ARGTYPE(OPARG_TYPE_NUMERIC))

/*
 *  Efcs option description:
 */
tSCC    zEfcsText[] =
        "Remove Ethernet checksums (FCS) from end of frames";
tSCC    zEfcs_NAME[]               = "EFCS";
tSCC    zEfcs_Name[]               = "efcs";
#define EFCS_FLAGS       (OPTST_DISABLED)

/*
 *  Fixlen option description:
 */
tSCC    zFixlenText[] =
        "Pad or truncate packet data to match header length";
tSCC    zFixlen_NAME[]             = "FIXLEN";
tSCC    zFixlen_Name[]             = "fixlen";
#define FIXLEN_FLAGS       (OPTST_DISABLED \
	| OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Vlan option description:
 */
tSCC    zVlanText[] =
        "Specify 802.1q VLAN tag mode";
tSCC    zVlan_NAME[]               = "VLAN";
tSCC    zVlan_Name[]               = "vlan";
#define VLAN_FLAGS       (OPTST_DISABLED \
	| OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Vlan_Tag option description with
 *  "Must also have options" and "Incompatible options":
 */
tSCC    zVlan_TagText[] =
        "Specify the new 802.1q VLAN tag value";
tSCC    zVlan_Tag_NAME[]           = "VLAN_TAG";
tSCC    zVlan_Tag_Name[]           = "vlan-tag";
static const int
    aVlan_TagMustList[] = {
    INDEX_OPT_VLAN, NO_EQUIVALENT };
#define VLAN_TAG_FLAGS       (OPTST_DISABLED \
	| OPTST_SET_ARGTYPE(OPARG_TYPE_NUMERIC))

/*
 *  Vlan_Cfi option description with
 *  "Must also have options" and "Incompatible options":
 */
tSCC    zVlan_CfiText[] =
        "Specify the 802.1q VLAN CFI value";
tSCC    zVlan_Cfi_NAME[]           = "VLAN_CFI";
tSCC    zVlan_Cfi_Name[]           = "vlan-cfi";
static const int
    aVlan_CfiMustList[] = {
    INDEX_OPT_VLAN, NO_EQUIVALENT };
#define VLAN_CFI_FLAGS       (OPTST_DISABLED \
	| OPTST_SET_ARGTYPE(OPARG_TYPE_NUMERIC))

/*
 *  Vlan_Pri option description with
 *  "Must also have options" and "Incompatible options":
 */
tSCC    zVlan_PriText[] =
        "Specify the 802.1q VLAN priority";
tSCC    zVlan_Pri_NAME[]           = "VLAN_PRI";
tSCC    zVlan_Pri_Name[]           = "vlan-pri";
static const int
    aVlan_PriMustList[] = {
    INDEX_OPT_VLAN, NO_EQUIVALENT };
#define VLAN_PRI_FLAGS       (OPTST_DISABLED \
	| OPTST_SET_ARGTYPE(OPARG_TYPE_NUMERIC))

/*
 *  Verbose option description:
 */
#ifdef HAVE_TCPDUMP
tSCC    zVerboseText[] =
        "Print decoded packets via tcpdump to STDOUT";
tSCC    zVerbose_NAME[]            = "VERBOSE";
tSCC    zVerbose_Name[]            = "verbose";
#define VERBOSE_FLAGS       (OPTST_DISABLED)

#else   /* disable Verbose */
#define VALUE_OPT_VERBOSE NO_EQUIVALENT
#define VERBOSE_FLAGS       (OPTST_OMITTED | OPTST_NO_INIT)
#define zVerboseText       NULL
#define zVerbose_NAME      NULL
#define zVerbose_Name      NULL
#endif  /* HAVE_TCPDUMP */

/*
 *  Decode option description with
 *  "Must also have options" and "Incompatible options":
 */
#ifdef HAVE_TCPDUMP
tSCC    zDecodeText[] =
        "Arguments passed to tcpdump decoder";
tSCC    zDecode_NAME[]             = "DECODE";
tSCC    zDecode_Name[]             = "decode";
static const int
    aDecodeMustList[] = {
    INDEX_OPT_VERBOSE, NO_EQUIVALENT };
#define DECODE_FLAGS       (OPTST_DISABLED \
	| OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

#else   /* disable Decode */
#define VALUE_OPT_DECODE NO_EQUIVALENT
#define DECODE_FLAGS       (OPTST_OMITTED | OPTST_NO_INIT)
#define aDecodeMustList   NULL
#define zDecodeText       NULL
#define zDecode_NAME      NULL
#define zDecode_Name      NULL
#endif  /* HAVE_TCPDUMP */

/*
 *  Version option description:
 */
tSCC    zVersionText[] =
        "Print version information";
tSCC    zVersion_NAME[]            = "VERSION";
tSCC    zVersion_Name[]            = "version";
#define VERSION_FLAGS       (OPTST_DISABLED)

/*
 *  Less_Help option description:
 */
tSCC    zLess_HelpText[] =
        "Display less usage information and exit";
tSCC    zLess_Help_NAME[]          = "LESS_HELP";
tSCC    zLess_Help_Name[]          = "less-help";
#define LESS_HELP_FLAGS       (OPTST_DISABLED)

/*
 *  Help/More_Help option descriptions:
 */
tSCC zHelpText[]       = "Display usage information and exit";
tSCC zHelp_Name[]      = "help";

tSCC zMore_HelpText[]  = "Extended usage information passed thru pager";
tSCC zMore_Help_Name[] = "more-help";

/*
 *  Save/Load_Opts option description:
 */
tSCC zSave_OptsText[]     = "Save the option state to a config file";
tSCC zSave_Opts_Name[]    = "save-opts";

tSCC zLoad_OptsText[]     = "Load options from a config file";
tSCC zLoad_Opts_NAME[]    = "LOAD_OPTS";

tSCC zNotLoad_Opts_Name[] = "no-load-opts";
tSCC zNotLoad_Opts_Pfx[]  = "no";
#define zLoad_Opts_Name   (zNotLoad_Opts_Name + 3)
/*
 *  Declare option callback procedures
 */
extern tOptProc
    optionNumericVal, optionPagedUsage;
static tOptProc
    doOptCachefile, doOptDbug,      doOptDlink,     doOptDmac,
    doOptEfcs,      doOptFixcsum,   doOptFixlen,    doOptInfile,
    doOptLess_Help, doOptMtu,       doOptPnat,      doOptPortmap,
    doOptProto,     doOptSmac,      doOptVersion,   doOptVlan,
    doOptVlan_Cfi,  doOptVlan_Pri,  doOptVlan_Tag,  doUsageOpt;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Define the Tcprewrite Option Descriptions.
 */
static tOptDesc optDesc[ OPTION_CT ] = {
  {  /* entry idx, value */ 0, VALUE_OPT_DBUG,
     /* equiv idx, value */ 0, VALUE_OPT_DBUG,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ DBUG_FLAGS, 0,
     /* last opt argumnt */ zDbugDefaultArg,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptDbug,
     /* desc, NAME, name */ zDbugText, zDbug_NAME, zDbug_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 1, VALUE_OPT_DMAC,
     /* equiv idx, value */ 1, VALUE_OPT_DMAC,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ DMAC_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptDmac,
     /* desc, NAME, name */ zDmacText, zDmac_NAME, zDmac_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 2, VALUE_OPT_SMAC,
     /* equiv idx, value */ 2, VALUE_OPT_SMAC,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ SMAC_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptSmac,
     /* desc, NAME, name */ zSmacText, zSmac_NAME, zSmac_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 3, VALUE_OPT_PROTO,
     /* equiv idx, value */ 3, VALUE_OPT_PROTO,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ PROTO_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptProto,
     /* desc, NAME, name */ zProtoText, zProto_NAME, zProto_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 4, VALUE_OPT_DLINK,
     /* equiv idx, value */ 4, VALUE_OPT_DLINK,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 2, 0,
     /* opt state flags  */ DLINK_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptDlink,
     /* desc, NAME, name */ zDlinkText, zDlink_NAME, zDlink_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 5, VALUE_OPT_PORTMAP,
     /* equiv idx, value */ 5, VALUE_OPT_PORTMAP,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ PORTMAP_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptPortmap,
     /* desc, NAME, name */ zPortmapText, zPortmap_NAME, zPortmap_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 6, VALUE_OPT_SEED,
     /* equiv idx, value */ 6, VALUE_OPT_SEED,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ SEED_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ optionNumericVal,
     /* desc, NAME, name */ zSeedText, zSeed_NAME, zSeed_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 7, VALUE_OPT_PNAT,
     /* equiv idx, value */ 7, VALUE_OPT_PNAT,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 2, 0,
     /* opt state flags  */ PNAT_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptPnat,
     /* desc, NAME, name */ zPnatText, zPnat_NAME, zPnat_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 8, VALUE_OPT_ENDPOINTS,
     /* equiv idx, value */ 8, VALUE_OPT_ENDPOINTS,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ ENDPOINTS_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ zEndpointsText, zEndpoints_NAME, zEndpoints_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 9, VALUE_OPT_FIXCSUM,
     /* equiv idx, value */ 9, VALUE_OPT_FIXCSUM,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ FIXCSUM_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptFixcsum,
     /* desc, NAME, name */ zFixcsumText, zFixcsum_NAME, zFixcsum_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 10, VALUE_OPT_INFILE,
     /* equiv idx, value */ 10, VALUE_OPT_INFILE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 1, 1, 0,
     /* opt state flags  */ INFILE_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptInfile,
     /* desc, NAME, name */ zInfileText, zInfile_NAME, zInfile_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 11, VALUE_OPT_OUTFILE,
     /* equiv idx, value */ 11, VALUE_OPT_OUTFILE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 1, 1, 0,
     /* opt state flags  */ OUTFILE_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ zOutfileText, zOutfile_NAME, zOutfile_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 12, VALUE_OPT_CACHEFILE,
     /* equiv idx, value */ 12, VALUE_OPT_CACHEFILE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ CACHEFILE_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptCachefile,
     /* desc, NAME, name */ zCachefileText, zCachefile_NAME, zCachefile_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 13, VALUE_OPT_MTU,
     /* equiv idx, value */ 13, VALUE_OPT_MTU,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ MTU_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptMtu,
     /* desc, NAME, name */ zMtuText, zMtu_NAME, zMtu_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 14, VALUE_OPT_EFCS,
     /* equiv idx, value */ 14, VALUE_OPT_EFCS,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ EFCS_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptEfcs,
     /* desc, NAME, name */ zEfcsText, zEfcs_NAME, zEfcs_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 15, VALUE_OPT_FIXLEN,
     /* equiv idx, value */ 15, VALUE_OPT_FIXLEN,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ FIXLEN_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptFixlen,
     /* desc, NAME, name */ zFixlenText, zFixlen_NAME, zFixlen_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 16, VALUE_OPT_VLAN,
     /* equiv idx, value */ 16, VALUE_OPT_VLAN,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ VLAN_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptVlan,
     /* desc, NAME, name */ zVlanText, zVlan_NAME, zVlan_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 17, VALUE_OPT_VLAN_TAG,
     /* equiv idx, value */ 17, VALUE_OPT_VLAN_TAG,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ VLAN_TAG_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ aVlan_TagMustList, NULL,
     /* option proc      */ doOptVlan_Tag,
     /* desc, NAME, name */ zVlan_TagText, zVlan_Tag_NAME, zVlan_Tag_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 18, VALUE_OPT_VLAN_CFI,
     /* equiv idx, value */ 18, VALUE_OPT_VLAN_CFI,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ VLAN_CFI_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ aVlan_CfiMustList, NULL,
     /* option proc      */ doOptVlan_Cfi,
     /* desc, NAME, name */ zVlan_CfiText, zVlan_Cfi_NAME, zVlan_Cfi_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 19, VALUE_OPT_VLAN_PRI,
     /* equiv idx, value */ 19, VALUE_OPT_VLAN_PRI,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ VLAN_PRI_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ aVlan_PriMustList, NULL,
     /* option proc      */ doOptVlan_Pri,
     /* desc, NAME, name */ zVlan_PriText, zVlan_Pri_NAME, zVlan_Pri_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 20, VALUE_OPT_VERBOSE,
     /* equiv idx, value */ 20, VALUE_OPT_VERBOSE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ VERBOSE_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ zVerboseText, zVerbose_NAME, zVerbose_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 21, VALUE_OPT_DECODE,
     /* equiv idx, value */ 21, VALUE_OPT_DECODE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ DECODE_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ aDecodeMustList, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ zDecodeText, zDecode_NAME, zDecode_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 22, VALUE_OPT_VERSION,
     /* equiv idx, value */ 22, VALUE_OPT_VERSION,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ VERSION_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptVersion,
     /* desc, NAME, name */ zVersionText, zVersion_NAME, zVersion_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 23, VALUE_OPT_LESS_HELP,
     /* equiv idx, value */ 23, VALUE_OPT_LESS_HELP,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ LESS_HELP_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptLess_Help,
     /* desc, NAME, name */ zLess_HelpText, zLess_Help_NAME, zLess_Help_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_HELP, VALUE_OPT_HELP,
     /* equiv idx value  */ NO_EQUIVALENT, 0,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ OPTST_IMM, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doUsageOpt,
     /* desc, NAME, name */ zHelpText, NULL, zHelp_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_MORE_HELP, VALUE_OPT_MORE_HELP,
     /* equiv idx value  */ NO_EQUIVALENT, 0,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ OPTST_IMM, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL,  NULL,
     /* option proc      */ optionPagedUsage,
     /* desc, NAME, name */ zMore_HelpText, NULL, zMore_Help_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_SAVE_OPTS, VALUE_OPT_SAVE_OPTS,
     /* equiv idx value  */ NO_EQUIVALENT, 0,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ OPTST_SET_ARGTYPE(OPARG_TYPE_STRING)
                          | OPTST_ARG_OPTIONAL, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL,  NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ zSave_OptsText, NULL, zSave_Opts_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_LOAD_OPTS, VALUE_OPT_LOAD_OPTS,
     /* equiv idx value  */ NO_EQUIVALENT, 0,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, NOLIMIT, 0,
     /* opt state flags  */ OPTST_DISABLE_IMM | \
			OPTST_SET_ARGTYPE(OPARG_TYPE_STRING), 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ optionLoadOpt,
     /* desc, NAME, name */ zLoad_OptsText, zLoad_Opts_NAME, zLoad_Opts_Name,
     /* disablement strs */ zNotLoad_Opts_Name, zNotLoad_Opts_Pfx }
};

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Define the Tcprewrite Option Environment
 */
tSCC   zPROGNAME[]   = "TCPREWRITE";
tSCC   zUsageTitle[] =
"tcprewrite - Rewrite the packets in a pcap file.\n\
USAGE:  %s [ -<flag> [<val>] | --<name>[{=| }<val>] ]...\n";
tSCC   zRcName[]     = ".tcprewriterc";
tSCC*  apzHomeList[] = {
       "$$/",
       NULL };

#define zBugsAddr NULL
#define zExplain NULL
tSCC    zDetail[]     = "\n\
Tcprewrite is a tool to rewrite packets stored in ``pcap(3)'' file format, such\n\
as crated by tools such as ``tcpdump(1)'' and ``ethereal(1)''.  Once a pcap \n\
file has had it's packets rewritten, they can be replayed back out on the network\n\
using ``tcpreplay(1)''.\n\n\
tcprewrite currently supports the following DLT types:\n\
    * DLT_C_HDLC\n\
    * DLT_EN10MB\n\
    * DLT_LINUX_SSL\n\
    * DLT_RAW\n\n\
The packet editing features of tcprewrite which distinguish between \"client\"\n\
and \"server\" traffic requires a tcpprep(1) cache file.\n";
#define zFullVersion    NULL
/* extracted from /usr/local/share/autogen/optcode.tpl near line 309 */

#if defined(ENABLE_NLS)
# define OPTPROC_BASE OPTPROC_TRANSLATE
  static tOptionXlateProc translate_option_strings;
#else
# define OPTPROC_BASE OPTPROC_NONE
# define translate_option_strings NULL
#endif /* ENABLE_NLS */

tOptions tcprewriteOptions = {
    OPTIONS_STRUCT_VERSION,
    0, NULL,                    /* original argc + argv    */
    ( OPTPROC_BASE
    + OPTPROC_ERRSTOP
    + OPTPROC_SHORTOPT
    + OPTPROC_LONGOPT
    + OPTPROC_NO_REQ_OPT
    + OPTPROC_NO_ARGS
    + OPTPROC_GNUUSAGE
    + OPTPROC_HAS_IMMED ),
    0, NULL,                    /* current option index, current option */
    NULL,         NULL,         zPROGNAME,
    zRcName,      zCopyright,   zCopyrightNotice,
    zFullVersion, apzHomeList,  zUsageTitle,
    zExplain,     zDetail,      optDesc,
    zBugsAddr,                  /* address to send bugs to */
    NULL, NULL,                 /* extensions/saved state  */
    optionUsage,       /* usage procedure */
    translate_option_strings,   /* translation procedure */
    /*
     *  Indexes to special options
     */
    { INDEX_OPT_MORE_HELP,
      INDEX_OPT_SAVE_OPTS,
      NO_EQUIVALENT /* index of '-#' option */,
      13 /* index of default opt */
    },
    OPTION_CT, 24 /* user option count */
};

/*
 *  Create the static procedure(s) declared above.
 */
static void
doUsageOpt(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    USAGE( EXIT_SUCCESS );
}

/* * * * * * *
 *
 *   For the dbug option.
 */
static void
doOptDbug(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    static const struct {const int rmin, rmax;} rng[ 1 ] = {
        { 0, 5 } };
    long val;
    int ix;
    tCC* pzIndent = "\t\t\t\t  ";
    extern FILE* option_usage_fp;

    if (pOptDesc == NULL) /* usage is requesting range list
                             option_usage_fp has already been set */
        goto emit_ranges;

    val = atoi( pOptDesc->pzLastArg );
    for (ix = 0; ix < 1; ix++) {
        if (val < rng[ix].rmin)
            continue;  /* ranges need not be ordered. */
        if (val == rng[ix].rmin)
            goto valid_return;
        if (rng[ix].rmax == INT_MIN)
            continue;
        if (val <= rng[ix].rmax)
            goto valid_return;
    }

    option_usage_fp = stderr;
    fprintf( stderr, _("%s error:  %s option value ``%s''is out of range.\n"),
             pOptions->pzProgName, pOptDesc->pz_Name, pOptDesc->pzLastArg );
    pzIndent = "\t";

  emit_ranges:
    fprintf( option_usage_fp, _("%sit must lie in the range: %d to %d\n"),
             pzIndent, rng[0].rmin, rng[0].rmax );
    if (pOptDesc == NULL)
        return;

    USAGE( EXIT_FAILURE );
    /* NOTREACHED */
    return;

  valid_return:
    pOptDesc->pzLastArg = (char*)val;
}

/* * * * * * *
 *
 *   For the dmac option.
 */
static void
doOptDmac(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{

    int mask = 0;    

    mask = dualmac2hex(OPT_ARG(DMAC), options.intf1_dmac, options.intf2_dmac,
                strlen(OPT_ARG(DMAC)));

    options.mac_mask ^= (mask << 2);

}

/* * * * * * *
 *
 *   For the smac option.
 */
static void
doOptSmac(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    
    int mask = 0;
    mask =  dualmac2hex(OPT_ARG(SMAC), options.intf1_smac, options.intf2_smac,
                strlen(OPT_ARG(SMAC)));

    options.mac_mask ^= mask;

}

/* * * * * * *
 *
 *   For the proto option.
 */
static void
doOptProto(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    static const struct {const int rmin, rmax;} rng[ 1 ] = {
        { 0, 65535 } };
    long val;
    int ix;
    tCC* pzIndent = "\t\t\t\t  ";
    extern FILE* option_usage_fp;

    if (pOptDesc == NULL) /* usage is requesting range list
                             option_usage_fp has already been set */
        goto emit_ranges;

    val = atoi( pOptDesc->pzLastArg );
    for (ix = 0; ix < 1; ix++) {
        if (val < rng[ix].rmin)
            continue;  /* ranges need not be ordered. */
        if (val == rng[ix].rmin)
            goto valid_return;
        if (rng[ix].rmax == INT_MIN)
            continue;
        if (val <= rng[ix].rmax)
            goto valid_return;
    }

    option_usage_fp = stderr;
    fprintf( stderr, _("%s error:  %s option value ``%s''is out of range.\n"),
             pOptions->pzProgName, pOptDesc->pz_Name, pOptDesc->pzLastArg );
    pzIndent = "\t";

  emit_ranges:
    fprintf( option_usage_fp, _("%sit must lie in the range: %d to %d\n"),
             pzIndent, rng[0].rmin, rng[0].rmax );
    if (pOptDesc == NULL)
        return;

    USAGE( EXIT_FAILURE );
    /* NOTREACHED */
    return;

  valid_return:
    pOptDesc->pzLastArg = (char*)val;
}

/* * * * * * *
 *
 *   For the dlink option.
 */
static void
doOptDlink(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{

    static int count = 1;
    
    options.l2.enabled = 1;
    
    if (count == 1) {
        options.l2.len = read_hexstring(OPT_ARG(DLINK), options.l2.data1, L2DATALEN);
        /* 
         * preemtively copy over our data1[] to data2[] if user doesn't specify 
         * any data2[] data
         */
        memcpy(options.l2.data2, options.l2.data1, options.l2.len);
        count ++;
    } else {
        if (options.l2.len != read_hexstring(OPT_ARG(DLINK), options.l2.data2, L2DATALEN))
            err(1, "Layer2 data for both interfaces must be the same length");
    }

}

/* * * * * * *
 *
 *   For the portmap option.
 */
static void
doOptPortmap(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{

}

/* * * * * * *
 *
 *   For the pnat option.
 */
static void
doOptPnat(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    
    static int count = 1;

    options.rewrite_ip ++;
    
    if (count == 1) {
        if (! parse_cidr_map(&options.cidrmap1, OPT_ARG(PNAT)))
            errx(1, "Unable to parse primary pseudo-NAT: %s", OPT_ARG(PNAT));
        count ++;
    } else {
        if (! parse_cidr_map(&options.cidrmap2, OPT_ARG(PNAT)))
            errx(1, "Unable parse secondary pseudo-NAT: %s", OPT_ARG(PNAT));
    }

}

/* * * * * * *
 *
 *   For the fixcsum option.
 */
static void
doOptFixcsum(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
  
    options.fixcsum = 1;

}

/* * * * * * *
 *
 *   For the infile option.
 */
static void
doOptInfile(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    
    char ebuf[PCAP_ERRBUF_SIZE];
    options.infile = safe_strdup(OPT_ARG(INFILE));

    if ((options.pin = pcap_open_offline(options.infile, ebuf)) == NULL)
        errx(1, "Unable to open input pcap file: %s", ebuf);

}

/* * * * * * *
 *
 *   For the cachefile option.
 */
static void
doOptCachefile(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    
    options.cache_packets = 
        read_cache(&options.cachedata, OPT_ARG(CACHEFILE), &options.comment);

}

/* * * * * * *
 *
 *   For the mtu option.
 */
static void
doOptMtu(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    static const struct {const int rmin, rmax;} rng[ 1 ] = {
        { 1, MAXPACKET } };
    long val;
    int ix;
    tCC* pzIndent = "\t\t\t\t  ";
    extern FILE* option_usage_fp;

    if (pOptDesc == NULL) /* usage is requesting range list
                             option_usage_fp has already been set */
        goto emit_ranges;

    val = atoi( pOptDesc->pzLastArg );
    for (ix = 0; ix < 1; ix++) {
        if (val < rng[ix].rmin)
            continue;  /* ranges need not be ordered. */
        if (val == rng[ix].rmin)
            goto valid_return;
        if (rng[ix].rmax == INT_MIN)
            continue;
        if (val <= rng[ix].rmax)
            goto valid_return;
    }

    option_usage_fp = stderr;
    fprintf( stderr, _("%s error:  %s option value ``%s''is out of range.\n"),
             pOptions->pzProgName, pOptDesc->pz_Name, pOptDesc->pzLastArg );
    pzIndent = "\t";

  emit_ranges:
    fprintf( option_usage_fp, _("%sit must lie in the range: %d to %d\n"),
             pzIndent, rng[0].rmin, rng[0].rmax );
    if (pOptDesc == NULL)
        return;

    USAGE( EXIT_FAILURE );
    /* NOTREACHED */
    return;

  valid_return:
    pOptDesc->pzLastArg = (char*)val;
}

/* * * * * * *
 *
 *   For the efcs option.
 */
static void
doOptEfcs(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    
    options.efcs = 1;

}

/* * * * * * *
 *
 *   For the fixlen option.
 */
static void
doOptFixlen(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{

    if (strcmp(OPT_ARG(FIXLEN), "pad") == 0) {
        options.fixlen = FIXLEN_PAD;
    } else if (strcmp(OPT_ARG(FIXLEN), "trunc") == 0) {
        options.fixlen = FIXLEN_TRUNC;
    } else {
        errx(1, "Invalid fixlen argument '%s'.  Must be 'trunc' or 'pad'", OPT_ARG(FIXLEN));
    }

}

/* * * * * * *
 *
 *   For the vlan option.
 */
static void
doOptVlan(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{

    if (strcmp(OPT_ARG(VLAN), "add") == 0) {
        options.vlan = VLAN_ADD;
    } else if (strcmp(OPT_ARG(VLAN), "del") == 0) {
        options.vlan = VLAN_DEL;
    } else {
        errx(1, "Invalid vlan argument '%s'.  Must be 'add' or 'del'", OPT_ARG(VLAN));
    }

}

/* * * * * * *
 *
 *   For the vlan_tag option.
 */
static void
doOptVlan_Tag(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    static const struct {const int rmin, rmax;} rng[ 1 ] = {
        { 0, 4095 } };
    long val;
    int ix;
    tCC* pzIndent = "\t\t\t\t  ";
    extern FILE* option_usage_fp;

    if (pOptDesc == NULL) /* usage is requesting range list
                             option_usage_fp has already been set */
        goto emit_ranges;

    val = atoi( pOptDesc->pzLastArg );
    for (ix = 0; ix < 1; ix++) {
        if (val < rng[ix].rmin)
            continue;  /* ranges need not be ordered. */
        if (val == rng[ix].rmin)
            goto valid_return;
        if (rng[ix].rmax == INT_MIN)
            continue;
        if (val <= rng[ix].rmax)
            goto valid_return;
    }

    option_usage_fp = stderr;
    fprintf( stderr, _("%s error:  %s option value ``%s''is out of range.\n"),
             pOptions->pzProgName, pOptDesc->pz_Name, pOptDesc->pzLastArg );
    pzIndent = "\t";

  emit_ranges:
    fprintf( option_usage_fp, _("%sit must lie in the range: %d to %d\n"),
             pzIndent, rng[0].rmin, rng[0].rmax );
    if (pOptDesc == NULL)
        return;

    USAGE( EXIT_FAILURE );
    /* NOTREACHED */
    return;

  valid_return:
    pOptDesc->pzLastArg = (char*)val;
}

/* * * * * * *
 *
 *   For the vlan_cfi option.
 */
static void
doOptVlan_Cfi(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    static const struct {const int rmin, rmax;} rng[ 1 ] = {
        { 0, 1 } };
    long val;
    int ix;
    tCC* pzIndent = "\t\t\t\t  ";
    extern FILE* option_usage_fp;

    if (pOptDesc == NULL) /* usage is requesting range list
                             option_usage_fp has already been set */
        goto emit_ranges;

    val = atoi( pOptDesc->pzLastArg );
    for (ix = 0; ix < 1; ix++) {
        if (val < rng[ix].rmin)
            continue;  /* ranges need not be ordered. */
        if (val == rng[ix].rmin)
            goto valid_return;
        if (rng[ix].rmax == INT_MIN)
            continue;
        if (val <= rng[ix].rmax)
            goto valid_return;
    }

    option_usage_fp = stderr;
    fprintf( stderr, _("%s error:  %s option value ``%s''is out of range.\n"),
             pOptions->pzProgName, pOptDesc->pz_Name, pOptDesc->pzLastArg );
    pzIndent = "\t";

  emit_ranges:
    fprintf( option_usage_fp, _("%sit must lie in the range: %d to %d\n"),
             pzIndent, rng[0].rmin, rng[0].rmax );
    if (pOptDesc == NULL)
        return;

    USAGE( EXIT_FAILURE );
    /* NOTREACHED */
    return;

  valid_return:
    pOptDesc->pzLastArg = (char*)val;
}

/* * * * * * *
 *
 *   For the vlan_pri option.
 */
static void
doOptVlan_Pri(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    static const struct {const int rmin, rmax;} rng[ 1 ] = {
        { 0, 7 } };
    long val;
    int ix;
    tCC* pzIndent = "\t\t\t\t  ";
    extern FILE* option_usage_fp;

    if (pOptDesc == NULL) /* usage is requesting range list
                             option_usage_fp has already been set */
        goto emit_ranges;

    val = atoi( pOptDesc->pzLastArg );
    for (ix = 0; ix < 1; ix++) {
        if (val < rng[ix].rmin)
            continue;  /* ranges need not be ordered. */
        if (val == rng[ix].rmin)
            goto valid_return;
        if (rng[ix].rmax == INT_MIN)
            continue;
        if (val <= rng[ix].rmax)
            goto valid_return;
    }

    option_usage_fp = stderr;
    fprintf( stderr, _("%s error:  %s option value ``%s''is out of range.\n"),
             pOptions->pzProgName, pOptDesc->pz_Name, pOptDesc->pzLastArg );
    pzIndent = "\t";

  emit_ranges:
    fprintf( option_usage_fp, _("%sit must lie in the range: %d to %d\n"),
             pzIndent, rng[0].rmin, rng[0].rmax );
    if (pOptDesc == NULL)
        return;

    USAGE( EXIT_FAILURE );
    /* NOTREACHED */
    return;

  valid_return:
    pOptDesc->pzLastArg = (char*)val;
}

/* * * * * * *
 *
 *   For the version option.
 */
static void
doOptVersion(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    
    fprintf(stderr, "tcprewrite version: %s (build %s)", VERSION, svn_version());
#ifdef DEBUG
    fprintf(stderr, " (debug)");
#endif
    fprintf(stderr, "\n");
fprintf(stderr, "Copyright 2001-2005 by Aaron Turner <aturner@pobox.com>\n");
    fprintf(stderr, "Cache file supported: %s\n", CACHEVERSION);
    fprintf(stderr, "Compiled against libnet: %s\n", LIBNET_VERSION);
    fprintf(stderr, "Compiled against libpcap: %s\n", pcap_version);
#ifdef ENABLE_64BITS
    fprintf(stderr, "64 bit packet counters: enabled\n");
#else
    fprintf(stderr, "64 bit packet counters: disabled\n");
#endif
    exit(0);
    
}

/* * * * * * *
 *
 *   For the less-help option.
 */
static void
doOptLess_Help(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
  
    USAGE(EXIT_FAILURE);

}

/* extracted from /usr/local/share/autogen/optcode.tpl near line 396 */

#if ENABLE_NLS
#include <string.h>
#include <stdio.h>
#include <autoopts/usage-txt.h>

static char*
AO_gettext( const char* pz )
{
    char* pzRes;
    if (pz == NULL)
        return NULL;
    pzRes = _(pz);
    if (pzRes == pz)
        return pzRes;
    pzRes = strdup( pzRes );
    if (pzRes == NULL) {
        fputs( _("No memory for duping translated strings\n"), stderr );
        exit( EXIT_FAILURE );
    }
    return pzRes;
}

/*
 *  This invokes the translation code (e.g. gettext(3)).
 */
static void
translate_option_strings( void )
{
    /*
     *  Guard against re-translation.  It won't work.  The strings will have
     *  been changed by the first pass through this code.  One shot only.
     */
    if (option_usage_text.field_ct == 0)
        return;
    /*
     *  Do the translations.  The first pointer follows the field count field.
     *  The field count field is the size of a pointer.
     */
    {
        char** ppz = (char**)(void*)&(option_usage_text);
        int    ix  = option_usage_text.field_ct;

        do {
            ppz++;
            *ppz = AO_gettext(*ppz);
        } while (--ix > 0);
    }
    option_usage_text.field_ct = 0;

    {
        tOptDesc* pOD = tcprewriteOptions.pOptDesc;
        int       ix  = tcprewriteOptions.optCt;

        for (;;) {
            pOD->pzText           = AO_gettext(pOD->pzText);
            pOD->pz_NAME          = AO_gettext(pOD->pz_NAME);
            pOD->pz_Name          = AO_gettext(pOD->pz_Name);
            pOD->pz_DisableName   = AO_gettext(pOD->pz_DisableName);
            pOD->pz_DisablePfx    = AO_gettext(pOD->pz_DisablePfx);
            if (--ix <= 0)
                break;
            pOD++;
        }
    }
    tcprewriteOptions.pzCopyright   = AO_gettext(tcprewriteOptions.pzCopyright);
    tcprewriteOptions.pzCopyNotice  = AO_gettext(tcprewriteOptions.pzCopyNotice);
    tcprewriteOptions.pzFullVersion = AO_gettext(tcprewriteOptions.pzFullVersion);
    tcprewriteOptions.pzUsageTitle  = AO_gettext(tcprewriteOptions.pzUsageTitle);
    tcprewriteOptions.pzExplain     = AO_gettext(tcprewriteOptions.pzExplain);
    tcprewriteOptions.pzDetail      = AO_gettext(tcprewriteOptions.pzDetail);
}

#endif /* ENABLE_NLS */

#ifdef  __cplusplus
}
#endif
