/***************************************************************************
                          tea_funx.h  -  description
                             -------------------
    begin                : Fri Dec 12 2003
    copyright            : (C) 2003-2005 by Peter 'Roxton' Semiletov
    email                : peter.semiletov@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/



typedef gboolean (*DirForeachFunc) (const gchar *path,
				    const gchar *basename,
				    gpointer     user_data);


gchar* get_noname_name (void);

int get_value (int total, int perc);
int get_percent (int total, int value);

gboolean change_dir (gchar *filename);
gchar* create_full_path (gchar *filename, gchar *basedir);
void handle_file (gchar *filename, gint mode, gboolean kwas);
gboolean is_image (const gchar *filename);
gboolean copy_file (gchar *src, gchar *dest);
void create_empty_file (gchar *filename, gchar *first_line);
gchar* get_time (const gchar *format);
gint get_file_size (const gchar *filename);
gchar* get_8_filename (const gchar *filename);
gchar* get_l_filename (const gchar *filename);
gchar* get_lang_name (void);
gchar* find_doc_index_name (void);
void run_doc_in_browser (void);
gchar* get_clipboard_text (void);
void insert_image (gchar *a_filename);
gchar* get_tea_doc_compose_name (gchar *f);
gchar* get_tea_doc_dir (void);
GList* read_dir_files (gchar *path);
gchar* get_hl_name (gchar *file_name);
gboolean is_po (const gchar *f);
void insert_link (gchar *a_filename);
gboolean parse_error_line (const gchar * line, gchar ** filename, gint *lineno);
void handle_file_ide (gchar *filename, gint line);
gboolean check_ext (gchar *filename, gchar *ext);
void handle_file_enc (gchar *filename, gchar *enc);
void clipboard_put_text (const gchar *s);
GList* read_dir_to_glist (gchar *path);
gint get_markup_mode (void);
gchar* get_amarok_now_playing (void);
gboolean is_ext (gchar *filename, gchar *ext1, ...);
gchar* run_process_and_wait (gchar *command); 
gboolean is_tex (const gchar *filename);
void delete_dir (gchar *path);
gchar* correct_relative_filename (const gchar *path, const gchar *filename);
gchar* filename_from_xuri (const gchar *uri);
gchar *create_relative_link (const gchar *doc_filename, const gchar *img_filename);
gchar* create_full_path2 (gchar *filename, gchar *basedir); 
gboolean is_ext_arr (gchar *filename, gchar *exts);
gboolean check_ext_wo_dot (gchar *filename, gchar *ext);
gboolean is_writable (gchar *filename);
gboolean is_readable (gchar *filename);
gboolean has_ext (gchar *filename);
gboolean dir_foreach (const gchar *path, DirForeachFunc function, gpointer user_data, GError **error);
void read_dir_files_recurse (gchar *path, gchar *pattern);
