#ifndef IMG_VIEWER_H
#define IMG_VIEWER_H

#include <QtGui>

class CViewerWindow: public QWidget
{  
  Q_OBJECT

public:

   qreal angle;
   int scale;
   
   QFileInfoList fi;
   QString file_name;
   int current_index;
   
   QLabel *img_full;
   
   CViewerWindow (QWidget *parent = 0);
   void show_image (const QString &fname);
   void show_again();
   
protected:

  void keyPressEvent (QKeyEvent *event);    
};


class CImgViewer: public QObject
{
  Q_OBJECT

public:

  QWidget window_mini; 
  CViewerWindow window_full;

  QLabel *img_mini;

  CImgViewer (QObject *parent = 0);
  void set_image_mini (const QString &fname);
  void set_image_full (const QString &fname);

  QString get_the_thumb_name (const QString &img_fname);
};

#endif // IMG_VIEWER_H
