/***************************************************************************
                          tea_text_document.h  -  description
                             -------------------
    begin                : Mon Dec 1 2003
    copyright            : (C) 2003, 2004, 2005 by Peter 'Roxton' Semiletov
    email                : tea@list.ru
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "undo.h"
 
typedef struct
{
  UndoMgr *um;

  gboolean autosave;
  gboolean toggle_images_visibility;

  gint position;
  gboolean *readonly;
  gchar *hl_mode;

  gint dclicked_y;
  gchar *current_path;
  GtkTextTag *basic_tag;
  gboolean b_saved;
  gchar *file_name_utf8;
  gchar *file_name_local;
  gchar *encoding;
  gboolean linenums;
  
  GtkTextBuffer *text_buffer;
  GtkWidget *tab_label;
  GtkWidget *but;

  GtkScrolledWindow *scrolledwindow;
  GtkTextView *text_view;

  gchar *last_searched_text;

} t_note_page;


GList *dox;
gchar *last_dir;

void do_backup (gchar *file_name, gboolean do_check);

t_note_page* doc_clear_new (void);
                                        
t_note_page* page_create_new (void);
void page_free (t_note_page *page);
void page_del_by_index (int i);
gpointer glist_find_by_index (GList *list, int i);
t_note_page* get_page_by_index (int i);

gboolean text_doc_save (t_note_page *doc ,char *a_filename);
t_note_page* doc_open_file (gchar *a_filename);

//cur_text_doc points to current text document (in any case)
t_note_page *cur_text_doc;

gchar* doc_get_buf (GtkTextBuffer *text_buffer);
int doc_is_sel (GtkTextBuffer *text_buffer);
gboolean doc_save_buffer_to_file (GtkTextBuffer *text_buffer, gchar *filename);
void doc_select_line (t_note_page *doc, gint line);
void doc_rep_sel (t_note_page *page, const gchar *newstring);
t_note_page* get_page (void);
void doc_apply_settings (t_note_page *doc);
void doc_insert_at_cursor (t_note_page *doc, gchar *text);
void document_set_line_numbers(t_note_page* doc, gboolean value);
void doc_update_all (void);
gint editor_get_pos (t_note_page *doc);
void editor_set_pos (t_note_page *doc, guint pos);
gchar* doc_get_word (t_note_page *doc);
void log_to_memo (gchar *m1, gchar* m2, gint mode);
void widget_apply_colors (GtkWidget *w);
gboolean doc_reload_text (t_note_page *doc, gchar *filename, gchar *enc);
gint get_n_page_by_filename (gchar *filename);
gboolean find_quote (gunichar ch, gpointer user_data);
gchar* get_c_url_pure (t_note_page *doc); 
t_note_page* doc_ins_to_new (const gchar *newstring);
t_note_page* get_page_text (void);
void set_title (t_note_page *t);
t_note_page* open_file_std (gchar *f);
gboolean doc_search_f_next_ncase (t_note_page *doc); 
gboolean doc_search_f_ncase (t_note_page *doc, const gchar *text); 
gchar* upcase_each_first_letter_ofw (t_note_page *doc);
gchar* doc_get_word_at_left (t_note_page *doc, GtkTextIter *itstart, GtkTextIter *itend); 
void doc_move_cursor_backw (t_note_page *doc, gint i); 
void doc_move_cursor_forw (t_note_page *doc, gint i); 
void doc_move_cursor_backw_middle_tags (t_note_page *doc); 

void indent_real(GtkWidget *text_view);
void doc_header_source_switch (t_note_page *doc);
gint cb_button_press_event (GtkWidget *widget, GdkEventButton *event, gpointer user_data);
void doc_close_all (void);
void doc_close_all_except_current (void);
GList* add_session_item_composed (GList *list, t_note_page *doc);
GList* add_recent_item_composed (GList *list, t_note_page *doc);
void current_tag_close (t_note_page *doc, gint mode);
void doc_goto_local_label (const gchar *l);
void set_last_dir (t_note_page *doc);
