// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/sensu/sensu-go/api/core/v2/event.proto

package v2

import (
	bytes "bytes"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	github_com_golang_protobuf_proto "github.com/golang/protobuf/proto"
	proto "github.com/golang/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// An Event is the encapsulating type sent across the Sensu websocket transport.
type Event struct {
	// Timestamp is the time in seconds since the Epoch.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Entity describes the entity in which the event occurred.
	Entity *Entity `protobuf:"bytes,2,opt,name=entity,proto3" json:"entity,omitempty"`
	// Check describes the result of a check; if event is associated to check
	// execution.
	Check *Check `protobuf:"bytes,3,opt,name=check,proto3" json:"check,omitempty"`
	// Metrics are zero or more Sensu metrics
	Metrics *Metrics `protobuf:"bytes,4,opt,name=metrics,proto3" json:"metrics,omitempty"`
	// Metadata contains name, namespace, labels and annotations
	ObjectMeta `protobuf:"bytes,5,opt,name=metadata,proto3,embedded=metadata" json:"metadata"`
	// ID is the unique identifier of the event.
	ID []byte `protobuf:"bytes,6,opt,name=ID,proto3" json:"id"`
	// Sequence is the event sequence number. The agent increments the sequence
	// number by one for every successive event. When the agent restarts or
	// reconnects to another backend, the sequence number is reset to 1.
	Sequence             int64    `protobuf:"varint,7,opt,name=Sequence,proto3" json:"sequence"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Event) Reset()         { *m = Event{} }
func (m *Event) String() string { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()    {}
func (*Event) Descriptor() ([]byte, []int) {
	return fileDescriptor_4a6c1d479d0c50cf, []int{0}
}
func (m *Event) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Event) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Event.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Event) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Event.Merge(m, src)
}
func (m *Event) XXX_Size() int {
	return m.Size()
}
func (m *Event) XXX_DiscardUnknown() {
	xxx_messageInfo_Event.DiscardUnknown(m)
}

var xxx_messageInfo_Event proto.InternalMessageInfo

func init() {
	proto.RegisterType((*Event)(nil), "sensu.core.v2.Event")
}

func init() {
	proto.RegisterFile("github.com/sensu/sensu-go/api/core/v2/event.proto", fileDescriptor_4a6c1d479d0c50cf)
}

var fileDescriptor_4a6c1d479d0c50cf = []byte{
	// 395 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x91, 0xb1, 0x6e, 0x9b, 0x40,
	0x1c, 0xc6, 0x7d, 0xd8, 0xc6, 0xee, 0xd5, 0x5d, 0x4e, 0xae, 0x45, 0xad, 0x0a, 0x50, 0x27, 0x96,
	0x1e, 0x36, 0x54, 0x1d, 0x3a, 0x55, 0xd4, 0x1e, 0xac, 0xca, 0xaa, 0x44, 0xb7, 0x6e, 0x80, 0xaf,
	0x98, 0x44, 0x80, 0x63, 0x0e, 0xa4, 0xbc, 0x41, 0x1e, 0x21, 0xa3, 0x47, 0x3f, 0x42, 0x1e, 0xc1,
	0xa3, 0x5f, 0x20, 0x28, 0x21, 0x9b, 0x9f, 0x20, 0x63, 0xc4, 0x71, 0x71, 0x12, 0x4f, 0x2c, 0xe8,
	0xaf, 0xef, 0xfb, 0x7e, 0x7f, 0xf8, 0xfe, 0xc0, 0xb1, 0x1f, 0xd0, 0x65, 0xea, 0x62, 0x2f, 0x0e,
	0xf5, 0x84, 0x44, 0x49, 0x5a, 0x3d, 0xbf, 0xfa, 0xb1, 0xee, 0xac, 0x02, 0xdd, 0x8b, 0xd7, 0x44,
	0xcf, 0x0c, 0x9d, 0x64, 0x24, 0xa2, 0x78, 0xb5, 0x8e, 0x69, 0x8c, 0x3e, 0xb0, 0x04, 0x2e, 0x2d,
	0x9c, 0x19, 0xc3, 0x6f, 0xaf, 0x36, 0xf8, 0xb1, 0x1f, 0xeb, 0x2c, 0xe5, 0xa6, 0xff, 0x7f, 0x66,
	0x63, 0x6c, 0xe2, 0x31, 0x13, 0x99, 0xc6, 0xa6, 0x6a, 0xc9, 0xd0, 0xa8, 0xf9, 0xde, 0x88, 0x06,
	0xf4, 0x92, 0x33, 0x35, 0xbf, 0xd5, 0x5b, 0x12, 0xef, 0x9c, 0x23, 0x66, 0x3d, 0x24, 0x24, 0x74,
	0x1d, 0x78, 0x09, 0x87, 0x46, 0xb5, 0x21, 0xa7, 0x22, 0xbe, 0xdc, 0x0a, 0xb0, 0x3d, 0x2d, 0x4f,
	0x84, 0x3e, 0xc3, 0x77, 0x34, 0x08, 0x49, 0x42, 0x9d, 0x70, 0x25, 0x01, 0x15, 0x68, 0x4d, 0xfb,
	0x45, 0x40, 0x26, 0x14, 0xab, 0x46, 0x92, 0xa0, 0x02, 0xed, 0xbd, 0xf1, 0x11, 0xbf, 0xb9, 0x25,
	0x9e, 0x32, 0xd3, 0x6a, 0xed, 0x72, 0x05, 0xd8, 0x3c, 0x8a, 0x46, 0xb0, 0xcd, 0x2a, 0x49, 0x4d,
	0xc6, 0xf4, 0x4f, 0x98, 0x5f, 0xa5, 0xc7, 0x91, 0x2a, 0x88, 0xbe, 0xc3, 0x0e, 0x6f, 0x24, 0xb5,
	0x18, 0x33, 0x38, 0x61, 0xe6, 0x95, 0xcb, 0xa9, 0xe7, 0x30, 0xfa, 0x0d, 0xbb, 0x65, 0xa9, 0x85,
	0x43, 0x1d, 0xa9, 0xcd, 0xc0, 0x4f, 0x27, 0xe0, 0x1f, 0xf7, 0x8c, 0x78, 0x74, 0x4e, 0xa8, 0x63,
	0xf5, 0x77, 0xb9, 0xd2, 0xd8, 0xe7, 0x0a, 0x38, 0xe4, 0xca, 0x11, 0xb3, 0x8f, 0x13, 0x1a, 0x40,
	0x61, 0x36, 0x91, 0x44, 0x15, 0x68, 0x3d, 0x4b, 0x3c, 0xe4, 0x8a, 0x10, 0x2c, 0x6c, 0x61, 0x36,
	0x41, 0x1a, 0xec, 0xfe, 0x25, 0x17, 0x29, 0x89, 0x3c, 0x22, 0x75, 0xca, 0x03, 0x59, 0xbd, 0x72,
	0x43, 0xc2, 0x35, 0xfb, 0xe8, 0xfe, 0xe8, 0x5e, 0x6d, 0x94, 0xc6, 0x76, 0xa3, 0x00, 0x4b, 0x7d,
	0xbc, 0x97, 0xc1, 0xb6, 0x90, 0xc1, 0x4d, 0x21, 0x83, 0x5d, 0x21, 0x83, 0x7d, 0x21, 0x83, 0xbb,
	0x42, 0x06, 0xd7, 0x0f, 0x72, 0xe3, 0x9f, 0x90, 0x19, 0xae, 0xc8, 0x7e, 0x84, 0xf9, 0x14, 0x00,
	0x00, 0xff, 0xff, 0x0a, 0x82, 0xe9, 0x3f, 0xd0, 0x02, 0x00, 0x00,
}

func (this *Event) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Event)
	if !ok {
		that2, ok := that.(Event)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Timestamp != that1.Timestamp {
		return false
	}
	if !this.Entity.Equal(that1.Entity) {
		return false
	}
	if !this.Check.Equal(that1.Check) {
		return false
	}
	if !this.Metrics.Equal(that1.Metrics) {
		return false
	}
	if !this.ObjectMeta.Equal(&that1.ObjectMeta) {
		return false
	}
	if !bytes.Equal(this.ID, that1.ID) {
		return false
	}
	if this.Sequence != that1.Sequence {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}

type EventFace interface {
	Proto() github_com_golang_protobuf_proto.Message
	GetTimestamp() int64
	GetEntity() *Entity
	GetCheck() *Check
	GetMetrics() *Metrics
	GetObjectMeta() ObjectMeta
	GetID() []byte
	GetSequence() int64
}

func (this *Event) Proto() github_com_golang_protobuf_proto.Message {
	return this
}

func (this *Event) TestProto() github_com_golang_protobuf_proto.Message {
	return NewEventFromFace(this)
}

func (this *Event) GetTimestamp() int64 {
	return this.Timestamp
}

func (this *Event) GetEntity() *Entity {
	return this.Entity
}

func (this *Event) GetCheck() *Check {
	return this.Check
}

func (this *Event) GetMetrics() *Metrics {
	return this.Metrics
}

func (this *Event) GetObjectMeta() ObjectMeta {
	return this.ObjectMeta
}

func (this *Event) GetID() []byte {
	return this.ID
}

func (this *Event) GetSequence() int64 {
	return this.Sequence
}

func NewEventFromFace(that EventFace) *Event {
	this := &Event{}
	this.Timestamp = that.GetTimestamp()
	this.Entity = that.GetEntity()
	this.Check = that.GetCheck()
	this.Metrics = that.GetMetrics()
	this.ObjectMeta = that.GetObjectMeta()
	this.ID = that.GetID()
	this.Sequence = that.GetSequence()
	return this
}

func (m *Event) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Event) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Sequence != 0 {
		i = encodeVarintEvent(dAtA, i, uint64(m.Sequence))
		i--
		dAtA[i] = 0x38
	}
	if len(m.ID) > 0 {
		i -= len(m.ID)
		copy(dAtA[i:], m.ID)
		i = encodeVarintEvent(dAtA, i, uint64(len(m.ID)))
		i--
		dAtA[i] = 0x32
	}
	{
		size, err := m.ObjectMeta.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintEvent(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x2a
	if m.Metrics != nil {
		{
			size, err := m.Metrics.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEvent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Check != nil {
		{
			size, err := m.Check.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEvent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Entity != nil {
		{
			size, err := m.Entity.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEvent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Timestamp != 0 {
		i = encodeVarintEvent(dAtA, i, uint64(m.Timestamp))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintEvent(dAtA []byte, offset int, v uint64) int {
	offset -= sovEvent(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func NewPopulatedEvent(r randyEvent, easy bool) *Event {
	this := &Event{}
	this.Timestamp = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.Timestamp *= -1
	}
	if r.Intn(5) != 0 {
		this.Entity = NewPopulatedEntity(r, easy)
	}
	if r.Intn(5) != 0 {
		this.Check = NewPopulatedCheck(r, easy)
	}
	if r.Intn(5) != 0 {
		this.Metrics = NewPopulatedMetrics(r, easy)
	}
	v1 := NewPopulatedObjectMeta(r, easy)
	this.ObjectMeta = *v1
	v2 := r.Intn(100)
	this.ID = make([]byte, v2)
	for i := 0; i < v2; i++ {
		this.ID[i] = byte(r.Intn(256))
	}
	this.Sequence = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.Sequence *= -1
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedEvent(r, 8)
	}
	return this
}

type randyEvent interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneEvent(r randyEvent) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringEvent(r randyEvent) string {
	v3 := r.Intn(100)
	tmps := make([]rune, v3)
	for i := 0; i < v3; i++ {
		tmps[i] = randUTF8RuneEvent(r)
	}
	return string(tmps)
}
func randUnrecognizedEvent(r randyEvent, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldEvent(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldEvent(dAtA []byte, r randyEvent, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateEvent(dAtA, uint64(key))
		v4 := r.Int63()
		if r.Intn(2) == 0 {
			v4 *= -1
		}
		dAtA = encodeVarintPopulateEvent(dAtA, uint64(v4))
	case 1:
		dAtA = encodeVarintPopulateEvent(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateEvent(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateEvent(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateEvent(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateEvent(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *Event) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Timestamp != 0 {
		n += 1 + sovEvent(uint64(m.Timestamp))
	}
	if m.Entity != nil {
		l = m.Entity.Size()
		n += 1 + l + sovEvent(uint64(l))
	}
	if m.Check != nil {
		l = m.Check.Size()
		n += 1 + l + sovEvent(uint64(l))
	}
	if m.Metrics != nil {
		l = m.Metrics.Size()
		n += 1 + l + sovEvent(uint64(l))
	}
	l = m.ObjectMeta.Size()
	n += 1 + l + sovEvent(uint64(l))
	l = len(m.ID)
	if l > 0 {
		n += 1 + l + sovEvent(uint64(l))
	}
	if m.Sequence != 0 {
		n += 1 + sovEvent(uint64(m.Sequence))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovEvent(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozEvent(x uint64) (n int) {
	return sovEvent(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Event) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEvent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Event: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Event: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			m.Timestamp = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Timestamp |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Entity", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Entity == nil {
				m.Entity = &Entity{}
			}
			if err := m.Entity.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Check", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Check == nil {
				m.Check = &Check{}
			}
			if err := m.Check.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metrics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metrics == nil {
				m.Metrics = &Metrics{}
			}
			if err := m.Metrics.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObjectMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ObjectMeta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthEvent
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthEvent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ID = append(m.ID[:0], dAtA[iNdEx:postIndex]...)
			if m.ID == nil {
				m.ID = []byte{}
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sequence", wireType)
			}
			m.Sequence = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Sequence |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipEvent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEvent
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEvent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipEvent(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowEvent
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowEvent
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthEvent
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupEvent
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthEvent
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthEvent        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowEvent          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupEvent = fmt.Errorf("proto: unexpected end of group")
)
