package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListNatIps invokes the vpc.ListNatIps API synchronously
func (client *Client) ListNatIps(request *ListNatIpsRequest) (response *ListNatIpsResponse, err error) {
	response = CreateListNatIpsResponse()
	err = client.DoAction(request, response)
	return
}

// ListNatIpsWithChan invokes the vpc.ListNatIps API asynchronously
func (client *Client) ListNatIpsWithChan(request *ListNatIpsRequest) (<-chan *ListNatIpsResponse, <-chan error) {
	responseChan := make(chan *ListNatIpsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListNatIps(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListNatIpsWithCallback invokes the vpc.ListNatIps API asynchronously
func (client *Client) ListNatIpsWithCallback(request *ListNatIpsRequest, callback func(response *ListNatIpsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListNatIpsResponse
		var err error
		defer close(result)
		response, err = client.ListNatIps(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListNatIpsRequest is the request struct for api ListNatIps
type ListNatIpsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	NatIpStatus          string           `position:"Query" name:"NatIpStatus"`
	NatIpName            *[]string        `position:"Query" name:"NatIpName"  type:"Repeated"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	NextToken            string           `position:"Query" name:"NextToken"`
	NatGatewayId         string           `position:"Query" name:"NatGatewayId"`
	NatIpIds             *[]string        `position:"Query" name:"NatIpIds"  type:"Repeated"`
	DryRun               requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	NatIpCidr            string           `position:"Query" name:"NatIpCidr"`
	MaxResults           string           `position:"Query" name:"MaxResults"`
}

// ListNatIpsResponse is the response struct for api ListNatIps
type ListNatIpsResponse struct {
	*responses.BaseResponse
	NextToken  string  `json:"NextToken" xml:"NextToken"`
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	TotalCount string  `json:"TotalCount" xml:"TotalCount"`
	MaxResults string  `json:"MaxResults" xml:"MaxResults"`
	NatIps     []NatIp `json:"NatIps" xml:"NatIps"`
}

// CreateListNatIpsRequest creates a request to invoke ListNatIps API
func CreateListNatIpsRequest() (request *ListNatIpsRequest) {
	request = &ListNatIpsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ListNatIps", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListNatIpsResponse creates a response to parse from ListNatIps response
func CreateListNatIpsResponse() (response *ListNatIpsResponse) {
	response = &ListNatIpsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
