package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateDhcpOptionsSetAttribute invokes the vpc.UpdateDhcpOptionsSetAttribute API synchronously
func (client *Client) UpdateDhcpOptionsSetAttribute(request *UpdateDhcpOptionsSetAttributeRequest) (response *UpdateDhcpOptionsSetAttributeResponse, err error) {
	response = CreateUpdateDhcpOptionsSetAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateDhcpOptionsSetAttributeWithChan invokes the vpc.UpdateDhcpOptionsSetAttribute API asynchronously
func (client *Client) UpdateDhcpOptionsSetAttributeWithChan(request *UpdateDhcpOptionsSetAttributeRequest) (<-chan *UpdateDhcpOptionsSetAttributeResponse, <-chan error) {
	responseChan := make(chan *UpdateDhcpOptionsSetAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateDhcpOptionsSetAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateDhcpOptionsSetAttributeWithCallback invokes the vpc.UpdateDhcpOptionsSetAttribute API asynchronously
func (client *Client) UpdateDhcpOptionsSetAttributeWithCallback(request *UpdateDhcpOptionsSetAttributeRequest, callback func(response *UpdateDhcpOptionsSetAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateDhcpOptionsSetAttributeResponse
		var err error
		defer close(result)
		response, err = client.UpdateDhcpOptionsSetAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateDhcpOptionsSetAttributeRequest is the request struct for api UpdateDhcpOptionsSetAttribute
type UpdateDhcpOptionsSetAttributeRequest struct {
	*requests.RpcRequest
	BootFileName              string           `position:"Query" name:"BootFileName"`
	ResourceOwnerId           requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken               string           `position:"Query" name:"ClientToken"`
	TFTPServerName            string           `position:"Query" name:"TFTPServerName"`
	DomainNameServers         string           `position:"Query" name:"DomainNameServers"`
	DhcpOptionsSetDescription string           `position:"Query" name:"DhcpOptionsSetDescription"`
	DryRun                    requests.Boolean `position:"Query" name:"DryRun"`
	DhcpOptionsSetId          string           `position:"Query" name:"DhcpOptionsSetId"`
	ResourceOwnerAccount      string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount              string           `position:"Query" name:"OwnerAccount"`
	DomainName                string           `position:"Query" name:"DomainName"`
	OwnerId                   requests.Integer `position:"Query" name:"OwnerId"`
	DhcpOptionsSetName        string           `position:"Query" name:"DhcpOptionsSetName"`
}

// UpdateDhcpOptionsSetAttributeResponse is the response struct for api UpdateDhcpOptionsSetAttribute
type UpdateDhcpOptionsSetAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateDhcpOptionsSetAttributeRequest creates a request to invoke UpdateDhcpOptionsSetAttribute API
func CreateUpdateDhcpOptionsSetAttributeRequest() (request *UpdateDhcpOptionsSetAttributeRequest) {
	request = &UpdateDhcpOptionsSetAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "UpdateDhcpOptionsSetAttribute", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateDhcpOptionsSetAttributeResponse creates a response to parse from UpdateDhcpOptionsSetAttribute response
func CreateUpdateDhcpOptionsSetAttributeResponse() (response *UpdateDhcpOptionsSetAttributeResponse) {
	response = &UpdateDhcpOptionsSetAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
