/*
 * Telapathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 * 
 * ti-dlg-get-text.h:
 * "Get Text" Dialog
 * 
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_DLG_GET_TEXT_H__
#define __TI_DLG_GET_TEXT_H__

#include <gtk/gtk.h>

/*
 * Type macros.
 */

typedef struct _TIDlgGetText TIDlgGetText;
typedef struct _TIDlgGetTextClass TIDlgGetTextClass;

#define TI_TYPE_DLG_GET_TEXT               ti_dlg_get_text_get_type()
#define TI_DLG_GET_TEXT(object)            (G_TYPE_CHECK_INSTANCE_CAST ((object), TI_TYPE_DLG_GET_TEXT, TIDlgGetText))
#define TI_DLG_GET_TEXT_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_DLG_GET_TEXT, TIDlgGetTextClass))
#define TI_IS_DLG_GET_TEXT(object)         (G_TYPE_CHECK_INSTANCE_TYPE ((object), TI_TYPE_DLG_GET_TEXT))
#define TI_IS_DLG_GET_TEXT_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_DLG_GET_TEXT))
#define TI_DLG_GET_TEXT_GET_CLASS(object)  (G_TYPE_INSTANCE_GET_CLASS ((object), TI_TYPE_DLG_GET_TEXT, TIDlgGetTextClass))

struct _TIDlgGetText
{
    GObject parent;
};

struct _TIDlgGetTextClass
{
    GObjectClass parent;
};

GType ti_dlg_get_text_get_type (void);

TIDlgGetText* ti_dlg_get_text_new (GtkWindow* parent, const gchar* caption);

/**
 * Shows the "Get Text" dialog.
 *
 * @param text Entered text. Must be freed after use.
 * @return TRUE if the user clicked "OK" and FALSE otherwise.
 */
gboolean ti_dlg_get_text_run (TIDlgGetText* dlg_get_text, gchar** text);

#endif
