#!/bin/bash

# Copyright 2006 Will Stephenson <wstephenson@kde.org>
#
# This code is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# This script generates all the source files for the QtTelepathyCore library
# using the IDL in xml/

# Script to generate CMakeLists.txt files for core (adaptor) library
# Call it from the root telepathy-qt library!

target=QtTelepathyCore
cpp_cmakelist=src/Core/CMakeLists.txt
hdr_cmakelist=include/QtTelepathy/Core/CMakeLists.txt

###################################################
# CMakeList.txt for the sources
# Add the header
cat > $cpp_cmakelist << EOF

set(QT_DONT_USE_QTGUI "YES")
include(\${QT_USE_FILE})

set(INC_DIR \${CMAKE_SOURCE_DIR}/include)
set(common_DIR \${CMAKE_SOURCE_DIR}/src/Common)
include_directories(\${INC_DIR} \${QT_QTCORE_INCLUDE_DIR} \${QTDBUS_CFLAGS})

# ######### $target library #########

set(common_SRCS
EOF

# now the common sources
for i in `ls src/Common/*.cpp`;
do
	filename=`basename $i`
	echo "    \${common_DIR}/$filename" >> $cpp_cmakelist
done

cat >> $cpp_cmakelist << EOF
)

set(library_SRCS
    \${common_SRCS}
EOF

# Now add the sources
for i in `ls src/Core/*.cpp`;
do 
	filename=`basename $i`
	echo "    $filename" >> $cpp_cmakelist
done
cat >> $cpp_cmakelist << EOF
)

set(library_MOC_HDRS
EOF

# Now the headers, for moc
for i in `ls include/QtTelepathy/Core/*.h`
do
	filename=`basename $i`
	echo  "    \${INC_DIR}/QtTelepathy/Core/$filename" >> $cpp_cmakelist
done

echo -e "\n)" >> $cpp_cmakelist

echo 'QT4_WRAP_CPP(library_MOC_SRCS ${library_MOC_HDRS})' >> $cpp_cmakelist

echo "add_library($target SHARED \${library_SRCS} \${library_MOC_SRCS})" >> $cpp_cmakelist
echo "set_target_properties($target PROPERTIES VERSION 0.1.0 SOVERSION 0)" >> $cpp_cmakelist
echo "target_link_libraries($target \${QT_LIBRARIES} \${QDBUS_LDFLAGS})" >> $cpp_cmakelist
echo "install(TARGETS $target DESTINATION lib)" >> $cpp_cmakelist

#############################################################
# Now create the CMakeLists.txt for the headers

cat > $hdr_cmakelist << EOF
# ######### $target library #########

set(library_HDRS
EOF

# headers
for i in `ls include/QtTelepathy/Core/*`
do
	filename=`basename $i`
	if [ "$filename" != "CMakeList.txt" ]
	then
		echo  "    $filename" >> $hdr_cmakelist
	fi
done
echo -e ")\n" >> $hdr_cmakelist

echo "install(FILES \${library_HDRS} DESTINATION include/QtTelepathy/Core)" >> $hdr_cmakelist

