#!/bin/bash

# Copyright 2006 Will Stephenson <wstephenson@kde.org>
#
# This code is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# This script generates all the source files for the QtTelepathyCore library
# using the IDL in xml/
#
# Call it from the root telepathy-qt library!
#
# If you need to regenerate the files, extend the control file below for any
# new xml files and the includes from the Common code they will require,
# then call this script.  
#
# It will OVERWRITE existing sources.

exec 3< scripts/xml-filename-include-mapping

lowercase() {
  LOWER=`echo $1 | tr A-Z a-z`
}

until [ $done ]
do
    read <&3 xmlfile classname include
    if [ $? != 0 ]; then
        done=1
        continue
    fi
    if [[ "$xmlfile" =~ '^#' ]]
    then
        continue
    fi
    if [[ -z "$classname" ]]
    then
        continue
    fi

    if [ "x$include" != "x" ]
    then
        include="-i QtTelepathy/Common/$include"
    fi

    lowercase $classname
    headerfilename="${LOWER}adaptor.h"
    sourcefilename="${LOWER}adaptor.cpp"

    echo xmlfile=$xmlfile classname=$classname include=$include lower=$LOWER

    echo "Generating header file for $classname"
    qdbusxml2cpp -i QtTelepathy/Common/BaseTypes $include -a include/QtTelepathy/Core/$headerfilename: xml/$xmlfile

    echo "Creating Qt4-style header for $classname"
    echo "#include \"$headerfilename\"" > include/QtTelepathy/Core/${classname}Adaptor

    echo "Generating .cpp file for $classname"
    headerinclude="-i QtTelepathy/Core/${classname}Adaptor"
    qdbusxml2cpp $headerinclude  $include -a :src/Core/$sourcefilename xml/$xmlfile
done

