import templayer

tmpl = templayer.get_django_template("emulate.templayer.html")

@templayer.django_template(tmpl, "404.html")
def show_404(file_writer, context, request_path):
	contents = file_writer.open(title="Page not found")

	# request_path == context['request_path']
	contents.write_layer("show_404", url=request_path)

@templayer.django_template(tmpl, "flatpages/default.html")
def show_flatpage(file_writer, context, flatpage):
	contents = file_writer.open(title=flatpage.title)
	fp_contents = contents.open_layer("flatpage_body")

	# the flatpage content is HTML, so don't escape it.
	fp_contents.write(templayer.RawHTML(flatpage.content))




