/*

    File: common.h

    Copyright (C) 1998-2004 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */
#define SECTOR_SIZE     0x200

#define MAX_CYLINDERS 65535
#define MAX_HEADS 255
#define MAX_SECTORS 63

#define DISKNAME_MAX	64
#define DISKDESCRIPTION_MAX	128
#define TAB_PART 0x1BE
/* PARTITION TYPE */
#define P_NO_OS         0x00
#define P_12FAT         0x01
#define P_16FAT         0x04
#define P_EXTENDED      0x05
#define P_16FATBD       0x06
#define P_NTFS          0x07
#define P_HPFS          0x07
#define P_OS2MB         0x0A
#define P_32FAT         0x0B
#define P_32FAT_LBA     0x0C
#define P_16FATBD_LBA   0x0E
#define P_EXTENDX       0x0F
#define P_LINUXEXTENDX  0x85
#define P_12FATH        0x11
#define P_16FATH        0x14
#define P_16FATBDH      0x16
#define P_NTFSH         0x17
#define P_32FATH        0x1B
#define P_32FAT_LBAH    0x1C
#define P_16FATBD_LBAH  0x1E
#define P_NETWARE	0x65
#define P_OLDLINUX      0x81
#define P_LINSWAP       0x82
#define P_LINUX         0x83
#define P_LVM		0x8E
#define P_FREEBSD       0xA5
#define P_OPENBSD       0xA6
#define P_NETBSD        0xA9
#define P_BEOS          0xEB
#define P_RAID		0xFD
enum upart_type { UP_UNK, UP_FAT12, UP_FAT16, UP_FAT32, UP_EXTENDED, UP_NTFS, UP_HPFS, UP_OS2MB, UP_NETWARE, UP_EXT2, UP_EXT3, UP_LVM, UP_FREEBSD, UP_OPENBSD, UP_BEOS, UP_RAID, UP_LINSWAP, UP_LINSWAP2, UP_RFS, UP_RFS2, UP_JFS };
typedef enum upart_type upart_type_t;
enum status_type { STATUS_DELETED, STATUS_PRIM, STATUS_PRIM_BOOT, STATUS_LOG, STATUS_EXT, STATUS_EXT_IN_EXT};
typedef enum status_type status_type_t;
enum errcode_type {BAD_NOERR, BAD_SS, BAD_ES, BAD_SH, BAD_EH, BAD_EBS, BAD_RS, BAD_SC, BAD_EC, BAD_SCOUNT};
typedef enum errcode_type errcode_type_t;
enum aff_part_type {AFF_PART_NONL, AFF_PART_NL, AFF_PART_ORDER, AFF_PART_SHORT};
typedef enum aff_part_type aff_part_type_t;
int wdoprintf(WINDOW *window, const char *_format, ...) __attribute__ ((format (printf, 2, 3)));
int ecrit_rapport(const char *_format, ...) __attribute__ ((format (printf, 1, 2)));
void ecrit_rapport_string(const char *string,const int max_length);

typedef struct cellule_disk_param t_param_disk;

typedef unsigned char t_sector[0x200];
typedef unsigned char t_entry[0x10];
typedef struct cellule_diskext t_diskext;
typedef struct cellule_CHS t_CHS;
#define pt_offset_const(b, n) ((const struct partition_dos *)((b) + 0x1be + \
      (n) * sizeof(struct partition_dos)))
#define pt_offset(b, n) ((struct partition_dos *)((b) + 0x1be + \
      (n) * sizeof(struct partition_dos)))

struct partition_dos {
    unsigned char boot_ind;         /* 0x80 - active */
    unsigned char head;             /* starting head */
    unsigned char sector;           /* starting sector */
    unsigned char cyl;              /* starting cylinder */
    unsigned char sys_ind;          /* What partition type */
    unsigned char end_head;         /* end head */
    unsigned char end_sector;       /* end sector */
    unsigned char end_cyl;          /* end cylinder */
    unsigned char start4[4];        /* starting sector counting from 0 */
    unsigned char size4[4];         /* nr of sectors in partition */
};

struct cellule_CHS
{
  unsigned int cylinder;
  unsigned int head;
  unsigned int sector;
};

typedef struct cellule_list_part t_list_part;
struct cellule_list_part
{
  t_diskext *part;
  t_list_part *prev;
  t_list_part *next;
  int to_be_removed;
};

typedef struct cellule_list_disk t_list_disk;
struct cellule_list_disk
{
  t_param_disk *disk;
  t_list_disk *prev;
  t_list_disk *next;
};

struct cellule_disk_param
{
  dword size;
  t_CHS CHS;	/* logical CHS */
  int halt_on_errors;
  int write_used;
  char description_txt[DISKDESCRIPTION_MAX];
  const char *(*description)(t_param_disk *disk_car);
  int (*read)(t_param_disk *disk_car,const unsigned int nbr_sector, void *nom_buffer, const dword pos);
  int (*write)(t_param_disk *disk_car,const unsigned int nbr_sector, const void *nom_buffer, const dword pos);
  int (*clean)(t_param_disk *disk_car);
  void *data;
};

struct cellule_diskext
 {
  dword lba;
  dword part_size;
  dword boot_sector;
  dword blocksize;
  unsigned char part_type;
  upart_type_t upart_type;
  status_type_t status;
  unsigned int order;
  errcode_type_t errcode;
  char name[80];
  char info[80];
 };

typedef struct str_fat t_fat_test;
struct str_fat
{
  dword offset;
  int f_fat12;
  int f_fat16;
  int f_fat32;
};
typedef struct struct_my_data t_my_data;
struct struct_my_data
{
  t_param_disk *disk_car;
  t_diskext *partition;
  __s64 offset;
};

void dup_t_diskext(t_diskext *dest, const t_diskext *src);
int ask_YN(WINDOW *window,const char*msg);
int read_line(void);
char read_char(const char *);
void *MALLOC(size_t size);
void FREE(void *ptr);
char read_key(void);
char test_key(void);
unsigned int up2power(const unsigned int number);
void hd_parse_bis(const t_list_disk * list_disk, const int allow_partial_last_cylinder);
t_list_disk *hd_parse(t_list_disk *list_disk,const int debug);
t_param_disk *file_test_availability(const char *device, const int debug);
void my_sort(void *base, size_t nmemb, size_t size, int (*compar)(const void *, const void *));
int check_volume_name(const char *name,const unsigned int max_size);
void set_part_name(t_diskext *partition,const char *src,const int max_size);
int rebuild_FAT_BS(t_param_disk *disk_car,t_diskext *partition, const int debug, const int dump_ind,const int interface, const unsigned int expert);
int rebuild_NTFS_BS(t_param_disk *disk_car,t_diskext *partition, const int debug, const int dump_ind,const int interface);
#ifndef BSD_MAXPARTITIONS
#define	BSD_MAXPARTITIONS	8
#endif
#ifndef OPENBSD_MAXPARTITIONS
#define	OPENBSD_MAXPARTITIONS	16
#endif

#if defined(__i386__) || defined(__alpha__)
#define le16(x)  (x)             /* x as little endian */
#define be16(x)  ((((x)&0xff00)>>8)                      | \
    (((x)&0x00ff)<<8))
#define le24(x)  (x)
#define le32(x)  (x)
#define be32(x)  ((((x)&0xff000000L)>>24)                | \
    (((x)&0x00ff0000L)>>8)                  | \
    (((x)&0x0000ff00L)<<8)                  | \
    (((x)&0x000000ffL)<<24))
#define le64(x)  (x)
#define be64(x)  ((((x)&0xff00000000000000LL)>>56)       | \
    (((x)&0x00ff000000000000LL)>>40)        | \
    (((x)&0x0000ff0000000000LL)>>24)        | \
    (((x)&0x000000ff00000000LL)>>8)         | \
    (((x)&0x00000000ff000000LL)<<8)         | \
    (((x)&0x0000000000ff0000LL)<<24)        | \
    (((x)&0x000000000000ff00LL)<<40)        | \
    (((x)&0x00000000000000ffLL)<<56))
#else /* bigendian */
#define le16(x)  ((((x)&0xff00)>>8)                      | \
    (((x)&0x00ff)<<8))
#define be16(x)  (x)
#define be24(x)  (x)
#define le32(x)  ((((x)&0xff000000L)>>24)                | \
    (((x)&0x00ff0000L)>>8)                  | \
    (((x)&0x0000ff00L)<<8)                  | \
    (((x)&0x000000ffL)<<24))
#define be32(x)  (x)
#define le64(x)  ((((x)&0xff00000000000000LL)>>56)       | \
    (((x)&0x00ff000000000000LL)>>40)        | \
    (((x)&0x0000ff0000000000LL)>>24)        | \
    (((x)&0x000000ff00000000LL)>>8)         | \
    (((x)&0x00000000ff000000LL)<<8)         | \
    (((x)&0x0000000000ff0000LL)<<24)        | \
    (((x)&0x000000000000ff00LL)<<40)        | \
    (((x)&0x00000000000000ffLL)<<56))
#define be64(x)  (x)
#endif
#ifndef HAVE_SNPRINTF
int snprintf(char *str, size_t size, const char *format, ...);
#endif
#ifndef HAVE_VSNPRINTF
int vsnprintf(char *str, size_t size, const char *format, va_list ap);
#endif

