/*

    File: intrface.h

    Copyright (C) 1998-2004 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */
/* Constants for menuType parameter of menuSelect function */
#define MENU_HORIZ 1
#define MENU_VERT 2
#define MENU_ACCEPT_OTHERS 4
#define MENU_BUTTON 8
/* Miscellenous constants */
#define MENU_SPACING 2
#define MENU_MAX_ITEMS 256 /* for simpleMenu function */
#define MENU_UP 1
#define MENU_DOWN 2
#define MENU_RIGHT 3
#define MENU_LEFT 4

struct MenuItem
{
    const int key; /* Keyboard shortcut; if zero, then there is no more items in the menu item table */
    const char *name; /* Item name, should be eight characters with current implementation */
    const char *desc; /* Item description to be printed when item is selected */
};

#define LINE_LENGTH 80
#define BUFFER_LINE_LENGTH 4*LINE_LENGTH
#define MAXIMUM_PARTS 60
#define COL_ID_WIDTH 25
#define WARNING_START 23
#define COLUMNS 80

#define key_CR '\015'
#define key_ESC '\033'
#define key_DEL '\177'
#define key_BELL '\007'
/* '\014' == ^L */
#define key_REDRAWKEY '\014'


#define INTER_ADV_X	0
#define INTER_ADV_Y	23
#define INTER_MAIN_X	0
#define INTER_MAIN_Y	18
#define COMMAND_LINE_X	0
#define COMMAND_LINE_Y  18
#define INTER_OPTION_X  0
#define INTER_OPTION_Y	10
#define ANALYSE_X	0
#define ANALYSE_Y	5
#define DUMP_X	0
#define DUMP_Y	ANALYSE_Y + 2
#define DUMP_MAX_LINES	15
#define INTER_DUMP_X	DUMP_X
#define INTER_DUMP_Y	DUMP_Y+DUMP_MAX_LINES
#define INTER_STRUCTURE	14
#define INTER_ADV	15

int menuUpdate( int y, int x, const struct MenuItem *menuItems, const unsigned int itemLength, const char *available, const int menuType, unsigned int current );
int wmenuUpdate(WINDOW *window, int y, int x, const struct MenuItem *menuItems, const unsigned int itemLength, const char *available, const int menuType, unsigned int current);
int wmenuSelect(WINDOW *window, int y, int x, struct MenuItem *menuItems, const unsigned int itemLength, const char *available, int menuType, unsigned int menuDefault);
int wmenuSimple(WINDOW *window,struct MenuItem *menuItems, int menuDefault);
void change_geometry(t_param_disk *disk_car);
int do_curses_testdisk(int debug,int paranoid, int dump_ind, int fast_mode, int align,int do_analyse, const t_list_disk *list_disk);
int interface_write(t_param_disk *disk_car,t_list_part *list_part,const int can_search_deeper);
void dump_log(const void *nom_dump,unsigned int lng);
void dump(WINDOW *window,const void *nom_dump,unsigned int lng);
void dump2_log(const void *dump_1, const void *dump_2,const unsigned int lng);
void dump2(WINDOW *window,const void *dump_1, const void *dump_2,const unsigned int lng);
int wgetch_nodelay(WINDOW *window);

enum buffer_cmd {BUFFER_RESET, BUFFER_ADD, BUFFER_DISPLAY, BUFFER_WRITE,BUFFER_SHOW};
typedef enum buffer_cmd buffer_cmd_t;

#define MAX_LINES	200
/* int aff_buffer(const int cmd, const char *_format, ...) __attribute__ ((format (printf, 2, 3))); */
int aff_buffer(const buffer_cmd_t cmd, const char *_format, ...);
void aff_LBA2CHS(const t_param_disk *disk_car, const dword pos_LBA);
void aff_LBA2CHS_rapport(const t_param_disk *disk_car, const dword pos_LBA);
/*
void aff_disk(WINDOW *window,const t_param_disk *param_disk);
void aff_disk_rapport(const t_param_disk *param_disk);
void aff_disk_classic(const t_param_disk *param_disk);
*/
void aff_CHS_rapport(const t_CHS * CHS);
void aff_CHS(const t_CHS * CHS);
void aff_CHS_buffer(const t_CHS * CHS);
void aff_entry(const struct partition_dos*);
void aff_entry_rapport(const struct partition_dos*);
void aff_part_buffer(const aff_part_type_t newline,const t_param_disk *disk_car,const t_diskext *partition);
void aff_part(WINDOW *window,const aff_part_type_t newline,const t_param_disk *disk_car,const t_diskext *partition);
void aff_part_rapport(const t_param_disk *disk_car,const t_diskext *partition);
t_list_part *ask_structure(t_param_disk *disk_car,t_list_part *list_part, const int debug);
void aff_copy(WINDOW *window);
void aff_copy_full(WINDOW *window);
void interface_analyse(t_param_disk *disk_car, const int debug);
void interface_list(t_param_disk *disk_car, const int debug,const int test_recovery);
int ask_confirmation(const char*msg);
unsigned int ask_number(const unsigned int val_cur, const unsigned int val_min, const unsigned int val_max, const char * _format, ...);
t_list_part *add_partition(t_param_disk *disk_car,t_list_part *list_part, const int debug);
int display_message(const char*msg);
int get_string(char *str, int len, char *def);
void interface_editor(t_param_disk *disk_car);
int change_part_type(const t_param_disk *disk_car,t_diskext *partition);
