/*

    File: md.c

    Copyright (C) 1998-2004 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
 
#include <stdio.h>
#include <string.h>
#include "types.h"
#include "common.h"
#include "md.h"
#include "intrface.h"
#include "fnctdsk.h"
int check_MD(t_param_disk *disk_car,t_diskext *partition,const int debug)
{
  unsigned char buffer[8*SECTOR_SIZE];
  dword offset=MD_NEW_SIZE_SECTORS(partition->part_size);
  if(disk_car->read(disk_car,8, &buffer, partition->lba+offset)!=0)
  { return 1; }
  if(test_MD(disk_car,(struct mdp_superblock_s*)&buffer,partition,debug,0)!=0)
    return 1;
  set_MD_info(disk_car,(struct mdp_superblock_s*)&buffer,partition,debug,0);
  return 0;
}

int set_MD_info(t_param_disk *disk_car, const struct mdp_superblock_s *sb,t_diskext *partition,const int debug, const int dump_ind)
{
  unsigned int i;
  sprintf(partition->name,"md%u",sb->md_minor);
  sprintf(partition->info,"Raid %u: devices",sb->level);
  for(i=0;i<MD_SB_DISKS;i++)
  {
    if(sb->disks[i].major!=0 && sb->disks[i].minor!=0)
    {
      if(strlen(partition->info)<sizeof(partition->info)-26)
      { 
	sprintf(&partition->info[strlen(partition->info)]," (%u,%u)",sb->disks[i].major,sb->disks[i].minor);
	if(sb->disks[i].major==sb->this_disk.major && sb->disks[i].minor==sb->this_disk.minor)
	  sprintf(&partition->info[strlen(partition->info)],"*");
      }
    }
  }
  return 0;
}

int recover_MD(t_param_disk *disk_car, const struct mdp_superblock_s *sb,t_diskext *partition,const int debug, const int dump_ind)
{
  if(test_MD(disk_car,sb,partition,debug,dump_ind)!=0)
    return 1;
  set_MD_info(disk_car,sb,partition,debug,dump_ind);
  partition->part_type=(unsigned char)P_RAID;
  partition->lba=partition->lba-(sb->size<<1);
  partition->part_size=(sb->size<<1)+MD_RESERVED_SECTORS;
  return 0;
}

int test_MD(t_param_disk *disk_car, const struct mdp_superblock_s *sb,t_diskext *partition,const int debug, const int dump_ind)
{
  if(sb->md_magic==(unsigned int)MD_SB_MAGIC)
  {
    if(dump_ind!=0)
    {
      ecrit_rapport("\nRaid magic value at %u/%u/%u\n", LBA2cylinder(disk_car,partition->lba),LBA2head(disk_car,partition->lba),LBA2sector(disk_car,partition->lba));
      /* There is a little offset ... */
      dump(stdscr,sb,SECTOR_SIZE);
    }
    partition->upart_type=UP_RAID;
    return 0;
  }
  return 1;
}
