/*

    File: file_zip.c

    Copyright (C) 1998-2006 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License along
    with this program; if not, write the Free Software Foundation, Inc., 59
    Temple Place - Suite 330, Boston MA 02111-1307, USA.

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include "types.h"
#include "photorec.h"

static const char* header_check_zip(const unsigned char *buffer, const unsigned int buffer_size, const unsigned int safe_header_only,  t_file_recovery *file_recovery);
static void file_check_zip(t_file_recovery *file_recovery);


const t_file_hint file_hint_zip= {
  .extension="zip",
  .description="zip archive",
  .min_header_distance=0,
  .min_filesize=21,
  .max_filesize=PHOTOREC_MAX_FILE_SIZE,
  .recover=1,
  .header_check=&header_check_zip,
  .data_check=NULL,
  .file_check=&file_check_zip
};

static const char* header_check_zip(const unsigned char *buffer, const unsigned int buffer_size, const unsigned int safe_header_only,  t_file_recovery *file_recovery)
{
  const unsigned char zip_header[4]  = { 'P', 'K', 0x03, 0x04};
  const unsigned char zip_header2[8]  = { 'P', 'K', '0', '0', 'P', 'K', 0x03, 0x04}; /* WinZIPv8-compressed files. */
  if(memcmp(buffer,zip_header,sizeof(zip_header))==0)
  {
     if(strncmp(&buffer[30],"mimetypeapplication/vnd.sun.xml.",32)==0)
     {
       if(strncmp(&buffer[62],"calc",4)==0)
       {
	 return "sxc";
       }
       else if(strncmp(&buffer[62],"draw",4)==0)
       {
	 return "sxd";
       }
       else if(strncmp(&buffer[62],"impress",7)==0)
       {
	 return "sxi";
       }
       else if(strncmp(&buffer[62],"writer",6)==0)
       {
	 return "sxw";
       }
       else
       { /* default to writer */
	 return "sxw";
       }
     }
     else if(strncmp(&buffer[30],"mimetypeapplication/vnd.oasis.opendocument.graphics",51)==0)
       return "odg";
     else if(strncmp(&buffer[30],"mimetypeapplication/vnd.oasis.opendocument.presentation",55)==0)
       return "odp";
     else if(strncmp(&buffer[30],"mimetypeapplication/vnd.oasis.opendocument.spreadsheet",54)==0)
       return "ods";
     else if(strncmp(&buffer[30],"mimetypeapplication/vnd.oasis.opendocument.text",47)==0)
       return "odt";
    return file_hint_zip.extension;
  }
  if(memcmp(buffer,zip_header2,sizeof(zip_header2))==0)
    return file_hint_zip.extension;
  return NULL;
}

static void file_check_zip(t_file_recovery *file_recovery)
{
  unsigned char buffer[4096+3];
  int64_t zip_size=file_recovery->file_size;
  int i;
  buffer[4096]=0;
  buffer[4097]=0;
  buffer[4098]=0;
  do
  {
    int taille;
    zip_size-=4096;
    if(zip_size<0)
    {
      zip_size=0;
      buffer[4096]=0;
      buffer[4097]=0;
      buffer[4098]=0;
    }
    if(fseek(file_recovery->handle,zip_size,SEEK_SET)<0)
      return;
    taille=fread(buffer,1,4096,file_recovery->handle);
    for(i=taille-1;i>=0;i--)
    {
      if(buffer[i]==0x4b && buffer[i+1]==0x05 && buffer[i+2]==0x06 && buffer[i+3]==0x00)
      {
	file_recovery->file_size=zip_size+i+21;
	return;
      }
    }
    buffer[4096]=buffer[0];
    buffer[4097]=buffer[1];
    buffer[4098]=buffer[2];
  } while(zip_size>0);
  file_recovery->file_size=0;
}
