/*

    File: file_tiff.c

    Copyright (C) 1998-2005 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License along
    with this program; if not, write the Free Software Foundation, Inc., 51
    Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include <stdio.h>
#include "types.h"
#include "photorec.h"

static const char* header_check_tiff(const unsigned char *buffer, const unsigned int buffer_size, const unsigned int safe_header_only,  t_file_recovery *file_recovery);
/*
static int64_t test_tiff(FILE *infile);
static void file_check_tiff(t_file_recovery *file_recovery);
*/

const t_file_hint file_hint_tiff= {
  .extension="tif",
  .description="Tag Image File Format and some raw file formats (pef/nef/dcr/sr2/cr2)",
  .min_header_distance=0,
  .min_filesize=171,
  .max_filesize=200000000,
  .recover=1,
  .header_check=&header_check_tiff,
  .data_check=NULL,
  .file_check=NULL
};

static inline const unsigned char *find_in_mem(const unsigned char *haystack, const unsigned char * haystack_end,
    const unsigned char *needle, const unsigned int needle_length)
{
  /*
  ecrit_rapport("\n");
  */
  while(haystack!=NULL && haystack<haystack_end)
  {
    /*
    ecrit_rapport("find_in_mem(haystack=%p, haystack_end=%p,needle=%s,needle_length=%u)\n",
	haystack,haystack_end,needle,needle_length);
    */
    haystack=memchr(haystack,needle[0],haystack_end-haystack);
    if(haystack!=NULL)
    {
      if(memcmp(haystack,needle,needle_length)==0)
	return haystack;
      haystack++;
    }
  };
  return NULL;
}

static const char* header_check_tiff(const unsigned char *buffer, const unsigned int buffer_size, const unsigned int safe_header_only,  t_file_recovery *file_recovery)
{
  const unsigned char tiff_header_be[4]= { 'M','M',0x00, 0x2a};
  const unsigned char tiff_header_le[4]= { 'I','I',0x2a, 0x00};
  const unsigned char pentax_sig[18]= { 'P', 'E', 'N', 'T', 'A', 'X', ' ', 'C', 'o', 'r', 'p', 'o', 'r', 'a', 't', 'i', 'o', 'n'};
  const unsigned char nikon_sig[17]= { 'N', 'I', 'K', 'O', 'N', ' ', 'C', 'O', 'R', 'P', 'O', 'R', 'A', 'T', 'I', 'O', 'N'};
  const unsigned char dcr_sig[5]= { '.', 'D', 'C', 'R', 0x00};
  const unsigned char sony_sig[5]= { 'S', 'O', 'N', 'Y', 0x00};
  if(memcmp(buffer,tiff_header_be,sizeof(tiff_header_be))==0 ||
      memcmp(buffer,tiff_header_le,sizeof(tiff_header_le))==0)
  {
    /* Canon RAW */
    if(buffer[8]=='C' && buffer[9]=='R' && buffer[10]==2)
      return "cr2";
    /* Pentax RAW */
    if(find_in_mem(buffer,buffer+buffer_size,pentax_sig,sizeof(pentax_sig))!=NULL)
      return "pef";
    /* Nikon RAW */
    if(find_in_mem(buffer,buffer+buffer_size,nikon_sig,sizeof(nikon_sig))!=NULL)
      return "nef";
    /* Kodak RAW */
    if(find_in_mem(buffer,buffer+buffer_size,dcr_sig,sizeof(dcr_sig))!=NULL)
      return "dcr";
    /* Sony RAW */
    if(find_in_mem(buffer,buffer+buffer_size,sony_sig,sizeof(sony_sig))!=NULL)
      return "sr2";
    return file_hint_tiff.extension;
  }
  return NULL;
}

/*
// Seems to be wrong
static void file_check_tiff(t_file_recovery *file_recovery)
{
  const unsigned char tiff_footer[2]= {0xff, 0xd9};
  file_search_footer(file_recovery, tiff_footer,sizeof(tiff_footer));

}
*/
