/*
 * @(#)$Header: /mm/src/tgif/v4/RCS/chinput.e,v 4.5 2003/08/15 16:33:18 william Exp $
 */

#ifndef _NO_CHINPUT

#ifndef _CHINPUT_E_
#define _CHINPUT_E_

#define HZINPUT_CLIENT_VERSION		"1.21"
#define HZINPUT_SERVER_VERSION  	"1.21"
#define HZINPUT_SERVER_PROTOCOL		"CHINESE_CONVERSION"

#define HZSERVER_ENCODING_GB		0
#define HZSERVER_ENCODING_BIG5		1
#define HZSERVER_ENCODING_JIS		2
#define HZSERVER_ENCODING_KS		3
#define HZSERVER_ENCODING_UNKNOWN	(-1)

#define HZCLIENT_QUERY_PROTOCOL		0
#define HZCLIENT_QUERY_VERSION		1
#define HZCLIENT_QUERY_ENCODING		2
#define HZCLIENT_QUERY_INPUTMETHOD	3
#define HZCLIENT_QUERY_STATUS		4
#define HZCLIENT_QUERY_UNKNOWN		(-1)

#define HZCLIENT_CONFIG_DEFAULTCOLOR	0
#define HZCLIENT_CONFIG_DIMCOLOR	1
#define HZCLIENT_CONFIG_LIGHTCOLOR	2
#define HZCLIENT_CONFIG_PANELCOLOR	3
#define HZCLIENT_CONFIG_TEXTCOLOR	4
#define HZCLIENT_CONFIG_HZFONT		5
#define HZCLIENT_CONFIG_FONT		6
#define HZCLIENT_CONFIG_INMETHOD	7
#define HZCLIENT_CONFIG_ENCODING	8
#define HZCLIENT_CONFIG_DICTIONARY	9
#define HZCLIENT_CONFIG_ASSOCIATION	10
#define HZCLIENT_CONFIG_LOCKWINDOW	11
#define HZCLIENT_CONFIG_RELEASEWINDOW   12
#define HZCLIENT_CONFIG_PLUGIN		13
#define HZCLIENT_CONFIG_FREEWIN		14
#define HZCLIENT_CONFIG_CLOSE           15

#define HZSERVER_STATUS_DISABLED        0
#define HZSERVER_STATUS_ENABLED         1

#define HZSERVER_KEYBOARD_NULL			0
#define HZSERVER_KEYBOARD_SYMBOL_NUMERIC	1
#define HZSERVER_KEYBOARD_QJ_PY			2
#define HZSERVER_KEYBOARD_JAPANESE		3
#define HZSERVER_KEYBOARD_GREEK_RUSSIAN		4
#define HZSERVER_KEYBOARD_TABLE			5

#define HZSERVER_OUTPUT_NORMAL_KEY		0
#define HZSERVER_OUTPUT_FUNCTION_KEY		1
#define HZSERVER_OUTPUT_HANZI			2
#define HZSERVER_OUTPUT_BAD			-1

#define HZSERVER_INPUT_METHOD_DISABLE		-1
#define HZSERVER_INPUT_METHOD_ENABLE		-2

#define HZSERVER_INPUT_METHOD_ASCII		1
#define HZSERVER_INPUT_METHOD_IC		2
#define HZSERVER_INPUT_METHOD_QW                3
#define HZSERVER_INPUT_METHOD_TONEPY            4
#define HZSERVER_INPUT_METHOD_QJ                5
#define HZSERVER_INPUT_METHOD_PUNCT             6
#define HZSERVER_INPUT_METHOD_PY                7
#define HZSERVER_INPUT_METHOD_CCDOSPY           8
#define HZSERVER_INPUT_METHOD_WUBI              9
#define HZSERVER_INPUT_METHOD_CANGJIE           10
#define HZSERVER_INPUT_METHOD_ENGLISH           11
#define HZSERVER_INPUT_METHOD_CTLAU             12
#define HZSERVER_INPUT_METHOD_SW                13
#define HZSERVER_INPUT_METHOD_QIANMA            14
#define HZSERVER_INPUT_METHOD_TELECODE          15
#define HZSERVER_INPUT_METHOD_HIRAGANA          16
#define HZSERVER_INPUT_METHOD_KATAKANA          17

/*
#define HZSERVER_INPUT_METHOD_ASCII             1
#define HZSERVER_INPUT_METHOD_IC                2
#define HZSERVER_INPUT_METHOD_PY                3
#define HZSERVER_INPUT_METHOD_QJ                4
#define HZSERVER_INPUT_METHOD_PUNCT             5
*/
#define HZSERVER_INPUT_METHOD_ETZY              6
#define HZSERVER_INPUT_METHOD_ZOZY              7
#define HZSERVER_INPUT_METHOD_SIMPLEX           8
/*
#define HZSERVER_INPUT_METHOD_CANGJIE           9
#define HZSERVER_INPUT_METHOD_ENGLISH           10
*/
#define HZSERVER_INPUT_METHOD_4CORNER           11
#define HZSERVER_INPUT_METHOD_HSU               12
#define HZSERVER_INPUT_METHOD_ARRAY30           13
#define HZSERVER_INPUT_METHOD_BOSHIAMY          14

/*
#define HZSERVER_INPUT_METHOD_ASCII             1
#define HZSERVER_INPUT_METHOD_IC                2
*/
#define HZSERVER_INPUT_METHOD_ROMAKANA          3
#define HZSERVER_INPUT_METHOD_TCODE             4
/*
#define HZSERVER_INPUT_METHOD_QJ                5
#define HZSERVER_INPUT_METHOD_PUNCT             6
*/

/*
#define HZSERVER_INPUT_METHOD_ASCII             1
#define HZSERVER_INPUT_METHOD_IC                2
*/
#define HZSERVER_INPUT_METHOD_HANGUL            3
#define HZSERVER_INPUT_METHOD_HANJA             4
/*
#define HZSERVER_INPUT_METHOD_QJ                5
#define HZSERVER_INPUT_METHOD_PUNCT             6
*/

#define HZ_PROTOCOL_ATOM 	"_CHINESE_CONVERSION"
#define HZ_TOOLBAR_ATOM		"_HZ_TOOLBAR_ATOM"
#define HZ_INPUT_ATOM           "_HZ_INPUT_ATOM"
#define HZ_OUTPUT_ATOM          "_HZ_OUTPUT_ATOM"
#define HZ_CONFIG_ATOM		"_HZ_CONFIG_ATOM"
#define HZ_QUERY_ATOM		"_HZ_QUERY_ATOM"
#define HZ_REPLY_ATOM		"_HZ_REPLY_ATOM"

extern Atom hz_protocol_atom;	/* protocol atom marking the server	*/
extern Atom hz_toolbar_atom;	/* protocol atom for toolbar		*/
extern Atom hz_input_atom;	/* atom for key press			*/
extern Atom hz_output_atom;	/* atom for output from the server	*/
extern Atom hz_query_atom;	/* query server 			*/
extern Atom hz_reply_atom;	/* reply client query			*/
extern Atom hz_config_atom;	/* config server attributes and state	*/

#ifdef _INCLUDE_FROM_CHINPUT_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_CHINPUT_C_*/

extern int	HZclientInit ARGS_DECL((Display *dpy)); 
/* 
	argument: null
   	return:   0 success, 1: failed
*/

extern int	HZsendKey ARGS_DECL((Display *dpy,
		                     Window win,
		                     XKeyEvent *eve));
/*
	argument: dpy		display
		  win		client window
		  event		send keypress event
	return:   0 -- server not on
		  1 -- OK
*/

extern int	HZconfigServer ARGS_DECL((Display *dpy,
		                     Window win,
		                     int flag,
		                     int n1,
		                     int n2,
		                     int n3));
/*
	argument: dpy		display
		  win		client window
		  flag		configure type
		  n1,n2,n3	color: red,green,blue
	return:   0 -- failed
		  1 -- OK
*/

extern int	HZprocInput ARGS_DECL((XClientMessageEvent *ev,
		                       int *number,
		                       unsigned int *keycode,
		                       unsigned int *keystate,
		                       char *str));
/* 
	argument: clientevent
		  number	number chars returned by server(or client)
		  code		key code returned
		  state		key state(modifier)
		  str		string buffer(hanzi)
   	return:   -1 nothing happened
		  0 normal key;
		  1 function key;
		  2 string
*/

extern int	HZqueryServer ARGS_DECL((Display *dpy,
		               Window win,
		               int type,
		               char *str));
/*
	argument: display	display
		  window	client window which want to accept event
		  type		query type
		  str		returned string
	return:   0 -- server not on
		  1 -- OK
*/


/* input event 
	destination: server window
	event.xclient.message_type = hz_input_atom
	event.xclient.format = 32
	event.xclient.data.l[0] = keysym;
	event.xclient.data.l[1] = key_status_mask;
	event.xclient.data.l[2...4] unused

	if server not loaded, then the client will send itself a client
	event for the client to process conveniently....

        destination: client window
        event.xclient.message_type = hz_output_atom
        event.xclient.format = 32
        event.xclient.data.b[0] = 1;
        event.xclient.data.l[1] = keysym;
	event.xclient.data.l[2] = status(modifier)
        event.xclient.data.l[3...4] unused

*/

/* output event
	destination: client window
	event.xclient.message_type = hz_output_atom
	event.xclient.format = 32
	event.xclient.data.b[0] = total_chars_converted;
	event.xclient.data.b[1] = charbuf...
*/

/* query event 
        destination: server window
        event.xclient.message_type = hz_query_atom
        event.xclient.format = 32
        event.xclient.data.l[0] = query_type;
	event.xclient.data.l[1...4] unused
	query_type:
		HZCLIENT_QUERY_PROTOCOL         0
		HZCLIENT_QUERY_VERSION          1
		HZCLIENT_QUERY_ENCODING         2
		HZCLIENT_QUERY_STATUS           3
*/

/* reply event
        destination: client window
        event.xclient.message_type = hz_reply_atom
        event.xclient.format = 32
        event.xclient.data.b[0] = reply_type;
	event.xclient.data.b[1...] = answer
	....

*/

/* config event
	destination: server window
	event.xclient.message_type = hz_config_atom
        event.xclient.format = 32
        event.xclient.data.l[0] = config_type;
	config_type:
		HZSERVER_CONFIG_FGCOLOR         1
		HZSERVER_CONFIG_BGCOLOR         2
		HZSERVER_CONFIG_PANELCOLOR      3
		HZSERVER_CONFIG_ENCODING        4
		HZSERVER_CONFIG_INPUTMTHD       5
		HZSERVER_CONFIG_INPUTKBD        6
		color type:
			event.xclient.data.l[1] = red
			event.xclient.data.l[2] = green
			event.xclient.data.l[3] = blue
		encoding type:
			event.xclient.data.l[1] = encoding_type
		input method type:
			event.xclient.data.l[1] = encoding_method
		input keyboard type:
			event.xclient.data.l[1] = keyboard_type;
*/
#ifdef _INCLUDE_FROM_CHINPUT_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_CHINPUT_C_*/

#endif /*_CHINPUT_E_*/

#endif /* ~_NO_CHINPUT */

