dnl $Id$
dnl
dnl Copyright (c) 2004-2009
dnl         The Thunar development team. All rights reserved.
dnl
dnl Written for Thunar by Benedikt Meurer <benny@xfce.org>.
dnl



dnl # BM_THUNAR_VFS_MONITOR_IMPL()
dnl #
dnl # Determine the file system monitoring to use for
dnl # thunar-vfs.
dnl #
dnl # Sets LIBFAM_CFLAGS and LIBFAM_LIBS and defines
dnl # HAVE_FAM_H and HAVE_LIBFAM if FAM/Gamin were
dnl # found.
dnl #
dnl # Sets $ac_bm_thunar_vfs_monitor_impl to "FAM",
dnl # "Gamin" or "none".
dnl #
AC_DEFUN([BM_THUNAR_VFS_MONITOR_IMPL],
[
LIBFAM_CFLAGS=""
LIBFAM_LIBS=""
have_libfam=no
ac_bm_thunar_vfs_monitor_impl="none"
XDT_CHECK_PACKAGE([LIBFAM], [gamin], [0.1.0],
[
  have_libfam=yes
  ac_bm_thunar_vfs_monitor_impl="Gamin"
],
[
  dnl Fallback to a generic FAM check
  AC_CHECK_HEADERS([fam.h],
  [
    AC_CHECK_LIB([fam], [FAMOpen],
    [
      have_libfam="yes" LIBFAM_LIBS="-lfam"
      ac_bm_thunar_vfs_monitor_impl="FAM"
    ])
  ])
])
if test x"$have_libfam" = x"yes"; then
  dnl Define appropriate symbols
  AC_DEFINE([HAVE_FAM_H], [1], [Define to 1 if you have the <fam.h> header file.])
  AC_DEFINE([HAVE_LIBFAM], [1], [Define to 1 if the File Alteration Monitor is available.])

  dnl Check for FAMNoExists (currently Gamin only)
  save_LIBS="$LIBS"
  LIBS="$LIBS $LIBFAM_LIBS"
  AC_CHECK_FUNCS([FAMNoExists])
  LIBS="$save_LIBS"
fi
AC_SUBST([LIBFAM_CFLAGS])
AC_SUBST([LIBFAM_LIBS])
])



dnl # BM_THUNAR_VFS_OS_IMPL()
dnl #
dnl # Determine the operating system support to use
dnl # for thunar-vfs.
dnl #
dnl # Sets ac_bm_thunar_vfs_os_impl to "bsd" or "generic" and
dnl # defines the automake conditional THUNAR_VFS_OS_IMPL_BSD.
dnl #
AC_DEFUN([BM_THUNAR_VFS_OS_IMPL],
[
  dnl # Auto-detect target operating system support
  AC_MSG_CHECKING([for operating system support])
  case "$target_os" in
  dragonfly*|freebsd*|netbsd*|openbsd*|darwin*)
    dnl # The BSD Family is fully supported
    ac_bm_thunar_vfs_os_impl=bsd
    ;;

  *)
    dnl # Otherwise fallback to generic OS support
    ac_bm_thunar_vfs_os_impl=generic
  esac
  AC_MSG_RESULT([$ac_bm_thunar_vfs_os_impl])

  dnl # Set automake conditionals appropriately
  AM_CONDITIONAL([THUNAR_VFS_OS_IMPL_BSD], [test x"$ac_bm_thunar_vfs_os_impl" = x"bsd"])
])



dnl # BM_THUNAR_VFS_VOLUME_IMPL()
dnl #
dnl # Determines the volume manager implementation to
dnl # use for thunar-vfs.
dnl #
dnl # Sets ac_bm_thunar_vfs_volume_impl to "freebsd",
dnl # "hal" or "none".
dnl #
AC_DEFUN([BM_THUNAR_VFS_VOLUME_IMPL],
[
  dnl The --with-volume-manager option
  AC_ARG_WITH([volume-manager],
AC_HELP_STRING([--with-volume-manager=@<:@auto/freebsd/hal/none@:>@], [The volume manager implementation @<:@default=auto@:>@]),
    [], [with_volume_manager=auto])

  dnl # Check if we should try to auto-detect
  if test x"$with_volume_manager" = x"freebsd"; then
    ac_bm_thunar_vfs_volume_impl=freebsd
  elif test x"$with_volume_manager" = x"hal"; then
    ac_bm_thunar_vfs_volume_impl=hal
  elif test x"$with_volume_manager" = x"none"; then
    ac_bm_thunar_vfs_volume_impl=none
  else
    dnl # Check if HAL is available
    XDT_CHECK_PACKAGE([HAL], [hal-storage], [0.5.0],
    [
      dnl # HAL is available, use it
      ac_bm_thunar_vfs_volume_impl=hal
    ],
    [
      dnl # Check operating system type
      case "$target_os" in
      freebsd*)
        dnl # FreeBSD is fully supported
        ac_bm_thunar_vfs_volume_impl=freebsd
        ;;
      *)
        dnl # Otherwise no volume support
        ac_bm_thunar_vfs_volume_impl=none
        ;;
      esac
    ])
  fi

  dnl # We need HAL >= 0.5.x and D-BUS >= 0.23 for the HAL volume manager
  if test x"$ac_bm_thunar_vfs_volume_impl" = x"hal"; then
    XDT_CHECK_PACKAGE([HAL], [hal-storage], [0.5.7])
    XDT_CHECK_PACKAGE([HAL_DBUS], [dbus-glib-1], [0.23])
    
    dnl # Check if LIBHAL_DRIVE_CDROM_CAPS_DVDPLUSRWDL is declared
    save_CFLAGS="$CFLAGS"
    CFLAGS="$CFLAGS $HAL_CFLAGS"
    AC_MSG_CHECKING([whether LIBHAL_DRIVE_CDROM_CAPS_DVDPLUSRWDL is declared])
    AC_COMPILE_IFELSE(AC_LANG_SOURCE(
    [#include <libhal-storage.h>
      int main (int argc, char **argv) { return LIBHAL_DRIVE_CDROM_CAPS_DVDPLUSRWDL; }
    ]),
    [
      AC_DEFINE([HAVE_LIBHAL_DRIVE_CDROM_CAPS_DVDPLUSRWDL], [1], [Define if LIBHAL_DRIVE_CDROM_CAPS_DVDPLUSRWDL present])
      AC_MSG_RESULT([yes])
    ],
    [
      AC_MSG_RESULT([no])
    ])
    CFLAGS="$save_CFLAGS"
  fi

  dnl # Set config.h variables depending on what we're going to use
  AC_MSG_CHECKING([for the volume manager implemenation])
  case "$ac_bm_thunar_vfs_volume_impl" in
  freebsd)
    AC_DEFINE([THUNAR_VFS_VOLUME_IMPL_FREEBSD], [1], [Define to 1 if the FreeBSD volume manager implementation should be used])
    ;;

  hal)
    AC_DEFINE([THUNAR_VFS_VOLUME_IMPL_HAL], [1], [Define to 1 if the HAL volume manager implementation should be used])
    ;;

  *)
    AC_DEFINE([THUNAR_VFS_VOLUME_IMPL_NONE], [1], [Define to 1 if no volume manager implementation should be used])
    ;;
  esac
  AC_MSG_RESULT([$ac_bm_thunar_vfs_volume_impl])

  dnl # Set automake conditionals appropriately
  AM_CONDITIONAL([THUNAR_VFS_VOLUME_IMPL_FREEBSD], [test x"$ac_bm_thunar_vfs_volume_impl" = x"freebsd"])
  AM_CONDITIONAL([THUNAR_VFS_VOLUME_IMPL_HAL], [test x"$ac_bm_thunar_vfs_volume_impl" = x"hal"])
  AM_CONDITIONAL([THUNAR_VFS_VOLUME_IMPL_NONE], [test x"$ac_bm_thunar_vfs_volume_impl" = x"none"])
])
