/* -*- mode: c; c-file-style: "gnu" -*-
 * gzip.h -- gzip related function prototypes.
 * Copyright (C) 2003, 2004 Gergely Nagy <algernon@bonehunter.rulez.org>
 *
 * This file is part of Thy.
 *
 * Thy is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 dated June, 1991.
 *
 * Thy is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/** @file gzip.h
 * gzip related function prototypes.
 */

#ifndef _THY_GZIP_H
#define _THY_GZIP_H 1 /**< gzip.h multi-inclusion guard. */

#include "options.h"

#if THY_OPTION_ZLIB
#include <zlib.h>
#include "session.h"

int thy_zlib_send (session_t *session, void *buf, size_t size);
void thy_zlib_free (thy_zlib_session_t *session);

#endif /* THY_OPTION_ZLIB */

#endif /* ! _THY_GZIP_H */
